/**
 * Created by Administrator on 2017/11/28 0028.
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Form,
  // Input,
  // Select,
  // Button,
  Card,
  Row,
  Col,
  Icon,
  Modal,
  // DatePicker,
} from 'antd';
import NewCertificateDrawer from './NewCertificateDrawer';
import EditCertificateDrawer from './EditCertificateDrawer';
import './less/personnel.less';
import moment from 'moment';
import "moment/locale/zh-cn";
import {
  systemPerCerBaseInfoFindAll, //查询人员所有证书
  systemPerCerBaseInfoDelete, //删除证书
  publicCommonDictGetDictByCodeTypes //公共信息
} from '../../../services/api';

// const confirm = Modal.confirm;
// const FormItem = Form.Item;
// const { Option } = Select;
// const { RangePicker } = DatePicker;

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class CertificateInformationPage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      editCertificateOpen: false,
      newCertificateOpen: false,
      currentId: 0,
      visible: false,
      perType: '', //点击删除时对应的证书类型名
      confirmLoading: false,
      certificateInformation: [],
      perCerId: '',
      perCerType: [], //证书类型
      newPerCerType: [], //动态证书类型，新增是否有证书可选
      isShowNewAddPlus: false, //是否展示新增证书
      isCheck: false   //抽屉是否是查看状态还是编辑状态
    };
  }

  /**************************生命周期************************************/
  componentDidMount() {
    this.getAllType(); //获取所有类型
    // this.getAllCertificateInformation();
    this.setState({
      perId: this.props.perId
    });
  }

  /*****************************AJAX******************************************/
  //获得公共信息
  getAllType = () => {
    publicCommonDictGetDictByCodeTypes({ codeTypes: [' perCerType'] }).then(
      res => {
        //判断获取数据是否为空
        if (res.data) {
          const allTypeData = res.data;
          this.setState({
            perCerType: allTypeData.perCerType
            // perCerlevel: allTypeData.perCerlevel,
          });

          this.getAllCertificateInformation();
        }
      }
    );
  };
  //所有证书
  getAllCertificateInformation = () => {
    const perId = this.props.perId; //人员ID
    const { perCerType } = this.state;

    systemPerCerBaseInfoFindAll({ perId }).then(
      res => {
        if (res.retType === '0' && res.data) {
          this.setState({ certificateInformation: res.data });
          const currentList = Array.from(
            new Set(res.data.map(v => v.perCerType))
          );
          let newPerCerType = [];
          perCerType.forEach(element => {
            let tmp = element;
            let has = false;
            currentList.forEach(v => {
              if (v == element.codeValue) {
                has = true;
              }
            });
            if (!has) {
              newPerCerType.push(tmp);
            }
          });
          const isShowNewAddPlus = newPerCerType.length > 0 ? true : false;
          this.setState({
            newPerCerType,
            isShowNewAddPlus
          });
        }
      },
      err => {
        console.log('获取所有证书错误信息', err);
      }
    );
  };
  //删除证书
  deleteCertificate = perCerId => {
    systemPerCerBaseInfoDelete({ perCerId }).then(
      res => {
        this.getAllCertificateInformation();
      },
      err => {
        console.log('删除当前证书-错误信息', err);
      }
    );
  };

  /**********************************相关事件*************************************************/
  //新增证书抽屉
  changeNewDrawer = newCertificateOpen => {
    console.log('新增证书抽屉-参数open', newCertificateOpen);
    this.setState({ newCertificateOpen });
  };
  //编辑证书抽屉
  changeEditDrawer = (editCertificateOpen, currentId, checkBoolean) => {
    console.log('编辑证书抽屉-参数open', editCertificateOpen);
    console.log('当前Id', currentId);
    this.setState({ editCertificateOpen, currentId, isCheck: checkBoolean });
  };

  showModal = currentId => {
    this.setState({
      visible: true,
      perCerId: currentId
    });
    console.log(currentId);
    this.state.certificateInformation.map(item => {
      item.perCerId === currentId
        ? this.setState({ perType: item.perCerTypeName })
        : null;
    });
    console.log(this.state.certificateInformation);
  };
  handleOk = () => {
    this.setState({
      visible: false
    });
    console.log('删除ID', this.state.perCerId);
    this.deleteCertificate(this.state.perCerId);
  };
  handleCancel = () => {
    console.log('Clicked cancel button');
    this.setState({
      visible: false
    });
  };

  showCard = () => {
    const arrs = this.state.certificateInformation.map((val, index) => {
      return (
        <Col span={12} key={index}>
          <Card title={val.perCerTypeName ? val.perCerTypeName : '-'}>
            <p className='list-line'>
              <span>证书等级:</span>
              <span>{val.perCerLevelName ? val.perCerLevelName : '-'}</span>
            </p>
            <p className='list-line'>
              <span>证书编号:</span>
              <span>{val.cerNo}</span>
            </p>
            <p className='list-line'>
              <span>发证机关:</span>
              <span>{val.licenceOrg}</span>
            </p>
            <p className='list-line'>
              <span>发证日期:</span>
              <span>{moment(val.licenceDate).format('YYYY-MM-DD')}</span>
            </p>
            {
              val.isBbdSync != 1? (
              <ul className='ant-card-actions'>
                <li style={{ width: '50%' }}>
                  <span>
                    <div
                      className='edit'
                      onClick={this.changeEditDrawer.bind(
                        this,
                        true,
                        val.perCerId,
                        false
                      )}
                    >
                      编辑
                    </div>
                  </span>
                </li>
                <li style={{ width: '50%' }}>
                  <span>
                    <div>
                      <div
                        onClick={this.showModal.bind(this, val.perCerId)}
                        className='delete'
                      >
                        删除
                      </div>
                    </div>
                  </span>
                </li>
              </ul>
              ): (
                <ul className='ant-card-actions'>
                <li style={{ width: '50%' }}>
                  <span>
                    <div
                      className='edit'
                      onClick={this.changeEditDrawer.bind(
                        this,
                        true,
                        val.perCerId,
                        true
                      )}
                    >
                      查看
                    </div>
                  </span>
                </li>
                <li style={{ width: '50%' }}>
                  <span>
                    <div>
                      <div
                        style={{color: '#ddd'}}
                      >
                        删除
                      </div>
                    </div>
                  </span>
                </li>
              </ul>
              )
            }
          </Card>
        </Col>
      );
    });
    return arrs;
  };

  render() {
    const { visible, confirmLoading } = this.state;
    return (
      <div className='CertificateInformationPage'>
        <div>
          <Row gutter={16}>
            {/* 加载卡片信息 */}
            {this.showCard()}
            {/* {this.state.isShowNewAddPlus && (
              <Col span={12}>
                <div
                  className='new-add'
                  onClick={this.changeNewDrawer.bind(this, true)}
                >
                  <Icon type='plus' style={{ fontSize: '30px' }} />
                  <div style={{ color: '#333' }}>新增证书</div>
                </div>
              </Col>
            )} */}
          </Row>
        </div>

        {/* 删除模态框 */}
        <div>
          <Modal
            title='提示'
            visible={visible}
            onOk={this.handleOk}
            confirmLoading={confirmLoading}
            onCancel={this.handleCancel}
            okText='确认'
            cancelText='取消'
          >
            <p style={{ textAlign: 'center', fontSize: '14px', color: '#333' }}>
              <i
                className='anticon anticon-exclamation-circle'
                style={{
                  color: '#faad14',
                  fontSize: '22px',
                  marginRight: '16px',
                  verticalAlign: 'middle'
                }}
              />
              “{this.state.perType}”删除后不可找回！是否确认删除？
            </p>
          </Modal>
        </div>

        {/* 弹出新增证书-抽屉 */}
        <NewCertificateDrawer
          onChange={newCertificateOpen => {
            this.setState({ newCertificateOpen });
          }}
          visiable={this.state.newCertificateOpen}
          perId={this.props.perId}
          refreshList={() => {
            this.getAllCertificateInformation();
          }}
          perCerType={this.state.newPerCerType}
        />

        {/* 弹出编辑证书-抽屉 */}
        <EditCertificateDrawer
          onChange={editCertificateOpen => {
            this.setState({ editCertificateOpen });
          }}
          visiable={this.state.editCertificateOpen}
          perId={this.props.perId}
          currentId={this.state.currentId}
          refreshList={() => {
            this.getAllCertificateInformation();
          }}
          perCerType={this.state.perCerType}
          isCheck={this.state.isCheck}
        />
      </div>
    );
  }
}
