/**
 * Created by Administrator on 2017/11/28 0028.
 */
import React, { Component } from 'react';
import {
  Form,
  Input,
  Select,
  Row,
  Col,
  Button,
  DatePicker,
  message,
  TreeSelect,
  Modal,
  Table,
  Alert,
  Icon,
  notification
} from 'antd';
import { checkAage } from '../../../utils/utils';
import moment from 'moment';
import "moment/locale/zh-cn";
import { connect } from 'dva';

import './less/personnel.less';
import * as ajax from '../../../services/api';
import {domainConfig} from "../../../utils/config"

const FormItem = Form.Item;
const { Option } = Select;
const { confirm } = Modal;
@connect(state => ({
  global: state.global,
  insurance: state.insurance,
  companyInfo: state.global.companyInfo
}))
@Form.create()
class BasicInformationPage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      addpeoplevisible: false,
      addpeoplevisible1: false,
      dataSource: [],
      // comId:1,
      perTypeList: [], //人员类别
      confirmDirty: false,
      basicInFormaation: {
        name: '',
        perType: '',
        mobilePhone: '',
        idCardType: '1',
        idCardNo: '',
        roleId: [],
        entryDate: null,
        departId: '',
        isAppActive: '0',
        isAppAuth: '0', //1的话，就不能修改身份证，姓名，。手机号码;0的话可以修改。
        roleType: '',
        avatar: '',
        userName: '',
        email: ''
      },
      perId: '', //用户id
      idCardType: [],
      roldType: [], //角色下拉选择
      treeData: [
        //树
        { title: '', key: '' }
      ],
      roleId: '',
      selectedRowKeys: '',
      pagenav: {
        current: 1,
        // pageSize: 5000,
        pageSize: 10,
        showQuickJumper: true,
        showSizeChanger: true,
        showTotal: total => `总共 ${total} 条`,
        onShowSizeChange: (current, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = current;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.systemComDepartPage();
          });
        },
        onChange: (page, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = page;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.systemComDepartPage();
          });
        },
        total: 0
      },
      changePhoneState: false, //变更按钮显示状态
      newPhone: '' // 新手机号码值
    };
    this.handleClick = this.handleClick.bind(this);
  }

  componentDidMount() {
    this.renderIdcardType();
    this.roldList();
    this.departList();
    const { setFieldsValue } = this.props.form;
    // this.comInsGetComInsPage();
    setTimeout(() => {
      setFieldsValue({ mobilePhone: this.state.basicInFormaation.mobilePhone });
    }, 5000);
    this.renderPerType();
  }

  componentWillReceiveProps(props) {
    if (
      props.perId !== undefined &&
      props.perId !== '' &&
      props.perId !== this.props.perId
    ) {
      this.setState({
        perId: props.perId,
        reAddMember: props.reAddMember,  //判断是否是从离职人员过来的，为1的时候获取信息并且调用新增按钮
      });
      this.getPerBaseInfoGetPerBaseInfo(props.perId);
    }
  }

  //获取基本信息页面数据
  getPerBaseInfoGetPerBaseInfo = perId => {
    ajax.systemPerBaseInfoGetPerBaseInfo({ perId }).then(
      data => {
        const roleId = data.data.roleId ? data.data.roleId.split(',') : [];

        this.setState({
          basicInFormaation: {
            name: data.data.name,
            idCardType: data.data.idCardType || '1',
            mobilePhone: data.data.mobilePhone,
            idCardNo: data.data.idCardNo,
            departId: data.data.orgId,
            entryDate: data.data.entryDate,
            isAppActive: data.data.isAppActive || '0',
            isAppAuth: data.data.isAppAuth || '0',
            roleType: data.data.roleType || '',
            roleId,
            avatar: data.data.photoUrl,
            perType: data.data.perType,
            userName: data.data.userName || '',
            email: data.data.email || ''
          },
          roleId
        });
      },
      err => {
        console.log('errerr', err);
      }
    );
  };
  perTypeList = () => {
    return this.state.perTypeList.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };
  //获取人员类别
  renderPerType = () => {
    // debugger
    ajax.getPerType({ codeType: 'perType' }).then(
      response => {
        if (response.data) {
          this.setState({
            perTypeList: response.data
          });
        }
      },
      err => {
        console.log(err);
      }
    );
  };
  //证件类型选择
  renderIdcardType = () => {
    ajax
      .publicCommonDictGetDictByCodeTypes({ codeTypes: 'idCardType' })
      .then(data => {
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            idCardType: data.data.idCardType
          });
        }
      });
  };

  //提交
  handleSubmit = e => {
    e.preventDefault();
    
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        const { idCardNo, idCardType, perType } = values;
        const { regProvince } = this.props.global.companyInfo;
        // 判断年龄
        let ageRes = null;
        // 证件为身份证的时候
        if(idCardType == '1') {
          // '010001':普通保安 '010002': 武装押运人员
          if(perType == '010001' || perType == '010002' ) {
            // 通过身份证判断年龄是否符合要求
            ageRes = checkAage(idCardNo, regProvince);
          }
        }
        if(ageRes && ageRes.status != '0') {
          return Modal.warning({
            title: ageRes.text
          });
        }

        values.entryDate = values['entryDate'].format('YYYY-MM-DD');
        if (
          !/(1|2|3)/.test(this.state.basicInFormaation.roleType) ||
          this.state.basicInFormaation.roleType !== ''
        ) {
          if (values.roleId !== undefined) {
            values.roleId = values.roleId.join(',');
          } else {
            values.roleId = '';
          }
        } else {
          values.roleId = this.state.roleId;
        }
        // 修改的情况： 不是从离职列表中跳过来的，并且存在人员id的时候为修改的情况
        if (this.state.perId !== '' && this.state.reAddMember != 1) {
          //修改
          values.perId = this.state.perId;
          ajax
            .systemPerBaseInfoUpdateBaseInfo({ ...values })
            .then(res => {
              if (this.state.perId === this.props.currentUser.perId) {
                this.props.dispatch({
                  type: 'user/fetchCurrent'
                });
              }
              // this.props.props.history.push(
              //   `/PersonnelRecruitment/departmentmanagement`
              // );
            })
            .catch(err1 => console.log(err1, '修改基础信息-err1'));
        } else {
          // 没有人员id或者是从离职列表中跳转过来的情况调用新增接口
          //新增
          ajax
            .systemPerBaseInfoSaveBaseInfo({ ...values },  false, true)
            .then(async res => {
              console.log(res)
              this.props.getId(res.data.perId);
              console.log(res.data.reason)
              if(res.data.reason){
                Modal.warning({
                  title: '本次新增人员为行业黑名单人员',
                    content: <div style={{color:'red'}}>{'入单原因：'+res.data.reason}<div>若有疑问：请联系所属监管机构进行咨询。</div></div>,
                    okText:'知道了',
                    onOk: () => {
                      this.checkAddMember(res)
                    }
                })
              }else{
                this.checkAddMember(res)
              }            
              // let okCallBack = () => {
              //   this.props.props.history.push('/insurancemanagement/insurance-management?tab=1');
              // };
              if (this.state.dataSource.length > 0) {
                this.setState({
                  // 保险增员提示
                  perId: res.data,
                  addpeoplevisible: true
                });
              }
            })
            .catch(err2 => {
              notification.error({
                message: err2.msg
              });
            });
        }
      }
    });
  };

  checkAddMember(res){
    if(this.state.reAddMember != 1) {
      Modal.confirm({
        title: '提示',
        content: res.msg,
          icon: <Icon type="info-circle" />,
          okText: '继续新增',
          cancelText: '查看该人员',
          onOk: () => {
            // 重置
            this.props.form.resetFields();
            this.setState({
              perId: '',
              basicInFormaation: {
                name: '',
                perType: '',
                mobilePhone: '',
                idCardType: '1',
                idCardNo: '',
                roleId: [],
                entryDate: null,
                departId: '',
                isAppActive: '0',
                isAppAuth: '0', //1的话，就不能修改身份证，姓名，。手机号码;0的话可以修改。
                roleType: '',
                avatar: '',
                userName: '',
                email: ''
              }
            });
          },
          onCancel: () =>{
            this.props.handleChangeTab();
            this.props.props.history.replace(`/PersonnelRecruitment/departmentmanagement/PersonnelInformationNav?perId=${res.data.perId}`);
          }
        });
    }else {
      Modal.success({
        title: '提示',
        content: res.msg,
        icon: <Icon type="info-circle" />,
        okText: '返回离职列表',
        onOk: () => {
          this.props.handleChangeTab();
            this.props.props.history.replace(`/PersonnelRecruitment/departmentmanagement`);
        }
      });
    }
  }

  checkPassword = (rule, value, callback) => {
    const { form } = this.props.form;
    if (value && value !== form.getFieldValue('password')) {
      callback('Two passwords that you enter is inconsistent!');
    } else {
      callback();
    }
  };
  checkConfirm = (rule, value, callback) => {
    const { form } = this.props.form;
    if (value && this.state.confirmDirty) {
      form.validateFields(['confirm'], { force: true });
    }
    callback();
  };

  handleClick() {
    console.log(this);
  }

  renderIdCard = () => {
    return this.state.idCardType.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  //发送激活短信
  sendActivationSMS = () => {
    const { form } = this.props;
    const phoneValue = form.getFieldValue('mobilePhone').trim();
    if (phoneValue === '') {
      message.error('手机号码不能为空！');
    } else if (!/^1[0-9]{10}$/.test(phoneValue)) {
      message.error('手机号码格式不正确！');
    } else {
      ajax
        .systemPlatNewsSendActivationMessage({ mobile: phoneValue })
        .then(data => {
          if (data.data) {
            message.success(data.data);
          }
        });
    }
  };

  //验证证件号
  checkIdCardNo = (rule, value, callback) => {
    const { form } = this.props;
    const cardNoValue = form.getFieldValue('idCardType');
    if (
      cardNoValue === '1' &&
      value &&
      !/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value)
    ) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };

  //角色下拉选择
  roldList = () => {
    ajax.systemComRoleFindAllRole({}).then(data => {
      //判断获取数据是否为空
      if (data.data) {
        this.setState({
          roldType: data.data
        });
      }
    });
  };

  //角色下拉选择
  renderInstitution = () => {
    return this.state.roldType.map((val, key) => {
      return (
        <Option key={key} value={val.roleId + ''}>
          {val.roleName}
        </Option>
      );
    });
  };

  //保全链接生成
  enterpriseInsComInsGetOnlineInsBlbPreservationLink = () => {
    ajax
      .enterpriseInsComInsGetOnlineInsBlbPreservationLink({
        orderId: this.state.selectedRowKeys,
        perIds: this.state.perId,
        reviseType: '1'
      })
      .then(res => {
        this.setState({ addpeoplevisible1: false });
        this.newwin.location.href = res.data;
      })
      .catch(err => {
        this.newwin.close();
        this.setState({ addpeoplevisible1: false });
      });
  };

  //选择部门
  departList = () => {
    const recursion = (treeData) => {
      // TreeSelect组件所需值： title， value, key, children disabled
      return treeData.map(item => {
        item.title = item.departName;
        item.key = item.departId;
        item.value = item.departId;
        // "isExistsDataAuth": "1",  //权限 1有权限 0：没权限
        item.disabled = item.isExistsDataAuth == 0;
        if(item.childDepart) {
          item.children = recursion(item.childDepart);
        }
        return item;
      });
    }
    // 获取到组织架构列表
    ajax.systemComDepartGetDepartTree().then(res => {
      const DATA = recursion(res.data);
      this.setState({
        treeData: DATA,
        departId: DATA[0].key
      });
    });
    // ajax.systemComDepartGetDepartTree().then(
    //   response => {
    //     // console.log(response, 'getTreeDepart-选择部门-response');
    //     // let { data } = response;
    //     // data = JSON.parse(
    //     //   JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
    //     // );
    //     // this.setState({
    //     //   treeData: data,
    //     //   departId: data[0].key
    //     // });
    //   },
    //   err => {
    //     console.log(err, 'getTreeDepart-选择部门-err');
    //   }
    // );
  };

  renderBack = () => {
    const that = this;
    if (that.state.isBack) {
      // that.props.props.history.push(`/Organization/departmentmanagement`);
      that.props.props.history.push(
        `/PersonnelRecruitment/departmentmanagement`
      );
    } else {
      confirm({
        title: '是否确认返回？',
        okText: '确认',
        cancelText: '取消',
        onOk() {
          // that.props.props.history.push(`/Organization/departmentmanagement`);
          that.props.props.history.push(
            `/PersonnelRecruitment/departmentmanagement`
          );
        },
        onCancel() {
          console.log('Cancel');
        }
      });
    }
  };

  //保险选择
  renderTable = () => {
    const rowSelection = {
      type: 'radio',
      selectedRowKeys: this.state.selectedRowKeys,
      onChange: selectedRowKeys => {
        this.setState({ selectedRowKeys });
      },
      getCheckboxProps: record => ({
        disabled: record.name === 'Disabled User' // Column configuration not to be checked
      })
    };
    const columns = [
      {
        title: '订单号',
        dataIndex: 'blbOrderId',
        key: 'blbOrderId'
      },
      {
        title: '保险产品',
        dataIndex: 'insComName',
        key: 'insComName'
      },
      {
        title: '人数',
        dataIndex: 'perNum',
        key: 'perNum'
      },
      {
        title: '购买时间',
        dataIndex: 'effectStartDate',
        key: 'effectStartDate'
      }
      /* {
        title: "保费(元)",
        dataIndex: "effectStartDate",
        key: "effectStartDate"
      } */
    ];

    return (
      <Table
        size="middle"
        width={800}
        rowSelection={rowSelection}
        columns={columns}
        pagination={false}
        dataSource={this.state.dataSource}
      />
    );
  };

  //变更按钮
  changePhoneButton = () => {
    this.setState({
      changePhoneState: true
    });
  };

  //变更弹框中新手机号码值
  inputNewPhone = e => {
    this.setState({
      newPhone: e.target.value.trim()
    });
  };

  //改变手机号码
  changePhoneSubmit = () => {
    ajax
      .systemPerBaseInfoUpdateMobile({
        newMobile: this.state.newPhone,
        perId: this.state.perId
      })
      .then(data => {
        this.setState({
          changePhoneState: false
        });
        const { setFieldsValue } = this.props.form;
        setFieldsValue({ mobilePhone: this.state.newPhone });
        this.getPerBaseInfoGetPerBaseInfo(this.state.perId); //重新请求基础信息数据
      })
      .catch(err => console.log(err, '改变手机号码失败'));
  };

  render() {
    const { getFieldDecorator } = this.props.form;
    let provinceId =  this.props.companyInfo.regProvince
    // const { autoCompleteResult } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 12 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 12 },
        sm: { span: 8 }
      }
    };
    const tailFormItemLayout = {
      wrapperCol: {
        xs: {
          span: 24,
          offset: 0
        },
        sm: {
          span: 14,
          offset: 6
        }
      }
    };

    const phFormItemLayout = {
      labelCol: {
        xs: { span: 16 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 18 },
        sm: { span: 12 }
      }
    };
    const spanStyle = {
      color: '#909CA8'
    };
    const clickStyle = {
      color: '#1890ff',
      cursor: 'pointer'
    };
    const msg =
      this.state.basicInFormaation.isAppActive === '0' ? (
        <p>
          <span style={spanStyle}>
            首次导入人员信息，默认发送短信通知该用户激活帐号。未收到可再次点击
          </span>
          <span onClick={this.sendActivationSMS} style={clickStyle}>
            "发送激活短信"
          </span>
        </p>
      ) : (
        ''
      );
    return (
      <div className="BasicInformationPage clearfloat PersonnelGeneralStyle">
        <div className="basic-right general-main">
          <div className="from-box">
            <Form onSubmit={this.handleSubmit}>
              <FormItem
                className="head-portrait"
                {...formItemLayout}
                label="头像"
              >
                <div className="pic">
                  {this.state.basicInFormaation.avatar ? (
                    <img
                      src={this.state.basicInFormaation.avatar}
                      alt="avatar"
                      style={{
                        width: '100%',
                        height: '100%',
                        borderRadius: '50%'
                      }}
                    />
                  ) : (
                    <span
                      style={{
                        width: '100%',
                        height: '100%',
                        textAlign: 'center',
                        display: 'inline-block',
                        lineHeight: '58px',
                        color: '#999'
                      }}
                    >
                      暂无
                    </span>
                  )}
                </div>
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="人员类别"
                className="fixed-width"
              >
                {getFieldDecorator('perType', {
                  initialValue: this.state.basicInFormaation.perType,
                  rules: [{ required: true, message: '请选择人员类别!' }]
                })(
                  <Select
                    className="width-400"
                    placeholder="请选择"
                    disabled={this.props.companyInfo.industryType === '02' && this.state.perId !== ''}
                  >
                    {this.perTypeList()}
                  </Select>
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="姓名"
                className="fixed-width"
              >
                {getFieldDecorator('name', {
                  initialValue: this.state.basicInFormaation.name,
                  rules: [
                    { required: true, message: '请输入你的姓名!' },
                    {
                      validator: (rule, value, cb) => {
                        if (
                          value.length>50
                          // value.length > 0 &&
                          // !/^[\u4E00-\u9FA5A-Za-z]+$/.test(value)
                        ) {
                          // cb('请输入英文或汉字!');
                          cb('姓名不能大于50个字符！');
                        }
                        cb();
                      }
                    },
                    {
                      validator: (rule, value, cb) => {
                        if (
                          value.trim() == ''
                        ) {
                          cb('姓名不能为空白字符！');
                        }
                        cb();
                      }
                    }
                  ]
                })(
                  <Input
                    className="w-400"
                    placeholder="请输入"
                    maxLength={16}
                    // 人员认证状态为1，2的时候不更改
                    disabled={
                      this.state.basicInFormaation.isAppAuth === '1'||this.props.authStatus == "1" || 
                      this.props.authStatus == "2" ||
                      this.state.reAddMember == 1   // 复职
                    }
                  />
                )}
                {
                  this.props.authStatus == "1" || this.props.authStatus == "2"&&
                  <div className="form_tip">
                    <span>当前身份信息认证中</span>
                  </div>
                }
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="证件类型"
                className="document-type lmb-sd"
              >
                {getFieldDecorator('idCardType', {
                  initialValue: this.state.basicInFormaation.idCardType,
                  rules: [{ required: true, message: '请选择证件类型!' }]
                })(
                  <Select
                    placeholder="请选择"
                    style={{ width: '400px' }}
                    onChange={this.handleChangeIdCardType}
                    
                    disabled={
                      this.state.basicInFormaation.isAppAuth === '1' ||
                      this.state.reAddMember == 1 //复职
                    }
                  >
                    {this.renderIdCard()}
                  </Select>
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="证件号码"
                className="fixed-width certificate-number"
              >
                {getFieldDecorator('idCardNo', {
                  initialValue: this.state.basicInFormaation.idCardNo,
                  rules: [
                    { required: true, message: '请输入证件号!' },
                    { validator: this.checkIdCardNo }
                  ]
                })(
                  <Input
                    className="w-400"
                    placeholder="请填写证件号码"
                    maxLength={20}
                    // onChange={e => {
                    //   const idCardNo = e.target.value;
                    //   const { regProvince } = this.props.global.companyInfo;
                      
                    //   const { getFieldValue } = this.props.form;
                    //   const idCardType = getFieldValue('idCardType');
                    //   const perType = getFieldValue('perType');
                    //   // 证件为身份证的时候
                    //   if(idCardType == '1') {
                    //     // '010001':普通保安 '010002': 武装押运人员
                    //     if(perType == '010001' || perType == '010002' ) {
                    //       const ageRes = checkAage(idCardNo, regProvince);
                    //       if(ageRes.status == '-1') {
                    //         Modal.warning({
                    //           title: checkPerRes.text
                    //         });
                    //       }
                    //     }
                    //   }
                    //   // if(ageRes.status == '-1') {
                        
                    //   // }
                    

                    // }}
                    // 人员认证状态为1，2的时候不更改 （已认证，认证中）
                    disabled={
                      this.state.basicInFormaation.isAppAuth === '1'|| this.props.authStatus == "1" || 
                      this.props.authStatus == "2" ||
                      this.state.reAddMember == 1   // 复职
                    }
                  />
                )}
              </FormItem>
              {this.state.perId !== '' ? (
                <FormItem
                  {...formItemLayout}
                  label="用户名"
                  className="fixed-width"
                >
                  {getFieldDecorator('userName', {
                    initialValue: this.state.basicInFormaation.userName,
                    rules: [{ required: true }]
                  })(
                    <Input
                      className="w-400"
                      placeholder="请输入"
                      maxLength={16}
                      disabled
                    />
                  )}
                </FormItem>
              ) : null}
              <FormItem
                {...phFormItemLayout}
                label="手机号"
                className="fixed-width"
                // extra={msg}
                extra={this.state.perId != ""? msg: ''}
              >
                <Row gutter={24}>
                  <Col span={24}>
                    {getFieldDecorator('mobilePhone', {
                      initialValue: this.state.basicInFormaation.mobilePhone,
                      rules: [
                        { required: true, message: '请输入手机号码!' },
                        {
                          validator: (rule, value, cb) => {
                            if (value && !/^1[0-9]{10}$/.test(value.trim())) {
                              cb('请输入正确手机号码!');
                            }
                            cb();
                          }
                        }
                      ]
                    })(
                      <Input
                        className="w-400 ipt-h"
                        placeholder="请输入"
                        // disabled={this.state.basicInFormaation.isAppAuth === '1'}
                        disabled={!!this.state.perId}
                      />
                    )}
                  </Col>
                  {/* <Col span={4} className="verification-code" /> */}
                  {
                    // this.state.reAddMember == 1? '':
                    <Col span={4} className="verification-code">
                      <Button
                        onClick={this.changePhoneButton}
                        type="primary"
                        // style={{
                        //   display:
                        //     !!this.state.perId &&
                        //     this.state.basicInFormaation.isAppAuth === '0'
                        //       ? 'block'
                        //       : 'none'
                        // }}
                      >
                        变更
                      </Button>
                    </Col>
                  }
                </Row>
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="邮箱"
                className="fixed-width"
              >
                {getFieldDecorator('email', {
                  initialValue: this.state.basicInFormaation.email,
                  rules: [
                    {
                      validator: (rule, value, cb) => {
                        if (
                          value.length > 0 &&
                          !/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z0-9]{2,6}$/.test(
                            value
                          )
                        ) {
                          cb('请输入正确的邮箱地址!');
                        }
                        cb();
                      }
                    }
                  ]
                })(
                  <Input
                    className="w-400"
                    placeholder="请输入"
                    maxLength={50}
                  />
                )}
              </FormItem>
              
              
              {
                // 新增的时候不需要角色选项
                !!this.props.perId && (!/(1|2|3)/.test(this.state.basicInFormaation.roleType) ||
              this.state.basicInFormaation.roleType === '') ?
               (
                <FormItem
                  {...formItemLayout}
                  label="角色"
                  className="fixed-width"
                  extra={this.state.perId?<span style={{color: 'orange'}}>若需要修改人员角色，请访问【人事管理】-【角色权限】页面添加该人员到角色成员下。</span>: ''}
                >
                  {getFieldDecorator('roleId', {
                    initialValue: this.state.basicInFormaation.roleId,
                    rules: [
                      {
                        required: false,
                        message: '请选折你要的角色1',
                        type: 'array'
                      }
                    ]
                  })(
                    <Select
                      mode="multiple"
                      placeholder="请选择角色"
                      className="w-400 ipt-h"
                      disabled={!!this.state.perId}
                    >
                      {this.renderInstitution()}
                    </Select>
                  )}
                </FormItem>
              ) : (
                ''
              )}
              
              {/* 复职人员不显示之前的所属部门 */}
              {this.state.departId && this.props.reAddMember != 1 ? (
                <FormItem
                  {...formItemLayout}
                  label="所属部门"
                  className="fixed-width"
                >
                  {getFieldDecorator('departId', {
                    initialValue: this.state.basicInFormaation.departId,
                    rules: [{ required: true, message: '请选择所属部门' }]
                  })(
                    <TreeSelect
                      className="w-400 ipt-h"
                      dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
                      treeData={this.state.treeData}
                      placeholder="请选择部门"
                      treeDefaultExpandAll
                    />
                  )}
                </FormItem>
              ) : (
                <FormItem
                  {...formItemLayout}
                  label="所属部门"
                  className="fixed-width"
                >
                  {getFieldDecorator('departId', {
                    rules: [{ required: true, message: '请选择所属部门' }]
                  })(
                    <TreeSelect
                      className="w-400 ipt-h"
                      dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
                      treeData={this.state.treeData}
                      placeholder="请选择部门"
                      treeDefaultExpandAll
                    />
                  )}
                </FormItem>
              )}
              

              {/* 复职人员不显示之前的入职日期 */}
              {this.state.basicInFormaation.entryDate && this.props.reAddMember != 1 ? (
                <FormItem
                  {...formItemLayout}
                  label="入职日期"
                  className="fixed-width"
                >
                  {getFieldDecorator('entryDate', {
                    initialValue: moment(
                      this.state.basicInFormaation.entryDate,
                      'YYYY-MM-DD'
                    ),
                    rules: [{ required: true, message: '请选择日期!' }]
                  })(<DatePicker className="w-400" disabled={provinceId==110000} />)}
                </FormItem>
              ) : (
                <FormItem
                  {...formItemLayout}
                  label="入职日期"
                  className="fixed-width"
                >
                  {getFieldDecorator('entryDate', {
                    initialValue: provinceId==110000?moment(
                      moment().format(),
                      'YYYY-MM-DD'
                    ):"",
                    rules: [{ required: true, message: '请选择日期!' }]
                  })(<DatePicker className="w-400" disabled={provinceId==110000}/>)}
                </FormItem>
                )}
              <FormItem {...tailFormItemLayout}>
                <Button
                  style={{ marginRight: '8px' }}
                  onClick={this.renderBack}
                >
                  返回
                </Button>
                {this.state.perId === '' || this.state.reAddMember == 1 ? (
                  <Button type="primary" htmlType="submit">
                    确认新增
                  </Button>
                ) : (
                  <Button type="primary" htmlType="submit">
                    确认修改
                  </Button>
                )}
              </FormItem>
            </Form>
            <Modal
              className="reducepeople"
              title="保险员增员提示"
              visible={this.state.addpeoplevisible}
              onOk={this.handlereducepeopleOk}
              onCancel={() => this.setState({ addpeoplevisible: false })}
              footer={[
                <Button
                  key="cancel"
                  onClick={() => this.setState({ addpeoplevisible: false })}
                >
                  取消
                </Button>,
                <Button
                  key="submit"
                  type="primary"
                  onClick={() => {
                    this.setState({
                      addpeoplevisible: false,
                      addpeoplevisible1: true
                    });
                  }}
                >
                  马上办理
                </Button>
              ]}
            >
              <div>
                <div>
                  <Alert
                    message="保险产品的增员、减员、替换等操作可通过【金融保险】-【保险订单】-选择有效订单的【保全】对保单中的人员增减操作！"
                    type="warning"
                    showIcon
                  />
                </div>
                <p>
                  本次新增人员共1
                  位，企业目前已购买团意险产品[产品名称]（订单号：[订单编号]），企业可对新增人员办理保险保全的增员操作。
                </p>
              </div>
            </Modal>

            <Modal
              width={1000}
              title="选择订单"
              visible={this.state.addpeoplevisible1}
              onCancel={() => this.setState({ addpeoplevisible1: false })}
              footer={[
                <Button
                  key="submit1"
                  onClick={() => {
                    this.setState({ addpeoplevisible1: false });
                  }}
                >
                  取消
                </Button>,
                <Button
                  key="submit"
                  type="primary"
                  onClick={() => {
                    if (!this.state.selectedRowKeys) {
                      message.error('请选择订单');
                      return null;
                    }
                    this.newwin = window.open('about:blank');
                    this.enterpriseInsComInsGetOnlineInsBlbPreservationLink();
                  }}
                >
                  确认
                </Button>
              ]}
            >
              {this.renderTable()}
            </Modal>

            <Modal
              title="变更手机号码"
              visible={this.state.changePhoneState}
              onCancel={() => this.setState({ changePhoneState: false })}
              footer={[
                <Button
                  key="1"
                  onClick={() => {
                    this.setState({ changePhoneState: false });
                  }}
                >
                  取消
                </Button>,
                <Button
                  key="2"
                  type="primary"
                  onClick={() => {
                    if (!/^1[0-9]{10}$/.test(this.state.newPhone)) {
                      message.error('请输入正确手机号码!');
                      return null;
                    } else {
                      //提交手机号码更改
                      this.changePhoneSubmit();
                    }
                  }}
                >
                  确定变更
                </Button>
              ]}
            >
              <div>
                <label style={{ display: 'block' }}>
                  旧手机号码：
                  <Input
                    style={{ width: '214px', marginBottom: '10px' }}
                    value={this.state.basicInFormaation.mobilePhone}
                    maxLength={11}
                    disabled
                  />
                </label>
                <label style={{ display: 'block' }}>
                  新手机号码：
                  <Input
                    style={{ width: '214px', marginBottom: '10px' }}
                    placeholder="请输入新的手机号码"
                    onChange={this.inputNewPhone}
                    value={this.state.newPhone}
                    maxLength={11}
                  />
                </label>
                <span style={{ color: '#ffb300', width: '200px' }}>
                  注意：提交变更手机号码后，系统将给新手机号码发送密码，请使用短信通知的密码进行登录。
                </span>
              </div>
            </Modal>
          </div>
        </div>
      </div>
    );
  }
}

export default connect(state => ({
  currentUser: state.user.currentUser,
  companyInfo: state.global.companyInfo
}))(BasicInformationPage);
