import React, { Component } from 'react';
import { connect } from 'dva';
import { Form, Input, Button, Drawer, Switch, Radio, TreeSelect } from 'antd';
const { SHOW_PARENT } = TreeSelect;
// const FormItem = Form.Item;
import './less/depart.less';
import { getDepartAppAuthInfo } from '../../../services/api';

// const { MenuItemGroup } = Menu;

@connect(state => ({
  profile: state.profile
}))
@Form.create()

/**
 * 部门管理组件
 */
export default class AppDrawer extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: this.props.visible,
      treeData: this.props.treeData,
      departId: '',
      limitSeeAppType: '1', //限制查看App通讯录类型
      limitSeeAppSwitch: 0, // 0关  1开
      visibleDepartIdList: []
    };
  }
  componentDidMount() {
    
  }
  componentWillReceiveProps(nextProps) {
    // 先更新部门树 (考虑有删除部门的情况)
    const treeData = JSON.parse(JSON.stringify(nextProps.treeData));
    if(treeData[0]) {
      treeData[0].disabled = true;
      this.setState({
        treeData
      });
    }
    this.setState({
      visible: nextProps.visible
    });
    const departId = nextProps.departId;
    // 更新departId以后获取设置信息
    if(this.state.departId !== departId) {
      if(departId != '' && departId != undefined && departId != '-1') {
        
        // 获取状态数据
        getDepartAppAuthInfo({departId}).then(res => {
          let { limitSeeAppSwitch, limitSeeAppType, visibleDepartIdList } = res.data;

          visibleDepartIdList = JSON.parse(JSON.stringify(visibleDepartIdList)).filter(item => this._idIsInTree(item));

          // limitSeeAppSwitch = limitSeeAppSwitch == 1? true: false;
          this.setState({
            departId,
            // ...res.data
            limitSeeAppSwitch,
            limitSeeAppType,
            visibleDepartIdList
          });
        }); 
      }
    }
  }

  _idIsInTree(id) {
    const treeData = JSON.parse(JSON.stringify(this.state.treeData));
    let boo = false;
    function recursion (arr) {
      for(let i = 0; i < arr.length; i++) {
        if(arr[i].departId == id) {
          boo = true;
          break;
        }
        if(arr[i].childDepart) {
          recursion(arr[i].childDepart);
        }
      }
    }
    recursion(treeData);
    return boo;
  }
  render() {
    // const { getFieldDecorator, setFieldsValue } = this.props.form;
    const radioStyle = {
      display: 'block',
      height: '30px',
      lineHeight: '30px',
    };
    return (
      <Drawer
        title="App通讯录设置"
        visible={this.state.visible}
        width={594}
        zIndex={100}
        onClose={this.props.onCancel}
      >
        <div
          style={{
            backgroundColor: '#fff',
            width: '100%',
            height: '100%'
          }}
        >
          <div>
            <div className="app_container">
              <span>限制本部门成员查看App通讯录</span>
              <Switch
                style={{
                  marginLeft: 10
                }}
                checked={
                  this.state.limitSeeAppSwitch == 1
                }
                onChange={checked => {
                  this.setState({
                    limitSeeAppSwitch: checked? 1: 0
                  });
                }}
              />
              <p style={{
                color: '#FFAA00'
              }}>开启后限制本部门成员只能查看到限定范围内的人员信息。</p>
            </div>
            {
              this.state.limitSeeAppSwitch != 0 &&
              <Radio.Group
                // disabled={
                //   this.state.limitSeeAppSwitch == 0
                // }
                style={{
                  marginTop: 15
                }}
                onChange={e => {
                  this.setState({
                    limitSeeAppType: e.target.value
                  })
                }}
                value={this.state.limitSeeAppType}
              >
                <Radio style={radioStyle} value={'1'}>
                  只能看到自己
                </Radio>
                <Radio style={radioStyle} value={'2'}>
                  只能看到所在部门人员
                </Radio>
                <Radio style={radioStyle} value={'3'}>
                  只能看到所在部门及下级部门人员
                </Radio>
                <Radio style={radioStyle} value={'4'}>
                  只能看到指定部门人员
                </Radio>
              </Radio.Group>
            }
            {
              this.state.limitSeeAppSwitch == 1 && this.state.limitSeeAppType == '4' && 
              <div>
                <TreeSelect 
                  style={
                    {width: 300,}
                  }
                  value={this.state.visibleDepartIdList}
                  placeholder="请选择"
                  treeData={this.state.treeData}
                  // treeCheckable={true}
                  treeDefaultExpandAll
                  allowClear
                  multiple
                  // showCheckedStrategy={SHOW_PARENT}
                  onChange={value => {
                    this.setState({
                      visibleDepartIdList: value
                    });
                  }}
                />
              </div>
            }



            {/* <Form
              onSubmit={this.handleSubmit}
              style={{ marginTop: 24 }}
            > */}
              <div
                style={{
                  position: 'absolute',
                  left: 0,
                  bottom: 0,
                  width: '100%',
                  borderTop: '1px solid #e9e9e9',
                  padding: '10px 16px',
                  background: '#fff',
                  textAlign: 'right',
                }}
              >
                <Button onClick={() => {
                  this.props.onCancel();
                }} style={{ marginRight: 8 }}>
                  取消
                </Button>
                <Button onClick={() => {
                  let { departId, limitSeeAppSwitch, limitSeeAppType, visibleDepartIdList } = this.state;
                  this.props.onOk({
                    departId,
                    limitSeeAppSwitch,
                    limitSeeAppType,
                    visibleDepartIds: visibleDepartIdList.join(',')
                  });
                }} type="primary">
                  确定
                </Button>
              </div>
            {/* </Form> */}
          </div>
        </div>
      </Drawer>
    );
  }
}
