import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import style from 'styled-components';
import { Button, Icon } from 'antd';
import { connect } from 'dva';

import { systemComVaseInfoGet } from '../../../services/api';

// const { Step } = Steps;

/**
 * 初始化配置完成
 */
@connect()
export default class InitializationCompleted extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // count: 0,
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {};
  componentWillReceiveProps = () => {};
  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  // transferMsg(currentPage) {
  //     this.setState({
  //         currentPage
  //     });
  //   }

  /******************************render******************************/

  render() {
    const _this = this;
    return (
      <Container>
        <Icon type="check-circle" className="icon" />
        <p className="t1">企业初始化完成</p>
        <p className="t2">恭喜您已完成初始化任务，开始体验更多服务～</p>
        {/* <div className="btn" onClick={() => this.props.history.push("/Organization/departmentmanagement?model=init")}>
          开始体验
        </div> */}
        <div
          className="btn"
          onClick={() => {
            // systemComVaseInfoGet-response-更新企业详情
            systemComVaseInfoGet({}).then(
              response => {
                this.props.dispatch({
                  type: 'global/companyInfo',
                  payload: response.data
                });
              },
              err => {
                console.log(err, 'systemComVaseInfoGet-err-获取企业详情');
              }
            );
            this.props.history.push(
              '/PersonnelRecruitment/departmentmanagement?model=init'
            );
          }}
        >
          开始使用
        </div>
      </Container>
    );
  }
}

/*********************样式*************************** */
const Container = style.div`{
    margin:0 auto;
    text-align:center;
    .icon{
      font-size:70px;
      color:#00CB28;
      margin-top:6px;
    }
    .t1{
      margin:20px 0 24px 0;
      font-size: 20px;
      color: #333333;
    }
    .t2{
      font-size: 14px;
      color: #999999;
      line-height: 14px;
    }
    .btn{
      background: #0F71FF;
      border-radius: 4px;
      padding: 5px 38px;
      display: inline-block;
      color: #fff;
      cursor: pointer;
    }
}`;
