import React, {PureComponent} from 'react';
// import { connect } from 'dva';
import style from "styled-components";
import {Steps} from 'antd';
import InitialRoleGroup from "./InitialConfigure/InitialRoleGroup";
import InitialRole from "./InitialConfigure/InitialRole";
import InitialPermissions from "./InitialConfigure/InitialPermissions";

const {Step} = Steps;

/**
 * 配置角色及权限
 */
export default class InitialConfigure extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      configureStep: 0,
      cursor: 1
    };

  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }
  componentWillReceiveProps = () => {

  }

  /******************************ajax请求******************************/

    //下一步
  nextStep = () => {
    const {cursor} = this.state;
    if (cursor !== 3) {
      this.setState({
        cursor: cursor + 1
      })
    } else {
      this.props.nextStep();
    }
  }

  /******************************相关事件******************************/


  /******************************render******************************/

  render() {

    const {cursor} = this.state;

    const CurrentItem = {
      1: <InitialRoleGroup/>,
      2: <InitialRole/>,
      3: <InitialPermissions/>
    }

    return (
      <Container>
        <div>
          <div className="nextstep" onClick={this.nextStep}>下一步</div>
          <header className="password-header">配置角色及权限</header>
        </div>
        <div className="configure-step">
          <Steps size="small" current={this.state.cursor - 1}>
            <Step title="配置角色组"/>
            <Step title="配置角色"/>
            <Step title="分配权限"/>
          </Steps>
        </div>
        <div className="configure-content">
          {CurrentItem[cursor]}
        </div>
      </Container>
    );
  }
}

/*********************样式*************************** */
const Container = style.div`{
    .password-header{
        font-size: 20px;
        color: #333333;
        padding-bottom:16px;
        border-bottom:1px solid #e9e9e9;
    }
    .configure-step{
        margin:24px 34px;
    }
    .nextstep{
      font-size: 14px;
      color: #0F71FF;
      line-height: 14px;
      border: 1px solid #0F71FF;
      border-radius: 4px;
      float: right;
      padding: 8px 14px;
      margin-top: 3px;
      cursor: pointer;
    }
}`;
