import React, { Component } from 'react';
import { connect } from 'dva';
import moment from 'moment';
import {
  Form,
  Input,
  Select,
  Button,
  Upload,
  Icon,
  Modal,
  Alert,
  DatePicker,
  InputNumber,
  message
} from 'antd';
import style from 'styled-components';
import * as ajax from '../../../services/api';
import PFromUpload from '../../../components/Pro/PFromUpload';
// import styles from './Company.less';
import './Company.less';
import PSelect from '../../../components/Pro/PSelect';

const FormItem = Form.Item;
const { Option } = Select;
const InputGroup = Input.Group;
const { confirm } = Modal;
const { TextArea } = Input;

const dateFormat = 'YYYY-MM-DD';

@connect(state => ({
  profile: state.profile,
  currentUser: state.user.currentUser.userName,
  companyInfo: state.global.companyInfo
}))
@Form.create()
/** 企业认证信息 */
export default class Authentication extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      selectedIdCardType: '',
      status: '',
      conf_securityLicenseUrl: '', //行业资质 图片上传
      // "comCerUrl":'',
      // "conf_securityLicenseUrl":"",
      conf_armedLevel: [], //武装押运守护等级
      conf_association: [], //所属行业保安协会
      conf_manpowerLevel: [], //人力防范等级
      conf_riskLevel: [], //风险评估等级
      conf_safeRange: [], //安全范围
      conf_safeTechLevel: [], //安全技术防范等级
      message: '',
      loading: false,
      btnVisible: true,
      getting: false, //获取验证码,判断是否正在获取中,true,正在获取中
      countDown: 60, //倒计时60秒
      gettingNoPhone: false, //法人手机号未验证时
      countDownNoPhone: 60, //法人手机号未验证时倒计时
      certificationData: {
        legalRepName: '',
        nationality: '',
        idCardNo: '',
        certificationType: '', //企业
        legalRepPhone: '',
        idCardType: '',
        regAmount: '',
        fixedAssets: '',
        annualTurnover: '',
        annualProfitTax: '',
        comCerType: '',
        comCerUrl: '',
        comCerNo: '',
        authStatus: '0' //认证状态
      },
      qualificationsData: {
        conf_armedLevel: [], //武装押运守护等级
        conf_association: [], //所属行业保安协会
        conf_manpowerLevel: [], //人力防范等级
        conf_riskLevel: [], //风险评估等级
        conf_safeRange: [], //安全范围
        conf_safeTechLevel: [], //安全技术防范等级
        conf_securityLicenseNum: '', //保安服务许可证号
        conf_securityLicenseUrl: '' //保安服务许可证
      },
      idCardType: [], //身份证选择
      nationality: [], //国籍
      certificationType: [], //企业
      visibleCode: false, //法人手机号存在时验证码弹窗
      visibleNoPhoneCode: false, //法人手机号不存在时验证码弹窗
      phoneHas: '123',
      // phoneLegalRepCode:'',//法人手机验证码
      modalLegPerson: true,
      modalFooter: true, //是否显示modal的footer
      noPhoneContent: '', //法人手机号为空时是否展示下一个弹窗
      hasPnone: '',
      modalFooterNoPhone: true, //法人手机号为空时是否显示modal的footer
      phone_yin: '', //手机号中间隐藏四位
      color_abc: true, //验证码下的P标签是否出现
      statusBianDisabled: false,
      showIndustry: false, //隐藏特殊资质信息；10-11，冠男取消隐藏
      institutionType: '', //企业基础信息，企业机构类型
      specialArray: [],
      administratorRelative: {
        administrator: '', // 管理员名字
        phoneValue: '', // 管理员电话
        openValidAdminModal: false,
        phoneValueHiddenMiddle: '', // 带*号的管理员手机号
        hasValidCode: false, // 管理员手机验证码
        isValidCode: false, // 管理员手机验证码是否正确
        countDownNoPhone: 60 // 管理员手机验证码倒计时
      }
    };
  }

  /****
   * 特殊字段
   */
  showSpecialFields = () => {
    const arr = this.state.specialArray.map((value, index) => {
      return (
        <div key={index}>
          {this.renderMap(
            value.fieldType,
            value.fieldName,
            value.fieldCode,
            parseInt(value.isRequired, 10),
            value.fieldValue,
            value.maxLength,
            value.fieldOptions,
            value.scriptFunction,
            value.isEdit,
          )}
        </div>
      );
    });
    return arr;
  };

  renderMap = (
    fieldType,
    fieldName,
    fieldCode,
    isRequired,
    fieldValue,
    maxLength,
    fieldOptions,
    scriptFunction,
    isEdit,
  ) => {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    if (fieldType === '1') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(
            <Input
              disabled={this.state.statusBianDisabled||isEdit==='0'}
              placeholder="请输入"
              maxLength={maxLength}
            />
          )}
        </FormItem>
      );
    } else if (fieldType === '2') {
      let max;
      if (maxLength) {
        max = Number(1 + new Array(parseInt(maxLength, 10) + 1).join('0')) - 1;
      } else {
        max = 999999;
      }
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(
            <InputNumber disabled={isEdit==='0'} min={1} max={max} maxLength={maxLength} />
          )}
        </FormItem>
      );
    } else if (fieldType === '3') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue ? moment(fieldValue, dateFormat) : null,
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              },
              {
                validator: (rule, value, callback) => {
                  const moment = require('moment');
                  scriptFunction
                    ? eval(`${scriptFunction}`)(rule, value, callback)
                    : callback();
                }
              }
            ]
          })(
            <DatePicker
              disabled={this.state.statusBianDisabled||isEdit==='0'}
              placeholder="请选择"
              style={{ width: '100%' }}
            />
          )}
        </FormItem>
      );
    } else if (fieldType === '4') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(
            <Select
              disabled={this.state.statusBianDisabled||isEdit==='0'}
              placeholder="请选择"
              className="sls-style"
            >
              {/* <Option value=" ">请选择</Option> */}
              {fieldOptions.map((val, i) => {
                return (
                  <Option key={i} value={val.split(':')[0] + ''}>
                    {val.split(':')[1]}
                  </Option>
                );
              })}
            </Select>
          )}
        </FormItem>
      );
    } else if (fieldType === '5') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(
            <Select
              mode="multiple"
              style={{ width: '100%' }}
              placeholder="请选择"
              disabled={this.state.statusBianDisabled||(fieldName=='经营范围'?true:isEdit==='0')}
            >
              {fieldOptions.map((val, i) => {
                return (
                  <Option key={i} value={val.split(':')[0] + ''}>
                    {val.split(':')[1]}
                  </Option>
                );
              })}
            </Select>
          )}
        </FormItem>
      );
    } else if (fieldType === '8') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(<PFromUpload num={1} disabled={this.state.statusBianDisabled||isEdit==='0'} />)}
          <span>每张不超过:8M,格式为:jpg，jpeg，png</span>
        </FormItem>
      );
    } else if (fieldType === '9') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue ? moment(fieldValue, dateFormat) : null,
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(
            <DatePicker
              disabled={this.state.statusBianDisabled||isEdit==='0'}
              placeholder="请选择"
              style={{ width: '100%' }}
            />
          )}
        </FormItem>
      );
    } else if (fieldType === '10') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                // required: isRequired, message: `请选择${fieldName}`,
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(
            <TextArea
              disabled={this.state.statusBianDisabled||isEdit==='0'}
              rows={3}
              placeholder={`请输入${fieldName}`}
              maxLength={maxLength}
            />
          )}
        </FormItem>
      );
    }
  };

  /** 组件初始化请求 */
  initFun = () => {
    //获取是否显示提交按钮
    // ajax.getCertificationData({}).then(data => {
    //   console.log("公司状态公司状态公司状态", data);
    //   if (data.data) {
    //     this.setState({
    //       status: data.data.authStatus
    //     });
    //     if (this.state.status === "0") {
    //       //未认证
    //       this.state.btnVisible = true;
    //     } else if (this.state.status === "1") {
    //       //认证中
    //       this.state.btnVisible = false;
    //     } else if (this.state.status === "2") {
    //       //已认证
    //       this.state.btnVisible = false;
    //     } else if (this.state.status === "3") {
    //       //认证不通过
    //       this.state.btnVisible = true;
    //     } else if (this.state.status === "") {
    //       //未认证
    //       this.state.btnVisible = true;
    //     }
    //   }
    // });
    //获取基本信息
    ajax.getCertificationData({}).then(data => {
      //判断获取数据是否为空
      if (data.data) {
        this.setState(
          {
            certificationData: data.data,
            phone_yin: data.data.legalRepPhone,
            // statusBianDisabled: data.data.authStatus === "0" ? false : data.data.authStatus === "" ? false : true,
            institutionType: data.data.institutionType
          },
          () => {
            this.props.form.setFieldsValue({
              comCerUrl: data.data.comCerUrl
            });

            //企业信息-认证申请-获得企业机构特殊信息
            ajax
              .enterpriseCompanyComIndustryGetIndustryConfigByComId({
                institutionType: this.state.institutionType
              })
              .then(
                res => {
                  if (res.data && res.data.length) {
                    const tmp = res.data.map((val, i) => {
                      if (val.fieldType && val.fieldType === '4') {
                        val.fieldOptions = val.fieldOptions
                          ? val.fieldOptions.split(',')
                          : [];
                      }
                      if (val.fieldType && val.fieldType === '5') {
                        val.fieldOptions = val.fieldOptions
                          ? val.fieldOptions.split(',')
                          : [];
                        val.fieldValue = val.fieldValue
                          ? val.fieldValue.split(',')
                          : [];
                      }
                      return Object.assign({}, val, {
                        key: i + 1
                      });
                    });
                    this.setState({
                      specialArray: tmp,
                      showIndustry: true
                    });
                  }
                },
                err => {
                  console.log('企业信息-认证申请-获得企业机构特殊信息', err);
                }
              );
          }
        );
      }
    });
    //获取行业特殊信息
    // ajax.enterpriseCompanyGetComIndustryinfo({}).then(data => {
    //   console.log('认证申请行业资质data:', data);
    //   if (data.data) {
    //     const tmp = data.data;
    //     const qualificationsData = { ...this.state.qualificationsData };

    //     tmp.map(val => {
    //       if (val.fieldCode === 'conf_armedLevel') {
    //         qualificationsData.conf_armedLevel = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_manpowerLevel') {
    //         qualificationsData.conf_manpowerLevel = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_riskLevel') {
    //         qualificationsData.conf_riskLevel = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_safeTechLevel') {
    //         qualificationsData.conf_safeTechLevel = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_securityLicenseNum') {
    //         qualificationsData.conf_securityLicenseNum = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_securityLicenseUrl') {
    //         qualificationsData.conf_securityLicenseUrl = val.fieldValue;
    //       } else if (val.fieldCode === 'conf_association') {
    //         if (val.fieldValue !== '') {
    //           qualificationsData.conf_association = val.fieldValue.split(',');
    //         }
    //       } else if (val.fieldCode === 'conf_safeRange') {
    //         if (val.fieldValue !== '') {
    //           qualificationsData.conf_safeRange = val.fieldValue.split(',');
    //         }
    //       }
    //       return '1';
    //     });
    //     console.log('获取的企业特殊信息数据:', qualificationsData);
    //     this.setState({ qualificationsData }, () => {
    //       this.props.form.setFieldsValue({
    //         conf_securityLicenseUrl: qualificationsData.conf_securityLicenseUrl
    //       });
    //     });
    //   }
    // });
  };

  initFunMount = () => {
    //字典下拉
    ajax
      .publicCommonDictGetDictByCodeTypes({
        codeTypes:
          'idCardType,nationality,comCerType,conf_armedLevel,conf_association,conf_manpowerLevel,conf_riskLevel,conf_safeRange,conf_safeTechLevel'
      })
      .then(data => {
        //判断获取数据是否为空
        if (data.data) {
          this.setState(
            {
              idCardType: data.data.idCardType, //身份
              nationality: data.data.nationality, //国籍
              certificationType: data.data.comCerType, //营业证件选择
              conf_armedLevel: data.data.conf_armedLevel, //武装押运守护等级
              conf_association: data.data.conf_association, //所属行业保安协会
              conf_manpowerLevel: data.data.conf_manpowerLevel, //人力防范等级
              conf_riskLevel: data.data.conf_riskLevel, //风险评估等级
              conf_safeRange: data.data.conf_safeRange, //安全范围
              conf_safeTechLevel: data.data.conf_safeTechLevel //安全技术防范等级
            },
            () => {
              this.initFun();
            }
          );
        }
      });
  };

  componentDidMount() {
    this.initFunMount();
    this.getComAdmin();
  }

  componentWillMount() { }

  //法人手机号存在时验证码弹窗
  showCodeModal = () => {
    // const { form } = this.props;
    // form.setFieldsValue(
    //   { codeOne: "" },
    //   { codeTwo: "" },
    //   { legalRepPhone_two: "" }
    // );
    if (
      this.state.certificationData.legalRepPhone !== '' &&
      this.state.certificationData.legalRepPhone !== undefined
    ) {
      this.setState({
        visibleCode: true,
        hasPnone: '123'
      });
    }
  };

  //法人手机号不存在时验证码弹窗
  showCodeModalNoPhone = () => {
    const { form } = this.props;
    form.setFieldsValue({ legalRepNoPhone: '' }, { legalRepNoPhoneCode: '' });
    this.setState({
      visibleNoPhoneCode: true
    });
  };

  handleCodeOk = () => {
    if (this.state.phoneHas !== '') {
      const { form } = this.props;
      const one_val = form.getFieldValue('codeOne');
      if (one_val === '' || one_val === undefined) {
        if (this.state.color_abc) {
          document.getElementById('code_p1').style.display = 'block';
          document.getElementById('code_p1').innerHTML = '验证码不能为空';
          document.getElementById('code_a1').classList.add('abc_color');
        }
      } else {
        if (/^[0-9]{4,6}$/.test(one_val)) {
          ajax
            .enterpriseComAuthInfoCheckLegalAuthCode({
              phone: this.state.certificationData.legalRepPhone,
              code: one_val
            })
            .then(
              data => {
                // alert('发送成功'+data.msg);
                clearInterval(this.countDownTimeId);
                document.getElementById('code_p1').style.display = 'none';
                document.getElementById('code_p1').innerHTML = '';
                document
                  .getElementById('code_a1')
                  .classList.remove('abc_color');
                if (data.retType === '0') {
                  this.setState({
                    phoneHas: '',
                    getting: false,
                    countDown: 60
                  });
                  document.getElementById('code_a3').value = '';
                } else {
                  document.getElementById('code_p1').style.display = 'block';
                  document.getElementById('code_p1').innerHTML = '验证码错误';
                  document.getElementById('code_a1').classList.add('abc_color');
                }
              },
              err => {
                document.getElementById('code_p1').style.display = 'block';
                document.getElementById('code_p1').innerHTML = '验证码不匹配';
                document.getElementById('code_a1').classList.add('abc_color');
              }
            );
        }
      }
    } else {
      const { form } = this.props;
      const two_val = form.getFieldValue('legalRepPhone_two');
      const two_code = form.getFieldValue('codeTwo1');
      if (two_val === '' || two_val === undefined) {
        document.getElementById('code_p2').style.display = 'block';
        document.getElementById('code_p2').innerHTML = '手机号码不能为空';
        document.getElementById('code_a2').classList.add('abc_color');
      } else if (two_code === '' || two_code === undefined) {
        document.getElementById('code_p3').style.display = 'block';
        document.getElementById('code_p3').innerHTML = '验证码不能为空';
        document.getElementById('code_a3').classList.add('abc_color');
      } else if (/^[0-9]{4,6}$/.test(two_code)) {
        ajax
          .enterpriseComAuthInfoCheckLegalAuthCode({
            phone: two_val,
            code: two_code
          })
          .then(
            (res) => {
              console.log(res)
              if(res.retType==='0'){
                clearInterval(this.countDownTimeId);
                document.getElementById('code_p2').style.display = 'none';
                document.getElementById('code_p2').innerHTML = '';
                document.getElementById('code_a2').classList.remove('abc_color');
                document.getElementById('code_a2').value = '';
                document.getElementById('code_p3').style.display = 'none';
                document.getElementById('code_p3').innerHTML = '';
                document.getElementById('code_a3').classList.remove('abc_color');
                document.getElementById('code_a3').value = '';
                this.setState({
                  phoneHas: '123',
                  getting: false,
                  countDown: 60,
                  modalLegPerson: false,
                  certificationData: {
                    legalRepPhone: two_val
                  },
                  modalFooter: false,
                  phone_yin: two_val
                });
                ajax.updateComLegalRepPhone({legalRepPhone: two_val}).then(result => {
                  ajax.getCertificationData({}).then(data => {
                    //判断获取数据是否为空
                    if (data.data) {
                      this.setState({
                        certificationData: data.data,
                        phone_yin: data.data.legalRepPhone
                      });
                    }
                  });
                });
              }
             
            },
            err => {
              document.getElementById('code_p3').style.display = 'block';
              document.getElementById('code_p3').innerHTML = err.msg;
              document.getElementById('code_a3').classList.add('abc_color');
            }
          );
      }
    }
  };
  codeChange = () => {
    document.getElementById('code_p1').style.display = 'none';
    document.getElementById('code_p1').innerHTML = '';
    document.getElementById('code_a1').classList.remove('abc_color');
    this.setState({
      color_abc: false
    });
  };
  codeChangeOne = () => {
    document.getElementById('code_p2').style.display = 'none';
    document.getElementById('code_p2').innerHTML = '';
    document.getElementById('code_a2').classList.remove('abc_color');
  };
  codeChangeTwo = () => {
    document.getElementById('code_p3').style.display = 'none';
    document.getElementById('code_p3').innerHTML = '';
    document.getElementById('code_a3').classList.remove('abc_color');
  };
  codeChangeThree = () => {
    document.getElementById('code_p4').style.display = 'none';
    document.getElementById('code_p4').innerHTML = '';
    document.getElementById('code_a4').classList.remove('abc_color');
  };
  codeChangeFour = () => {
    document.getElementById('code_p5').style.display = 'none';
    document.getElementById('code_p5').innerHTML = '';
    document.getElementById('code_a5').classList.remove('abc_color');
  };

  //法人手机号为空时
  handleNoPhoneCodeOk = () => {
    const { form } = this.props;
    const phone_val = form.getFieldValue('legalRepNoPhone');
    const code_val = form.getFieldValue('legalRepNoPhoneCode');
    if (phone_val === '' || phone_val === undefined) {
      document.getElementById('code_p4').style.display = 'block';
      document.getElementById('code_p4').innerHTML = '手机号码不能为空';
      document.getElementById('code_a4').classList.add('abc_color');
    } else if (code_val === '' || code_val === undefined) {
      document.getElementById('code_p5').style.display = 'block';
      document.getElementById('code_p5').innerHTML = '验证码不能为空';
      document.getElementById('code_a5').classList.add('abc_color');
    } else if (
      /^[0-9]{4,6}$/.test(code_val) &&
      /^((1[3,5,8][0-9])|(14[5,7])|(17[0,6,7,8])|(19[7]))\d{8}$/.test(phone_val)
    ) {
      ajax
        .enterpriseComAuthInfoCheckLegalAuthCode({
          phone: phone_val,
          code: code_val
        })
        .then(
          () => {
            clearInterval(this.countDownTimeIdNoPhone);
            document.getElementById('code_p4').style.display = 'none';
            document.getElementById('code_p4').innerHTML = '';
            document.getElementById('code_a4').classList.remove('abc_color');
            document.getElementById('code_a4').value = '';
            document.getElementById('code_p5').style.display = 'none';
            document.getElementById('code_p5').innerHTML = '';
            document.getElementById('code_a5').classList.remove('abc_color');
            document.getElementById('code_a5').value = '';
            this.setState({
              gettingNoPhone: false,
              countDownNoPhone: 60,
              noPhoneContent: '123',
              modalFooterNoPhone: false,
              phone_yin: phone_val
            });
            ajax.getCertificationData({}).then(data => {
              //判断获取数据是否为空
              if (data.data) {
                this.setState({
                  certificationData: data.data,
                  phone_yin: data.data.legalRepPhone
                });
              }
            });
          },
          () => {
            document.getElementById('code_p5').style.display = 'block';
            document.getElementById('code_p5').innerHTML = '验证码输入错误';
            document.getElementById('code_a5').classList.add('abc_color');
          }
        );
    }
  };

  // 获取验证码
  onGetCode = () => {
    if (this.state.phoneHas !== '') {
      ajax
        .enterpriseCompanySendLegalAuthCode({
          phone: this.state.certificationData.legalRepPhone
        })
        .then(
          data => {
            console.log('法人手机验证码：' + data);
          },
          err => {
            console.log('获取法人手机验证码err', err);
          }
        );
      this.setState({
        getting: true
      });
    } else {
      const { form } = this.props;
      const two_val = form.getFieldValue('legalRepPhone_two');
      if (
        two_val &&
        /^((1[3,5,8][0-9])|(14[5,7])|(17[0,6,7,8])|(19[6,7,9]))\d{8}$/.test(
          two_val
        )
      ) {
        ajax.enterpriseCompanySendLegalAuthCode({ phone: two_val }).then(
          data => {
            this.setState({
              getting: true
            });
          },
          err => {
            console.log('获取法人手机验证码err', err);
          }
        );
      }
    }
  };

  // 法人手机号为空时获取验证码
  onGetCodeNoPhone = () => {
    const { form } = this.props;
    const sd_val = form.getFieldValue('legalRepNoPhone');
    if (
      sd_val === '' ||
      !/^((1[3,5,8][0-9])|(14[5,7])|(17[0,6,7,8])|(19[6,7,9]))\d{8}$/.test(
        sd_val
      )
    ) {
      message.error('法人手机号不能为空或手机号码格式不正确');
    } else {
      ajax.enterpriseCompanySendLegalAuthCode({ phone: sd_val }).then(
        data => {
          console.log('法人手机验证码：' + data);
        },
        err => {
          console.log('获取法人手机验证码err', err);
        }
      );
      this.setState({
        gettingNoPhone: true
      });
    }
  };

  handleCodeCancel = () => {
    clearInterval(this.countDownTimeId);
    this.setState({
      visibleCode: false,
      modalLegPerson: true,
      phoneHas: '123',
      getting: false,
      countDown: 60,
      modalFooter: true,
      color_abc: true
    });
    if(document.getElementById('code_a1')) {
      document.getElementById('code_a1').value = '';
      document.getElementById('code_a1').classList.remove('abc_color');
    }
    if(document.getElementById('code_p1')) {
      document.getElementById('code_p1').innerHTML = '';
    }
    const { form } = this.props;
    form.setFieldsValue({ codeOne: '123456' });
  };

  //法人手机号为空时点击取消
  handleNoPhoneCodeCancel = () => {
    clearInterval(this.countDownTimeIdNoPhone);
    this.setState({
      visibleNoPhoneCode: false,
      gettingNoPhone: false,
      countDownNoPhone: 60,
      modalFooterNoPhone: true
    });
  };

  renderIdCard = () => {
    return this.state.idCardType.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  renderNationality = () => {
    return this.state.nationality.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  renderCertification = () => {
    return this.state.certificationType.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  renderManpowerLevel = () => {
    return this.state.conf_manpowerLevel.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };
  renderArmedLevel = () => {
    return this.state.conf_armedLevel.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };
  renderSafeTechLevel = () => {
    return this.state.conf_safeTechLevel.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };
  renderRiskLevel = () => {
    return this.state.conf_riskLevel.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  timerCount = () => {
    //防止重复计算
    if (this.state.countDown !== 60) {
      return;
    }

    this.countDownTimeId = setInterval(() => {
      if (this.state.countDown > 0) {
        this.setState(prevState => ({
          countDown: prevState.countDown - 1
        }));
        if (this.state.countDown === 0) {
          this.setState({
            getting: false,
            countDown: 60
          });
          clearInterval(this.countDownTimeId);
        }
      } else {
        clearInterval(this.countDownTimeId);
      }
    }, 1000);
  };

  //法人手机号为空时
  timerCountNoPhone = () => {
    //防止重复计算
    if (this.state.countDownNoPhone !== 60) {
      return;
    }

    this.countDownTimeIdNoPhone = setInterval(() => {
      if (this.state.countDownNoPhone > 0) {
        this.setState(prevState => ({
          countDownNoPhone: prevState.countDownNoPhone - 1
        }));
        if (this.state.countDownNoPhone === 0) {
          this.setState({
            gettingNoPhone: false,
            countDownNoPhone: 60
          });
          clearInterval(this.countDownTimeIdNoPhone);
        }
      } else {
        clearInterval(this.countDownTimeIdNoPhone);
      }
    }, 1000);
  };

  componentWillUnmount = () => {
    //离开页面时候,清除计时器
    if (this.countDownTimeId != null || this.countDownTimeId != undefined) {
      clearInterval(this.countDownTimeId);
    }
  };

  beforeUpload = file => {
    const types = ['image/png', 'image/jpeg', 'image/jpg'];
    if (types.indexOf(file.type) === -1) {
      message.error('只能上传图片!');
      return false;
    }
    const isLt8M = file.size / 1024 / 1024 < 8;
    if (!isLt8M) {
      message.error('图片大小大于8MB!');
      return false;
    }

    return true;
    // return isJPG && isPNG && isLt8M;
  };

  handleChange = (info, field) => {
    const { setFieldsValue } = this.props.form;
    let { fileList } = info;
    fileList = fileList.slice(-1);
    this.setState({ [field + 'List']: fileList });
    if (info.file.status === 'removed') {
      message.error('至少需要一张图片');
      return;
    }
    if (info.file.status !== 'uploading') {
      if (info.file.response) {
        if (info.file.response.retType === '-1') {
          message.error(info.file.response.msg);
          return;
        }
      } else {
        return;
      }
    }
    if (info.file.status === 'done') {
      message.success(`${info.file.name} 文件上传成功`);
      this.setState({
        [field + 'List']: fileList,
        [field]: fileList[0].response.data
      });
      setFieldsValue({ [field]: fileList.slice(-1) });
    } else if (info.file.status === 'error') {
      message.error(`${info.file.name} 文件上传失败.`);
    }
  };

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      values.codeOne = 1234;
      values.legalRepPhone_two = 15012365498;
      values.codeTwo = 2345;
      values.legalRepNoPhone = 15012365498;
      values.legalRepNoPhoneCode = 3456;
      values.legalRepPhone = this.state.certificationData.legalRepPhone;

      //特殊字段日期类型处理
      Object.keys(values).forEach(key => {
        if (
          key.slice(0, 4) === 'conf' &&
          (key.slice(-4) === 'Date' || key.slice(-4) === 'date')
        ) {
          values[key] = values[key] ? values[key].format('YYYY-MM-DD') : null;
        }
      });
      if (!err) {
        //确认提交提示
        //暂时隐藏特殊字段信息；冠男取消隐藏
        // values.conf_armedLevel = values.conf_armedLevel.toString();
        // values.conf_association = values.conf_association.toString();
        // values.conf_manpowerLevel = values.conf_manpowerLevel.toString();
        // values.conf_riskLevel = values.conf_riskLevel.toString();
        // values.conf_safeRange = values.conf_safeRange.toString();
        // values.conf_safeTechLevel = values.conf_safeTechLevel.toString();

        const that = this;
        // 验证管理员身份
        if (
          this.props.currentUser !==
          this.state.administratorRelative.phoneValue &&
          (!this.state.administratorRelative.hasValidCode ||
            !this.state.administratorRelative.isValidCode)
        ) {
          this.setState({
            administratorRelative: {
              ...this.state.administratorRelative,
              openValidAdminModal: true
            }
          });
          return;
        }

        // confirm({
        //   title: '提交成功后3个工作日内审核完毕，是否提交？',
        //   okText: '确认',
        //   cancelText: '取消',
        //   onOk() {
        //     values.authStatus = 1; //修改认证状态
        //     ajax.enterpriseCompanyUpdateComAuthInfo({ ...values }).then(
        //       () => {
        //         that.setState({
        //           certificationData: values,
        //           qualificationsData: values,
        //           btnVisible: false,
        //           loading: false,
        //           statusBianDisabled: true
        //         });
        //         that.props.changeStatus();
        //         that.setState({ certificationData: { authStatus: '1' } });
        //         // message.success('提交成功！');
        //       },
        //       () => {
        //         that.setState({ loading: false });
        //       }
        //     );
        //   },
        //   onCancel() {}
        // });
        ajax.enterpriseCompanyUpdateComAuthInfo({ ...values }).then(
          () => {
            that.setState({
              certificationData: values,
              qualificationsData: values,
              // btnVisible: false,
              loading: false
              // statusBianDisabled: true
            });
            that.props.changeStatus();
            // that.setState({ certificationData: { authStatus: '1' } });
            // message.success('提交成功！');
          },
          () => {
            that.setState({ loading: false });
          }
        );
      } else {
        // console.log('errrrrr' + JSON.stringify(err));
      }
    });
  };
  callback = key => {
    console.log(key);
  };

  //验证手机号码
  checkPhone = (rule, value, callback) => {
    if (value && !/^1[0-9]{10}$/.test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };

  //验证码的发送
  onGetCaptcha = () => {
    const disableStyle = {
      background: '#f7f7f7',
      marginLeft: 16,
      borderColor: '#d9d9d9',
      marginTop: 4
    };
    //验证通过,没有获取
    if (!this.state.getting) {
      return (
        <Button
          type="primary"
          style={{ marginLeft: 16, marginTop: 4 }}
          className="getCaptcha"
          onClick={this.onGetCode}
        >
          验证
        </Button>
      );
      //验证通过,正在获取
    } else {
      this.timerCount();
      return (
        <Button
          type="primary"
          className="getValid"
          style={disableStyle}
          disabled
        >
          {this.state.countDown}
          S后重新发送
        </Button>
      );
    }
  };

  //法人手机号未验证时发送验证码
  onGetCaptchaNoPhone = () => {
    const disableStyle = {
      background: '#f7f7f7',
      marginLeft: 16,
      borderColor: '#d9d9d9'
    };

    //验证通过,没有获取
    if (!this.state.gettingNoPhone) {
      return (
        <Button
          type="primary"
          style={{ marginLeft: 16 }}
          className="getCaptcha"
          onClick={this.onGetCodeNoPhone}
        >
          验证
        </Button>
      );
      //验证通过,正在获取
    } else {
      this.timerCountNoPhone();
      return (
        <Button
          type="primary"
          className="getValid"
          style={disableStyle}
          disabled
        >
          {this.state.countDownNoPhone}
          S后重新发送
        </Button>
      );
    }
  };

  onGetCaptchaData = () => {
    return (
      <Button
        type="primary"
        style={{ marginLeft: 16, marginTop: 4 }}
        className="getCaptcha"
        onClick={this.showCodeModal}
        disabled={this.state.statusBianDisabled}
      >
        变更
      </Button>
    );
  };

  onGetCapt = () => {
    return (
      <Button
        type="primary"
        style={{ marginLeft: 16, marginTop: 4 }}
        className="getCaptcha"
        onClick={this.showCodeModalNoPhone}
      >
        验证
      </Button>
    );
  };

  //审核结果
  statusBian = () => {
    const s_val = this.state.certificationData.authStatus;
    if (s_val === '0') {
      return (
        <Alert
          message="未认证"
          type="error"
          style={{ margin: '0 24px' }}
          showIcon
        />
      );
    } else if (s_val === '1') {
      return (
        <Alert
          message="认证通过"
          style={{ margin: '0 24px' }}
          type="success"
          showIcon
        />
      ); 
    } else if (s_val === '2') {
      return (
        <Alert
          message="当前信息正在审核中"
          type="warning"
          style={{ margin: '0 24px' }}
          showIcon
        />
      );
    } else if (s_val === '3') {
      return (
        <Alert
          message={'审核不通过,原因' + this.state.message}
          type="error"
          style={{ margin: '0 24px' }}
          showIcon
        />
      );
    } else if (s_val === '') {
      return (
        <Alert
          message="未认证"
          type="error"
          style={{ margin: '0 24px' }}
          showIcon
        />
      );
    }
  };

  //验证名称类，限制不能全角输入
  checkFullWidth = (rule, value, callback) => {
    if (value && !/^[\u4e00-\u9fa5]{1,10}$/.test(value)) {
      callback('请输入最大10个字符长度的汉字！');
    } else {
      callback();
    }
  };

  //证件类型-号码验证
  checkIdCardNo = (rule, value, callback) => {
    const { form } = this.props;
    const idType = form.getFieldValue('idCardType');
    if (
      idType === '1' &&
      value &&
      !/^(^[1-9]\d{7}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}$)|(^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])((\d{4})|\d{3}[Xx])$)$/.test(
        value
      )
    ) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };

  checkJiShuMore = (rule, value, callback) => {
    if (
      value &&
      !/^-?(([0-9][0-9]{0,9})|(([0]\.\d{1,4}|[1-9][0-9]{0,9}\.\d{1,4})))$/.test(
        value
      )
    ) {
      callback('最多输入10位整数，并且小数点后面最多输入4位！');
    } else {
      callback();
    }
  };

  //验证手机验证码
  checkPhoneCodeVlue = (rule, value, callback) => {
    if (value === '') {
      callback('手机验证码不能为空！');
    } else if (value && !/^[0-9]{4,6}$/.test(value)) {
      callback('请输入正确的手机验证码！');
    } else {
      callback();
    }
  };

  showModalFooter = () => {
    const value_text = this.state.modalFooter;
    if (!value_text) {
      return null;
    }
  };

  showNoPhoneModalFooter = () => {
    const code_text = this.state.modalFooterNoPhone;
    if (!code_text) {
      return null;
    }
  };
  //证件类型-号码验证-身份证
  checkIdCardNo = (rule, value, callback) => {
    // const form = this.props.form;
    // const idType = form.getFieldValue('idCardType');
    if (value && !/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value)) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };

  //证件类型-号码验证-其他
  checkCardNo = (rule, value, callback) => {
    if (value && !/^[A-Za-z0-9]{1,20}$/.test(value)) {
      callback('请输入最大20位长度的证件号码！');
    } else {
      callback();
    }
  };

  //身份证改变事件
  idCardTypeOnChangeHandler = value => {
    // this.props.form.validateFields(['cerNo']);
    this.props.form.setFieldsValue({ idCardNo: '' });
    this.setState({ selectedIdCardType: value });
  };

  // 管理员身份验证码弹窗确认事件
  handleValidAdminModalOk = e => {
    this.props.form.validateFields((err, values) => {
      if (!values['adminValidCode']) {
        this.props.form.setFields({
          adminValidCode: {
            value: values.user,
            errors: [new Error('请输入验证码')]
          }
        });
        return false;
      }
      if (!err) {
        ajax
          .systemPlatNewsVerificationCode({
            mobile: this.state.administratorRelative.phoneValue,
            code: values['adminValidCode']
          })
          .then(
            () => {
              this.setState(
                {
                  administratorRelative: {
                    ...this.state.administratorRelative,
                    isValidCode: true,
                    openValidAdminModal: false
                  }
                },
                () => {
                  this.handleSubmit(e);
                }
              );
            },
            error => {
              console.log('验证码是否正确-error:', error);
              // message.error('请填写正确的验证码信息');
            }
          );
      }
    });
  };

  // 管理员身份验证码弹窗取消事件
  handleValidAdminModalCancel = () => {
    this.setState({
      administratorRelative: {
        ...this.state.administratorRelative,
        openValidAdminModal: false
      }
    });
  };

  //获得企业管理员
  getComAdmin = () => {
    ajax.selectComAdmin({}).then(data => {
      let phoneValueHiddenMiddle = data.data[0].userName;
      phoneValueHiddenMiddle = phoneValueHiddenMiddle.replace(
        /(\d{3})\d{4}(\d{4})/,
        '$1****$2'
      );
      //判断获取数据是否为空
      this.setState({
        administratorRelative: {
          ...this.state.administratorRelative,
          administrator: data.data[0].name,
          phoneValue: data.data[0].userName, // 我也不知道为啥叫这个名字，反正后台这个字段是电话
          phoneValueHiddenMiddle
        }
      });
    });
  };

  // 获取管理员验证码按钮逻辑
  getAdminValidCodeButton = () => {
    const disableStyle = {
      background: '#f7f7f7',
      marginLeft: 16,
      borderColor: '#d9d9d9'
    };

    // 验证通过,没有获取
    if (!this.state.administratorRelative.hasValidCode) {
      return (
        <Button
          type="primary"
          style={{ marginLeft: 16 }}
          className="getCaptcha"
          onClick={this.getAdminValidCode}
        >
          验证
        </Button>
      );
      //验证通过,正在获取
    } else {
      this.timerCountForAdminValidCode();
      return (
        <Button
          type="primary"
          className="getValid"
          style={disableStyle}
          disabled
        >
          {this.state.administratorRelative.countDownNoPhone}
          S后重新发送
        </Button>
      );
    }
  };

  // 获取管理员验证码
  getAdminValidCode = () => {
    ajax
      .systemPlatNewsSendVerificationCode({
        mobile: this.state.administratorRelative.phoneValue
      })
      .then(
        res => {
          if (res.retType === '0') {
            this.setState({
              administratorRelative: {
                ...this.state.administratorRelative,
                hasValidCode: true,
                isValidCode: false
              }
            });
          }
        },
        err => {
          console.log('获取验证码错误信息:', err);
        }
      );
  };

  // 管理员验证码倒计时
  timerCountForAdminValidCode = () => {
    //防止重复计算
    if (this.state.administratorRelative.countDownNoPhone !== 60) {
      return;
    }

    this.countDownTimeForAdminValidCode = setInterval(() => {
      if (this.state.administratorRelative.countDownNoPhone > 0) {
        this.setState(prevState => ({
          administratorRelative: {
            ...this.state.administratorRelative,
            countDownNoPhone:
              prevState.administratorRelative.countDownNoPhone - 1
          }
        }));
        if (this.state.administratorRelative.countDownNoPhone === 0) {
          this.setState({
            administratorRelative: {
              ...this.state.administratorRelative,
              countDownNoPhone: 60,
              hasValidCode: false
            }
          });
          clearInterval(this.countDownTimeForAdminValidCode);
        }
      } else {
        clearInterval(this.countDownTimeForAdminValidCode);
      }
    }, 1000);
  };

  render() {
    const { showIndustry } = this.state;
    const { getFieldDecorator,getFieldValue } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        md: { span: 10 }
      }
    };

    const formItemLayoutMore = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 18 },
        md: { span: 16 }
      }
    };

    //保安协会
    const renderAssociation = [];
    this.state.conf_association.map((val, key) => {
      renderAssociation.push(
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });

    //安全范围
    const renderSafeRange = [];
    this.state.conf_safeRange.map((val, key) => {
      renderSafeRange.push(
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });

    const con_title = (
      <p>
        法人手机变更
        <span style={{ fontSize: '14px' }}>
          <i style={{ color: 'red' }}> *</i>
          法人信息如有变更，需要验证原法人的身份真实、有效。
        </span>
      </p>
    );

    return (
      <Container>
        <div>
          {/* <h2>{this.statusBian()}</h2> */}
          <div className="s_rtf s_erf">
            <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
              <div className="card">法定代表人</div>
              <FormItem {...formItemLayout} label="法定代表人" extra={<span style={{color:'red'}}>注：分公司请填写分公司负责人信息。</span>}>
                {getFieldDecorator('legalRepName', {
                  initialValue: this.state.certificationData.legalRepName,
                  rules: [
                    {
                      required: true,
                      message: '请输入法定代表人姓名'
                    },
                    {
                      validator: this.checkFullWidth
                    }
                  ]
                })(
                  <Input
                    placeholder="请输入"
                    maxLength={10}
                    // disabled={this.state.statusBianDisabled}
                    disabled={this.props.companyInfo.industryType === '01'}
                  />
                )}
              </FormItem>
              <FormItem {...formItemLayout} label="国籍/地区">
                {getFieldDecorator('nationality', {
                  initialValue: this.state.certificationData.nationality,
                  rules: [{ required: true, message: '请选择国籍/地区' }]
                })(
                  <Select
                    showSearch
                    optionFilterProp="children"
                    filterOption={(input, option) =>
                      option.props.children
                        .toLowerCase()
                        .indexOf(input.toLowerCase()) >= 0
                    }
                    placeholder="请选择"
                    disabled={this.state.statusBianDisabled}
                  >
                    {this.renderNationality()}
                  </Select>
                )}
              </FormItem>
              {this.state.certificationData.legalRepPhone === '' ? (
                <FormItem {...formItemLayout} label="手机号码">
                  <div style={{ display: 'flex' }}>
                    <div style={{ flex: 1 }}>
                      {getFieldDecorator('legalRepPhone', {
                        initialValue: this.state.certificationData
                          .legalRepPhone,
                        rules: [
                          {
                            required: true,
                            message: '请输入手机号！'
                          },
                          {
                            validator: this.checkPhone
                          }
                        ]
                      })(<Input placeholder="请输入手机号" disabled />)}
                    </div>
                    {this.onGetCapt()}
                  </div>
                </FormItem>
              ) : (
                  <FormItem {...formItemLayout} label="手机号码">
                    <div style={{ display: 'flex' }}>
                      <div style={{ flex: 1 }}>
                        {getFieldDecorator('legalRepPhone', {
                          initialValue:
                            this.state.phone_yin.substring(0, 3) +
                            '****' +
                            this.state.phone_yin.substring(7, 11),
                          rules: [
                            {
                              required: true,
                              message: '请输入手机号！'
                            }
                          ]
                        })(<Input placeholder="请输入手机号" disabled />)}
                      </div>
                      {this.onGetCaptchaData()}
                    </div>
                  </FormItem>
                )}

              <FormItem {...formItemLayout} label="证件类型" hasFeedback>
                {getFieldDecorator('idCardType', {
                  initialValue: this.state.certificationData.idCardType,
                  rules: [
                    {
                      required: true,
                      message: '请选择证件类型'
                    }
                  ]
                })(
                  <PSelect
                    type="idCardType_bak"
                    onChange={this.idCardTypeOnChangeHandler}
                    style={{ width: '100%' }}
                    // disabled={this.state.statusBianDisabled}
                    disabled={this.props.companyInfo.industryType === '01'}
                  />
                )}
              </FormItem>
              <FormItem {...formItemLayout} label="证件号码">
                {this.state.selectedIdCardType === '1'
                  ? getFieldDecorator('idCardNo', {
                    initialValue: this.state.certificationData.idCardNo,
                    rules: [
                      {
                        required: true,
                        message: '请输入证件号码！'
                      },
                      {
                        validator: this.checkIdCardNo
                      }
                    ]
                  })(
                    <Input
                      placeholder="请填写证件号码"
                      maxLength={20}
                      // disabled={this.state.statusBianDisabled}
                      disabled={this.props.companyInfo.industryType === '01'}
                    />
                  )
                  : getFieldDecorator('idCardNo', {
                    initialValue: this.state.certificationData.idCardNo,
                    rules: [
                      {
                        required: true,
                        message: '请输入证件号码！'
                      },
                      {
                        validator: this.checkCardNo
                      }
                    ]
                  })(
                    <Input
                      placeholder="请填写证件号码"
                      maxLength={20}
                      // disabled={this.state.statusBianDisabled}
                      disabled={this.props.companyInfo.industryType === '01'}
                    />
                  )}
              </FormItem>
              <div className="card">注册信息</div>
              {
                this.props.companyInfo.institutionType != '0104' && 
                <FormItem {...formItemLayout} label="注册资金（万元）">
                  {getFieldDecorator('regAmount', {
                    initialValue: this.state.certificationData.regAmount,
                    rules: [
                      {
                        required: true,
                        message: '请输入注册资金'
                      },
                      {
                        validator: this.checkJiShuMore
                      }
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      maxLength={15}
                      // disabled={this.state.statusBianDisabled}
                      disabled={this.props.companyInfo.industryType === '01'}
                    />
                  )}
                </FormItem>
              }
              {
                this.props.companyInfo.institutionType != '0104' &&
                <FormItem {...formItemLayout} label="固定资产（万元）" extra={parseInt(getFieldValue('fixedAssets'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                  {getFieldDecorator('fixedAssets', {
                    initialValue: this.state.certificationData.fixedAssets,
                    rules: [
                      {
                        validator: this.checkJiShuMore
                      },
                      {
                        required: true,  //自招单位非必填
                        message: '请输入固定资产'
                      },
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      maxLength={15}
                      disabled={this.state.statusBianDisabled}
                    />
                  )}
                </FormItem>
              }
              {
                this.props.companyInfo.institutionType != '0104' &&
                <FormItem {...formItemLayout} label="年营业额（万元）"  extra={parseInt(getFieldValue('annualTurnover'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                  {getFieldDecorator('annualTurnover', {
                    initialValue: this.state.certificationData.annualTurnover,
                    rules: [
                      {
                        validator: this.checkJiShuMore
                      },
                      {
                        required: true,
                        message: '请输入年营业额'
                      },
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      maxLength={15}
                      disabled={this.state.statusBianDisabled}
                    />
                  )}
                </FormItem>
              }
              {
                this.props.companyInfo.institutionType != '0104' &&
                <FormItem {...formItemLayout} label="年利税（万元）"  extra={parseInt(getFieldValue('annualProfitTax'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                  {getFieldDecorator('annualProfitTax', {
                    initialValue: this.state.certificationData.annualProfitTax,
                    rules: [
                      {
                        validator: this.checkJiShuMore
                      },
                      {
                        required: true,
                        message: '请输入年利税'
                      },
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      maxLength={15}
                      disabled={this.state.statusBianDisabled}
                    />
                  )}
                </FormItem>
              }
              <FormItem {...formItemLayout} label="证件类型">
                {getFieldDecorator('comCerType', {
                  initialValue: this.state.certificationData.comCerType,
                  rules: [{ required: true, message: '请选择企业证件类型' }]
                })(
                  <Select
                    placeholder="请选择"
                    disabled={this.state.statusBianDisabled}
                  >
                    {this.renderCertification()}
                  </Select>
                )}
              </FormItem>
              <FormItem {...formItemLayout} label="证件号码">
                {getFieldDecorator('comCerNo', {
                  initialValue: this.state.certificationData.comCerNo,
                  rules: [
                    {
                      required: true,
                      message: '请输入证件号码！'
                    },
                    {
                      validator: this.checkCardNo
                    }
                  ]
                })(
                  <Input
                    placeholder="请填写证件号码"
                    maxLength={20}
                    disabled={this.state.statusBianDisabled}
                  />
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="证件扫描件"
              // help="每张不超过:8M,格式为:jpg，jpeg，png"
              >
                {getFieldDecorator('comCerUrl', {
                  initialValue: this.state.certificationData.comCerUrl,
                  rules: [
                    {
                      required: true,
                      message: '请上传证件扫描件'
                    }
                  ]
                })(
                  <PFromUpload
                    num={1}
                    disabled={this.state.statusBianDisabled}
                  />
                )}
                <p>每张不超过:8M,格式为:jpg，jpeg，png</p>
              </FormItem>

              {showIndustry && (
                <div>
                  <div className="card">
                    资质信息
                    <em>如为分公司，填写总公司资质</em>
                  </div>
                  {/* <div>
                    <FormItem {...formItemLayout} label="所属行业保安协会">
                      {getFieldDecorator("conf_association", {
                        initialValue: this.state.qualificationsData.conf_association
                      })(
                        <Select
                          placeholder="请选择"
                          mode="multiple"
                          style={{ width: "100%" }}
                          disabled={this.state.statusBianDisabled}
                        >
                          {renderAssociation}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="安全范围">
                      {getFieldDecorator("conf_safeRange", {
                        initialValue: this.state.qualificationsData.conf_safeRange,
                        rules: [
                          {
                            required: true,
                            message: "安全范围不能为空"
                          }
                        ]
                      })(
                        <Select
                          placeholder="请选择"
                          mode="multiple"
                          style={{ width: "100%" }}
                          disabled={this.state.statusBianDisabled}
                        >
                          {renderSafeRange}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="人力防范等级">
                      {getFieldDecorator("conf_manpowerLevel", {
                        initialValue: this.state.qualificationsData.conf_manpowerLevel
                      })(
                        <Select placeholder="请选择" disabled={this.state.statusBianDisabled}>
                          <Option value="">请选择</Option>
                          {this.renderManpowerLevel()}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="武装押运守护等级">
                      {getFieldDecorator("conf_armedLevel", {
                        initialValue: this.state.qualificationsData.conf_armedLevel
                      })(
                        <Select placeholder="请选择" disabled={this.state.statusBianDisabled}>
                          <Option value="">请选择</Option>
                          {this.renderArmedLevel()}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="安全技术防范等级">
                      {getFieldDecorator("conf_safeTechLevel", {
                        initialValue: this.state.qualificationsData.conf_safeTechLevel
                      })(
                        <Select placeholder="请选择" disabled={this.state.statusBianDisabled}>
                          <Option value="">请选择</Option>
                          {this.renderSafeTechLevel()}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="风险评估等级">
                      {getFieldDecorator("conf_riskLevel", {
                        initialValue: this.state.qualificationsData.conf_riskLevel
                      })(
                        <Select placeholder="请选择" disabled={this.state.statusBianDisabled}>
                          <Option value="">请选择</Option>
                          {this.renderRiskLevel()}
                        </Select>
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="保安服务许可证号">
                      {getFieldDecorator("conf_securityLicenseNum", {
                        initialValue: this.state.qualificationsData
                          .conf_securityLicenseNum,
                        rules: [
                          {
                            required: true,
                            message: "请输入保安服务许可证号"
                          }
                        ]
                      })(<Input placeholder="请输入" maxLength={20} disabled={this.state.statusBianDisabled} />)}
                    </FormItem>
                    <FormItem
                      {...formItemLayout}
                      label="保安服务许可证"
                    // help="每张不超过:8M,格式为:jpg，jpeg，png"
                    >
                      {getFieldDecorator("conf_securityLicenseUrl", {
                        initialValue: this.state.qualificationsData
                          .conf_securityLicenseUrl,
                        rules: [
                          {
                            required: true,
                            message: "请上传保安服务许可证"
                          }
                        ]
                      })(<PFromUpload num={2} disabled={this.state.statusBianDisabled} />)}
                      <span>每张不超过:8M,格式为:jpg，jpeg，png</span>
                    </FormItem>
                  </div> */}
                  {this.showSpecialFields()}
                </div>
              )}
              <FormItem {...formItemLayout} label=" " colon={false}>
                {this.state.btnVisible ? (
                  <Button
                    size="large"
                    type="primary"
                    loading={this.state.loading}
                    htmlType="submit"
                  >
                    {' '}
                    提交{' '}
                  </Button>
                ) : (
                    ''
                  )}
              </FormItem>
            </Form>
            {this.state.hasPnone !== '' ? (
              <Modal
                // title="法人手机变更"
                title={con_title}
                visible={this.state.visibleCode}
                onOk={this.handleCodeOk}
                onCancel={this.handleCodeCancel}
                okText={
                  this.state.certificationData.legalRepPhone === ''
                    ? '确认'
                    : '下一步'
                }
                footer={this.showModalFooter()}
              >
                {this.state.modalLegPerson === true ? (
                  this.state.phoneHas !== '' ? (
                    <Form>
                      <FormItem {...formItemLayoutMore} label="手机号码">
                        <div style={{ display: 'flex' }}>
                          <div style={{ flex: 1 }}>
                            {getFieldDecorator('legalRepPhone_one', {
                              initialValue:
                                this.state.certificationData.legalRepPhone.substring(
                                  0,
                                  3
                                ) +
                                '****' +
                                this.state.certificationData.legalRepPhone.substring(
                                  7,
                                  11
                                ),
                              rules: [
                                {
                                  required: true,
                                  message: '请输入手机号！'
                                }
                              ]
                            })(<Input placeholder="请输入手机号" disabled />)}
                          </div>
                          {this.onGetCaptcha()}
                        </div>
                      </FormItem>
                      <FormItem
                        {...formItemLayoutMore}
                        label="验证码"
                        className="code_yan"
                      >
                        {getFieldDecorator('codeOne', {
                          rules: [
                            {
                              message: '请输入手机验证码！'
                            },
                            {
                              validator: this.checkPhoneCodeVlue
                            }
                          ]
                        })(
                          <div>
                            <Input
                              placeholder="请输入手机验证码"
                              maxLength={6}
                              id="code_a1"
                              onChange={this.codeChange}
                            />
                            <p
                              id="code_p1"
                              style={{
                                marginBottom: 0,
                                color: 'red',
                                display: 'none',
                                fontSize: '14px',
                                lineHeight: '1.5',
                                marginTop: '2px'
                              }}
                            >
                              验证码错误
                            </p>
                          </div>
                        )}
                      </FormItem>
                    </Form>
                  ) : (
                      <Form>
                        <FormItem {...formItemLayoutMore} label="手机号码">
                          <div style={{ display: 'flex' }}>
                            <div style={{ flex: 1 }}>
                              {getFieldDecorator('legalRepPhone_two', {
                                rules: [
                                  {
                                    required: true,
                                    message: '请输入手机号！'
                                  },
                                  {
                                    validator: this.checkPhone
                                  }
                                ]
                              })(
                                <div>
                                  <Input
                                    placeholder="请输入手机号"
                                    id="code_a2"
                                    maxLength={11}
                                    onChange={this.codeChangeOne}
                                  />
                                  <p
                                    id="code_p2"
                                    style={{
                                      marginBottom: 0,
                                      color: 'red',
                                      display: 'none',
                                      fontSize: '14px',
                                      lineHeight: '1.5',
                                      marginTop: '2px'
                                    }}
                                  >
                                    手机号码错误
                                </p>
                                </div>
                              )}
                            </div>
                            {this.onGetCaptcha()}
                          </div>
                        </FormItem>
                        <FormItem {...formItemLayoutMore} label="验证码">
                          {getFieldDecorator('codeTwo1', {
                            rules: [
                              {
                                message: '请输入手机验证码！'
                              },
                              {
                                required: true,
                                validator: this.checkPhoneCodeVlue
                              }
                            ]
                          })(
                            <div>
                              <Input
                                placeholder="请输入手机验证码"
                                maxLength={6}
                                id="code_a3"
                                onChange={this.codeChangeTwo}
                              />
                              <p
                                id="code_p3"
                                style={{
                                  marginBottom: 0,
                                  color: 'red',
                                  display: 'none',
                                  fontSize: '14px',
                                  lineHeight: '1.5',
                                  marginTop: '2px'
                                }}
                              >
                                验证码错误
                            </p>
                            </div>
                          )}
                        </FormItem>
                      </Form>
                    )
                ) : (
                    <div style={{ marginTop: '24px', textAlign: 'center' }}>
                      <Icon
                        type="check-circle"
                        style={{ fontSize: 40, color: '#45be56' }}
                      />
                      <p
                        style={{
                          color: '#333',
                          fontSize: '14px',
                          marginTop: '16px'
                        }}
                      >
                        法人手机号验证成功
                    </p>
                    </div>
                  )}
              </Modal>
            ) : (
                ''
              )}
            <Modal
              title="法人手机验证"
              visible={this.state.visibleNoPhoneCode}
              onOk={this.handleNoPhoneCodeOk}
              onCancel={this.handleNoPhoneCodeCancel}
              okText="确认"
              footer={this.showNoPhoneModalFooter()}
            >
              {this.state.noPhoneContent === '' ? (
                <Form>
                  <FormItem
                    {...formItemLayoutMore}
                    label="手机号码"
                    className="code_yan"
                  >
                    <div style={{ display: 'flex' }}>
                      <div style={{ flex: 1 }}>
                        {getFieldDecorator('legalRepNoPhone', {
                          rules: [
                            {
                              message: '请输入手机号！'
                            },
                            {
                              validator: this.checkPhone
                            }
                          ]
                        })(
                          <div>
                            <Input
                              placeholder="请输入手机号"
                              maxLength={11}
                              id="code_a4"
                              onChange={this.codeChangeThree}
                            />
                            <p
                              id="code_p4"
                              style={{
                                marginBottom: 0,
                                color: 'red',
                                display: 'none',
                                fontSize: '14px',
                                lineHeight: '1.5',
                                marginTop: '2px'
                              }}
                            >
                              错误
                            </p>
                          </div>
                        )}
                      </div>
                      {this.onGetCaptchaNoPhone()}
                    </div>
                  </FormItem>
                  <FormItem
                    {...formItemLayoutMore}
                    label="验证码"
                    className="code_yan"
                  >
                    {getFieldDecorator('legalRepNoPhoneCode', {
                      rules: [
                        {
                          message: '请输入手机验证码！'
                        },
                        {
                          validator: this.checkPhoneCodeVlue
                        }
                      ]
                    })(
                      <div>
                        <Input
                          placeholder="请输入手机验证码"
                          maxLength={6}
                          id="code_a5"
                          onChange={this.codeChangeFour}
                        />
                        <p
                          id="code_p5"
                          style={{
                            marginBottom: 0,
                            color: 'red',
                            display: 'none',
                            fontSize: '14px',
                            lineHeight: '1.5',
                            marginTop: '2px'
                          }}
                        >
                          错误
                        </p>
                      </div>
                    )}
                  </FormItem>
                </Form>
              ) : (
                  <div style={{ marginTop: '24px', textAlign: 'center' }}>
                    <Icon
                      type="check-circle"
                      style={{ fontSize: 40, color: '#45be56' }}
                    />
                    <p
                      style={{
                        color: '#333',
                        fontSize: '14px',
                        marginTop: '16px'
                      }}
                    >
                      法人手机号验证成功
                  </p>
                  </div>
                )}
            </Modal>
            <Modal
              title="管理员确认"
              visible={this.state.administratorRelative.openValidAdminModal}
              onOk={this.handleValidAdminModalOk}
              onCancel={this.handleValidAdminModalCancel}
            >
              <Form>
                <FormItem
                  {...formItemLayoutMore}
                  label="姓名"
                  className="code_yan"
                >
                  <Input
                    className="set-input"
                    disabled
                    value={this.state.administratorRelative.administrator}
                  />
                </FormItem>
                <FormItem
                  {...formItemLayoutMore}
                  label="手机号码"
                  className="code_yan"
                >
                  <div style={{ display: 'flex' }}>
                    <Input
                      className="set-input"
                      disabled
                      value={
                        this.state.administratorRelative.phoneValueHiddenMiddle
                      }
                      style={{ flex: 1 }}
                    />
                    {this.getAdminValidCodeButton()}
                  </div>
                </FormItem>
                <FormItem
                  {...formItemLayoutMore}
                  label="验证码"
                  className="code_yan"
                >
                  {getFieldDecorator('adminValidCode', {
                    rules: [
                      {
                        message: '请输入手机验证码！'
                      },
                      {
                        validator: this.checkPhoneCodeVlue
                      }
                    ]
                  })(
                    <div>
                      <Input
                        placeholder="请输入手机验证码"
                        maxLength={6}
                        id="code_a5"
                        onChange={this.codeChangeFour}
                      />
                      <p
                        id="code_p5"
                        style={{
                          marginBottom: 0,
                          color: 'red',
                          display: 'none',
                          fontSize: '14px',
                          lineHeight: '1.5',
                          marginTop: '2px'
                        }}
                      >
                        错误
                      </p>
                    </div>
                  )}
                </FormItem>
              </Form>
            </Modal>
          </div>
        </div>
      </Container>
    );
  }
}

/*********************样式*************************** */
const Container = style.div`{
  .password-header{
      font-size: 20px;
      color: #333333;
      padding-bottom:16px;
      border-bottom:1px solid #e9e9e9;
  }
  .ant-btn-primary.getCaptcha{
      background-color: #0F71FF;
  }
  .authentication-sub-title{
      text-align:right;
      font-size: 16px;
      color: #333333;
      margin-bottom:24px;
  }
  .ant-upload-select-picture-card i {
      font-size: 32px;
      color: #999;
    }

    .ant-upload-select-picture-card .ant-upload-text {
      margin-top: 8px;
      color: #666;
    }
}`;
