import PDrawer from '../../../components/Pro/PDrawer';
import React from 'react';
import {
  Form,
  Input,
  Button,
  DatePicker,
  Popover,
  Icon,
  Radio,
  Select,
} from 'antd';
import {formItemLayout1} from './constants';
import {DrawHeader, Empty, DrawBottomBtns} from './styles';
import {OrganName} from './components';
import PCascader from '../../../components/Pro/PCascader';
import {enterpriseCompanyComBaseInfoGetComBaseInfoById, publicCommonDictGetDictByCodeTypes} from '../../../services/api';

const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const { TextArea } = Input;

@Form.create()
export default class DrawChildCompanyBasic extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      dataSource: {
        comName: "",//公司名称
        telePhone: "",//联系电话
        fax: "",//传真
        regProvince: 0,//注册所在省
        regCity: 0,//注册所在市
        regArea: 0,//注册所在区
        regAddress: "",//注册所在详细地址
        comType: "",//公司性质
        economicType: "",//经济类型
        industryType: "",//行业类型
        institutionType: "",//机构类型
        isBranchCom: "",//是否分公司
        parentComCerNo: "",//总公司证件扫描件
        parentComName: "",//总公司名称
        parentComRep: "",//总公司法人
        parentComTel: "",//总公司联系电话
      },
      codeTypes: {
        economicType: [],//经济类型
        industryType: [],//行业类型
        institutionType: [],//机构类型
        comType: [],//公司性质
      },
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
    this.publicCommonDictGetDictByCodeTypes();
  }
  componentWillReceiveProps = (nextProps, newState) => {
    if (nextProps.visible && !this.props.visible && !!nextProps.comId) {
      this.ajaxDetail(nextProps.comId);
    }
  }

  /******************************ajax请求******************************/
  ajaxDetail = (comBranchId) => {
    enterpriseCompanyComBaseInfoGetComBaseInfoById({comBranchId})
      .then(
        (data) => {
          console.log("子公司基础信息", data);
          const dataSource = this.state.dataSource;
          this.setState({dataSource: {...dataSource, ...data.data}});
        }
      )
      .catch(
        (err) => {
          console.log(err);
        }
      );
  }

  //类型查询
  publicCommonDictGetDictByCodeTypes = () => {
    publicCommonDictGetDictByCodeTypes({codeTypes: "economicType,industryType,institutionType,comType"}).then(({data = {}}) => {
      this.setState({codeTypes: data});
    });
  }

  /******************************相关事件******************************/

  closeDrawer = () => {
    this.props.closeDrawer();
  }


  /******************************render******************************/
  renderOption = (options) => {
    if (options.length === 0) {
      return;
    }
    return options.map(
      (val, key) => (
        <Option
          value={val.codeValue}
          key={key}>
          {val.label}
        </Option>
      ))
  }

  render() {
    const {visible} = this.props;
    const {getFieldDecorator} = this.props.form;
    const {
      comName,
      telePhone,
      fax,
      regProvince,
      regCity,
      regArea,
      regAddress,
      economicType,
      industryType,
      institutionType,
      comType,
      isBranchCom,
      parentComCerNo,
      parentComName,
      parentComRep,
      parentComTel
    } = this.state.dataSource;

    const {codeTypes} = this.state;
    return (
      <PDrawer
        // title="子公司基础信息"
        title="基础信息"
        visible={visible}
        okText={null}
        cancelText="返回"
        onCancel={this.closeDrawer}
        destroyOnClose={true}
      >
        <div>
          <Form onSubmit={this.handleSubmit} style={{width: 390, margin: "6px 0 81px 0"}}>
            <FormItem
              {...formItemLayout1}
              label="公司名称"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={comName}/>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="联系电话"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={telePhone}/>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="传真"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={fax}/>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="注册地址"
              style={{marginTop: 24}}
            >
              <PCascader
                style={{width: 294}}
                placeholder="请选择"
                disabled={true}
                value={[regProvince, regCity, regArea]}
              />
            </FormItem>

            <Empty>
              <FormItem
                {...formItemLayout1}
                label=""
                style={{marginTop: 24}}
              >
                {/* <Input
                  style={{width: 294}}
                  placeholder="请填写公司注册详细地址"
                  disabled={true}
                  value={regAddress}
                /> */}
                <TextArea autosize={{ minRows: 1, maxRows: 3 }} style={{ width: 294, maxWidth:294 }} placeholder="请填写公司注册详细地址" disabled value={regAddress}/>
              </FormItem>
            </Empty>

            <FormItem
              {...formItemLayout1}
              label="经济类型"
              style={{marginTop: 24}}
            >
              <Select disabled={true} value={economicType}>
                {this.renderOption(codeTypes.economicType)}
              </Select>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="行业类型"
              style={{marginTop: 24}}
            >
              <Select disabled={true} value={industryType}>
                {this.renderOption(codeTypes.industryType)}
              </Select>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="企业性质"
              style={{marginTop: 24}}
            >
              <Select disabled={true} value={comType}>
                {this.renderOption(codeTypes.comType)}
              </Select>
            </FormItem>


            <FormItem
              {...formItemLayout1}
              label="机构类型"
              style={{marginTop: 24}}
            >
              <Select disabled={true} value={institutionType}>
                {this.renderOption(codeTypes.institutionType)}
              </Select>
            </FormItem>


            {/* <FormItem
              {...formItemLayout1}
              label="是否为分／子公司"
              style={{marginTop: 24}}
            >
              <RadioGroup disabled={true} value={parseInt(isBranchCom ? 1 : 2)}>
                <Radio value={1}>分公司</Radio>
                <Radio value={2}>子公司</Radio>
              </RadioGroup>
            </FormItem>


            <FormItem
              {...formItemLayout1}
              label="总公司统一社会信用代码"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={parentComCerNo}/>
            </FormItem>


            <FormItem
              {...formItemLayout1}
              label="总公司名称"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={parentComName}/>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="总公司法人"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={parentComRep}/>
            </FormItem>

            <FormItem
              {...formItemLayout1}
              label="总公司联系电话"
              style={{marginTop: 24}}
            >
              <Input style={{width: 294}} disabled={true} value={parentComTel}/>
            </FormItem> */}
          </Form>
        </div>
      </PDrawer>
    );
  }
}
