/**
 * @author  Xyz
 * 分公司管理-分公司详情
 */
import PDrawer from '../../../components/Pro/PDrawer';
import PSelect from '../../../components/Pro/PSelect';
import React from 'react';
import {
  Form,
  Input,
  Button,
  DatePicker,
  Popover,
  Icon,
  Radio,
  Select
} from 'antd';
import {formItemLayout1} from './constants';
import {DrawHeader, Empty, DrawBottomBtns} from './styles';
import {OrganName} from './components';
import PCascader from '../../../components/Pro/PCascader';
import {enterpriseComManagerGetComBaseInfoById, publicCommonDictGetDictByCodeTypes} from '../../../services/api';
import bcx_utils from '../../../common/bcx_utils';

const RadioGroup = Radio.Group;
const Option = Select.Option;

const FormItem = Form.Item;

PSelect.allSelcet("nation,idCardType_bak,education,skillLevel");

@Form.create()
export default class DrawBranchCompanyDetail extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      dataSource: {
        "comId": "",
        "sessionId": "",
        "comManagerId": "",
        "idCardType": "",//身份证件类型
        "idCardNo": "",//证件号码
        "name": "",//姓名
        "sex": "0",
        "nation": "",//民族
        "residentProvince": 0,//户口所在省
        "residentCity": 0,//户口所在城市
        "residentArea": 0,//户口所在区
        "residenceAddress": "",
        "telephone": "",//联系方式
        "education": "",//学历
        "positionName": "",//职务
        "domicileProvince": 0,//居住地所在省
        "domicileCity": 0,//居住地所在市
        "domicileArea": 0,//居住地所在区
        "domicileAddress": "",//居住具体地址
        "jobSkillLevel": "",//职业技能等级
        "sexName": "",
        "idCardTypeName": ""
      },
      codeTypes: {
        education: [],//学历
        idCardType_bak: [],//身份证
        nation: [],//民族
        skillLevel: [],//职业技能等级
      }//所有类型
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
    // this.publicCommonDictGetDictByCodeTypes();
  }
  componentWillReceiveProps = (nextProps, newState) => {
    if (nextProps.visible && !this.props.visible && nextProps.comManagerId) {
      this.ajaxDetail(nextProps.comManagerId);
    }
  }
  /******************************ajax请求******************************/
  ajaxDetail = (comManagerId) => {
    enterpriseComManagerGetComBaseInfoById({comManagerId})
      .then(
        (data) => {
          console.log("管理层详情", data);
          const dataSource = {...this.state.dataSource}
          this.setState({dataSource: {...dataSource, ...data.data,}});
        }
      )
      .catch(
        (err) => {
          console.log(err);
        }
      );
  }
  //类型查询
  publicCommonDictGetDictByCodeTypes = () => {
    publicCommonDictGetDictByCodeTypes({codeTypes: "nation,idCardType_bak,education,skillLevel"}).then((data) => {
      console.log("类型查询", data);
      this.setState({codeTypes: data.data});
    }, (err) => {
      console.log(err);
    });
  }

  /******************************相关事件******************************/

  closeDrawer = () => {
    this.props.closeDrawer();
  }


  /******************************render******************************/
  renderOption = (options) => {
    if (options.length === 0) {
      return;
    }
    return options.map(
      (val, key) => (
        <Option
          value={val.codeValue}
          key={key}>
          {val.label}
        </Option>
      ))
  }

  render() {
    const {visible} = this.props;
    const {getFieldDecorator} = this.props.form;
    const {
      name,
      positionName,
      nation,
      sex,
      residentProvince,
      residentCity,
      residentArea,
      idCardType,
      idCardNo,
      telephone,
      education,
      domicileProvince,
      domicileCity,
      domicileArea,
      domicileAddress,
      jobSkillLevel
    } = this.state.dataSource;
    const {codeTypes} = this.state;
    return (
      <div>
        <PDrawer
          title="管理层详情"
          visible={visible}
          okText={null}
          cancelText="返回"
          onCancel={this.closeDrawer}
          onOk={this.handleSubmit}
          destroyOnClose={true}
        >
          <div>
            <Form onSubmit={this.handleSubmit} style={{width: 390, margin: "6px 0 81px 0"}}>
              <FormItem
                {...formItemLayout1}
                label="姓名"
                style={{marginTop: 24}}
              >
                <Input style={{width: 294}} disabled={true} value={name}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="职务"
                style={{marginTop: 24}}
              >
                <Input style={{width: 294}} placeholder="请输入" disabled={true} value={positionName}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="性别"
                style={{marginTop: 24}}
              >
                <RadioGroup disabled={true} value={parseInt(sex)}>
                  <Radio value={1}>男</Radio>
                  <Radio value={2}>女</Radio>
                </RadioGroup>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="民族"
                style={{marginTop: 24}}
              >
                <PSelect type="nation" value={nation}  disabled={true} style={{width: 294}}/>
              </FormItem>

              <FormItem
                {...formItemLayout1}
                label="户籍"
                style={{marginTop: 24}}
              >
                <PCascader
                  style={{width: 294}}
                  placeholder="请选择"
                  disabled={true}
                  value={[residentProvince, residentCity, residentArea]}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="证件类型"
                style={{marginTop: 24}}
              >
                <PSelect type="idCardType_bak" value={idCardType} disabled={true} style={{width: 294}}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="证件号"
                style={{marginTop: 24}}
              >
                <Input style={{width: 294}} placeholder="请输入" disabled={true} value={idCardNo}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="联系方式"
                style={{marginTop: 24}}
              >
                <Input style={{width: 294}} placeholder="请输入" disabled={true} value={telephone}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="学历"
                style={{marginTop: 24}}
              >

                <PSelect type="education" value={education} disabled={true} style={{width: 294}}/>
              </FormItem>
              <FormItem
                {...formItemLayout1}
                label="居住地"
                style={{marginTop: 24}}
              >
                <PCascader
                  style={{width: 294}}
                  placeholder="请选择"
                  disabled={true}
                  value={[domicileProvince, domicileCity, domicileArea]}
                />
              </FormItem>
              <Empty>
                <FormItem
                  {...formItemLayout1}
                  label=""
                  style={{marginTop: 24}}
                >
                  <Input style={{width: 294}} placeholder="请输入详细地址" disabled={true} value={domicileAddress}/>
                </FormItem>
              </Empty>
              <FormItem
                {...formItemLayout1}
                label="职业技能等级"
                style={{marginTop: 24}}
              >
                <PSelect type="skillLevel" value={jobSkillLevel} disabled={true} style={{width: 294}}/>
              </FormItem>
            </Form>
          </div>
        </PDrawer>
      </div>
    );
  }
}
