import React from 'react';

import {
  Container,
} from "./styles";

import {
  Form,
  Input,
  Button,
  message,
  Table,
  Popover,
  Tabs,
} from 'antd';

import TabManage from './TabManage';
import TabRecord from './TabRecord';

const TabPane = Tabs.TabPane;

export default class BranchCompanyTab extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      cursor: "1"
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/
  tabChange = (e) => {
    this.setState({cursor: e});
  }

  /******************************render******************************/

  render() {
    const {cursor} = this.state;
    return (
      <Container>
        <Tabs defaultActiveKey={cursor} onChange={this.tabChange}>
          <TabPane tab="分公司管理层" key="1">
            {cursor === "1" && <TabManage/>}
          </TabPane>
          <TabPane tab="分公司管理层变更记录" key="2">
            {cursor === "2" && <TabRecord/>}
          </TabPane>
        </Tabs>

      </Container>
    );
  }
}

