/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from 'react';
import { Pagination, Drawer, Form, Input } from 'antd';
import './index.less';

export default class SearchList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: props.visible,
      list: props.value,
      total: props.total,
      pageSize: props.pageSize,
      selectedIndex: props.selectedIndex, //选中的数据
      pageNumber: props.pageNumber
    };
  }

  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      visible: nextProps.visible,
      list: nextProps.value,
      // totalPage: nextProps.totalPage,
      total: nextProps.total,
      pageSize: nextProps.pageSize,
      selectedIndex: nextProps.selectedIndex,
      pageNumber: nextProps.pageNumber
    });
  }

  render() {
    return (
      <div
        className="security search-list amap_lib_placeSearch"
        style={{ display: this.state.list.length > 0 ? 'block' : 'none' }}
      >
        <div className="security-personnel">
          <span>保安人员</span>
        </div>
        <div className="list" style={{maxHeight:'660px',overflow:'auto'}}>
          {this.state.list.map((item, index) => {
            const xing = '********';
            let idCardNo = '';
            if (item.idCardNo) {
              let front6 = item.idCardNo.substring(0, 6);
              idCardNo =
                front6 +
                xing +
                item.idCardNo.substring(14, item.idCardNo.length);
            }
            // const idCardNo = item.idCardNo;
            // if (item.idCardNo.length > 0) {
            //
            //
            //   // for (var i = 4; i < 9; i++) {
            //   //   xing += '*';
            //   // }
            // }
            return (
              <div
                key={index}
                className="item"
                onClick={() => {
                  if (item.lnglat) {
                    this.props.onClick(item, index);
                    this.setState({
                      selectedIndex: index
                    });
                  }
                }}
              >
                <div
                  className={
                    this.state.selectedIndex === index
                      ? 'selected poibox'
                      : 'poibox'
                  }
                >
                  {item.lnglat && (
                    <div className="amap_lib_placeSearch_poi poibox-icon">
                      {index}
                    </div>
                  )}
                  <div style={{ marginLeft: 25 }}>
                    <div className="name">{item.name}</div>
                    <div className="text">手机号码:{item.mobilePhone}</div>
                    {/* <div>所属公司:{item.com}</div> */}
                    <div className="text">证件号码:{idCardNo}</div>
                    {/* <div className="address">
                    所属驻勤点:{item.attendancePoints}
                  </div> */}
                  </div>
                </div>
              </div>
            );
          })}
        </div>

        <Pagination
          total={this.state.total}
          size="small"
          onChange={number => {
            this.setState({ pageNumber: number });
            this.props.onChangePagination(number);
          }}
          defaultPageSize={this.state.pageSize}
          current={this.state.pageNumber}
          style={{ display: this.state.total>this.state.pageSize ? 'block' : 'none' }}
        />
      </div>
    );
  }
}
