/**
 * 证书信息
 */
import React, { Component } from 'react';
import {
  systemPerCerBaseInfoFindAll,
  publicCommonDictGetDictByCodeTypes,
  systemComDepartGetDepartTree,
  getPerType,
  systemComRoleFindAllRole
} from '../../../../services/api';
import { Form, Card, Select, DatePicker, TreeSelect } from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 8 }
  }
};
@Form.create()
export default class CertificateInfo extends Component {
  constructor(props) {
    super(props);
    console.log(props);
    this.state = {
      perId: props.perId,
      certificateInfo:[]
    };
  }

  componentDidMount() {
    this._getAllCertificateInformation(this.state.perId);
    // this._getIdcardType();
    // this._getDepartTree();
    // this._getResponse();
    // this._getRoldList();
  }
  componentWillReceiveProps(nextProps) {
    console.log(nextProps);
    if (nextProps.perId !== this.state.perId) {
      this.setState({
        perId: nextProps.perId
      });
      this._getBaseInfo(nextProps.perId);
    }
  }
  _getAllCertificateInformation(perId) {
    systemPerCerBaseInfoFindAll({ perId }).then(
      res => {
        console.log('获取所有证书', res);
        if (res.retType === '0' && res.data) {
          this.setState({ certificateInfo: res.data });

          // const currentList = Array.from(
          //   new Set(res.data.map(v => v.perCerType))
          // );
          // console.log(currentList, 'currentList');
          // let newPerCerType = [];
          // perCerType.forEach(element => {
          //   let tmp = element;
          //   let has = false;
          //   currentList.forEach(v => {
          //     if (v == element.codeValue) {
          //       has = true;
          //     }
          //   });
          //   if (!has) {
          //     newPerCerType.push(tmp);
          //   }
          // });
          // console.log(newPerCerType, 'newPerCerType');
          // const isShowNewAddPlus = newPerCerType.length > 0 ? true : false;
          // this.setState({
          //   newPerCerType,
          //   isShowNewAddPlus
          // });
        }
      },
      err => {
        console.log('获取所有证书错误信息', err);
      }
    );
  }
  render() {
    const { getFieldDecorator } = this.props.form;

    return (
      <div>
        {this.state.certificateInfo.map((val, index) => {
          return (
            <Card title={val.perCerTypeName ? val.perCerTypeName : '-'} key={index}> 
              <p className="list-line">
                <span>证书等级:</span>
                <span>{val.perCerLevelName ? val.perCerLevelName : '-'}</span>
              </p>
              <p className="list-line">
                <span>证书编号:</span>
                <span>{val.cerNo}</span>
              </p>
              <p className="list-line">
                <span>发证机关:</span>
                <span>{val.licenceOrg}</span>
              </p>
              <p className="list-line">
                <span>发证日期:</span>
                <span>{val.licenceDate ? moment(val.licenceDate).format('YYYY-MM-DD') : '-'}</span>
              </p>
            </Card>
          );
        })}
      </div>
    );
  }
}
