/**
 * 人员详细信息框架
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import { Tabs, Button, Form, Input } from 'antd';
import './index.less';
import BaseInfo from './DetailInfo/BaseInfo';
import DetailInfo from './DetailInfo/DetailInfo';
import CertificateInfo from './DetailInfo/CertificateInfo';
const { TabPane } = Tabs;
@connect(state => ({
  // perId: state.user.currentUser.perId
}))
export default class Detail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: props.visible,
      perId: props.perId,
      changeTab: '1'
    };
  }

  componentDidMount() {
    // console.log(this.props.perId)
  }
  componentWillReceiveProps(nextProps) {
    console.log(nextProps);
    if (
      this.state.visible !== nextProps.visible ||
      this.state.perId !== nextProps.perId
    ) {
      this.setState({
        visible: nextProps.visible,
        perId: nextProps.perId
      });
    }
  }
  changeTab(e) {
    this.setState({
      changeTab: e
    });
  }
  render() {
    return (
      <div
        className="detail"
        style={{ display: this.state.visible ? 'block' : 'none' }}
      >
        <Tabs defaultActiveKey="1" onChange={e => this.changeTab(e)}>
          <TabPane tab="基础信息" key="1">
            {this.state.visible && this.state.changeTab === '1' ? (
              <BaseInfo perId={this.state.perId} />
            ) : (
              ''
            )}
          </TabPane>
          <TabPane tab="详细信息" key="2">
            {this.state.visible && this.state.changeTab === '2' ? (
              <DetailInfo perId={this.state.perId} />
            ) : (
              ''
            )}
          </TabPane>
          <TabPane tab="证书信息" key="3">
            {this.state.visible && this.state.changeTab === '3' ? (
              <CertificateInfo perId={this.state.perId} />
            ) : (
              ''
            )}
          </TabPane>
          <TabPane tab="职业信息" key="4">
            Content of Tab Pane 3
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
