/**
 * 驻勤点的类型
 */
import React, { Component } from "react";
import { Tooltip, Button, Row, Col, message } from "antd";
import "./attendance.less";
import {
  // getComTaskStationType,
  getComTempTaskStationType,
  // getComTaskList,
  getComTempTaskList
} from "../../../../services/api";
const data = [
  {
    title: "党政机关",
    typeName: "policy",
    initPng: require("../../../../assets/images/prevention/attendance/policy_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/policy_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/policy_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/policy.png"),
    key: "01",
    whetherHas: false, //当前的公司是否有该类型的驻勤点
    whetherClick: false //是否点击
  },
  {
    title: "高等院校",
    typeName: "school",
    initPng: require("../../../../assets/images/prevention/attendance/school_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/school_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/school_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/school.png"),
    key: "02",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "公共安全",
    typeName: "safety",
    initPng: require("../../../../assets/images/prevention/attendance/safety_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/safety_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/safety_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/safety.png"),
    key: "03",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "公园景点",
    typeName: "park",
    initPng: require("../../../../assets/images/prevention/attendance/park_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/park_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/park_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/park.png"),
    key: "04",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "轨道交通",
    typeName: "pathway",
    initPng: require("../../../../assets/images/prevention/attendance/pathway_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/pathway_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/pathway_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/pathway.png"),
    key: "05",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "金融初始",
    typeName: "financial",
    initPng: require("../../../../assets/images/prevention/attendance/financial_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/financial_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/financial_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/financial.png"),
    key: "06",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "酒店餐饮",
    typeName: "hotel",
    initPng: require("../../../../assets/images/prevention/attendance/hotel_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/hotel_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/hotel_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/hotel.png"),
    key: "07",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "居民社区",
    typeName: "resident",
    initPng: require("../../../../assets/images/prevention/attendance/resident_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/resident_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/resident_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/resident.png"),
    key: "08",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "企事业单位",
    typeName: "enterprise",
    initPng: require("../../../../assets/images/prevention/attendance/enterprise_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/enterprise_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/enterprise_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/enterprise.png"),
    key: "09",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "商市场",
    typeName: "bazaar",
    initPng: require("../../../../assets/images/prevention/attendance/bazaar_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/bazaar_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/bazaar_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/bazaar.png"),
    key: "10",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "医疗机构",
    typeName: "medical",
    initPng: require("../../../../assets/images/prevention/attendance/medical_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/medical_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/medical_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/medical.png"),
    key: "11",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "娱乐场所",
    typeName: "recreation",
    initPng: require("../../../../assets/images/prevention/attendance/recreation_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/recreation_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/recreation_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/recreation.png"),
    key: "12",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "文化/会展",
    typeName: "convention",
    initPng: require("../../../../assets/images/prevention/attendance/convention_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/convention_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/convention_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/convention.png"),
    key: "13",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "园区",
    typeName: "garden",
    initPng: require("../../../../assets/images/prevention/attendance/garden_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/garden_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/garden_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/garden.png"),
    key: "14",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "乡镇街道",
    typeName: "street",
    initPng: require("../../../../assets/images/prevention/attendance/street_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/street_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/street_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/street.png"),
    key: "15",
    whetherHas: false,
    whetherClick: false
  },
  {
    title: "小学幼儿园",
    typeName: "kindergarten",
    initPng: require("../../../../assets/images/prevention/attendance/kindergarten_init.png"),
    clickPng: require("../../../../assets/images/prevention/attendance/kindergarten_click.png"),
    grayPng: require("../../../../assets/images/prevention/attendance/kindergarten_gray.png"),
    markerIcon: require("../../../../assets/images/prevention/attendance/marker/kindergarten.png"),
    key: "16",
    whetherHas: false,
    whetherClick: false
  }
];
export default class AttendanceType extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: data,
      activityNo: props.activityNo,
      // searchData: {
      //   pageNumber: 1,
      //   pageSize: 10
      // },
      pageSize: 3,
      currentComType: [], //当前的公司拥有的类型
      markerAttendance: [], //需要打点的驻勤点
      layerSatatus: props.layerSatatus,
      width: null //最大宽度
      // isSecuOrAtten: props.isSecuOrAtten
    };
  }

  componentDidMount() {
    const width = document.documentElement.clientWidth - (346 + 80) * 2 - 10;
    this.setState({ width });
    //获取该公司拥有的驻勤点类型
    this.getCurrentType();
    this.props.iconData(data);
  }
  componentWillReceiveProps(nextPorps) {
    this.setState({
      // isSecuOrAtten: nextPorps.isSecuOrAtten,
      layerSatatus: nextPorps.layerSatatus
    });
    if (this.state.activityNo !== nextPorps.activityNo) {
      this.setState(
        {
          activityNo: nextPorps.activityNo
        },
        () => {
          this.getCurrentType();
        }
      );
    }
  }
  //获取住勤点类型
  getCurrentType() {
    // getComTaskStationType({}).then(res => {
    getComTempTaskStationType({
      activityNo: this.state.activityNo
    }).then(res => {
      this.setState({
        currentComType: res.data
      });
      if (res.retType === "0" && res.data.length > 0) {
        const data = this.state.data;
        for (let i = 0; i < res.data.length; i++) {
          for (let j = 0; j < this.state.data.length; j++) {
            if (res.data[i].taskStationType == this.state.data[j].key) {
              data[j].whetherHas = true;
              data[j].whetherClick = true;
              this.getAttendanceList(
                res.data[i].taskStationType,
                data[j].markerIcon,
                data[j].typeName
              );
            }
          }
        }
        // this.props.attendanceTypeData(data);
        this.setState({
          data
        });
      }
    });
  }
  //获取驻勤点
  getAttendanceList(
    taskStationType,
    markerIcon,
    typeName,
    pageNumber = 1,
    pageSize = this.state.pageSize
  ) {
    getComTempTaskList({
      pageNumber,
      pageSize,
      activityNo: this.state.activityNo,
      taskStationType
    }).then(res => {
      if (res.retType === "0" && res.data.data.length > 0) {
        const list = res.data.data;
        list.map((item, index) => {
          list[index].markerIcon = markerIcon;
        });
        const data = this.state[typeName] || [];
        data.push(...list);
        this.setState({
          [typeName]: data
        });
        this.props.attendanceList(data, typeName);
        if (res.data.total > pageNumber * pageSize) {
          this.getAttendanceList(
            taskStationType,
            markerIcon,
            typeName,
            pageNumber + 1
          );
        }
      }
    });
  }
  render() {
    return (
      <div
        className="attendance-type"
        style={{
          // display: this.state.layerSatatus === "attendance" ? "block" : "none",
          display: "none",
          maxWidth: this.state.width
        }}
      >
        {this.state.data.map((item, index) => {
          return (
            <div
              className="item-icon"
              key={item.key}
              onClick={() => {
                if (item.whetherHas) {
                  let data = this.state.data;
                  data[index].whetherClick = !data[index].whetherClick;
                  this.props.removeORshow(
                    item.typeName,
                    data[index].whetherClick
                  );
                  this.setState({ data });
                } else {
                  message.warning("该类型驻勤点没有数据");
                  return;
                }
              }}
            >
              <Tooltip placement="top" title={item.title}>
                <img
                  src={
                    item.whetherClick
                      ? item.clickPng
                      : item.whetherHas
                      ? item.initPng
                      : item.grayPng
                  }
                  style={{
                    padding: item.whetherHas ? "unset" : "10px"
                    // padding: item.whetherClick?'unset':this.state.whetherHas ? 'unset' : '10px'
                  }}
                ></img>
              </Tooltip>
              <span
                className="label"
                style={{
                  color: item.whetherClick
                    ? "#4285EC"
                    : item.whetherHas
                    ? "unset"
                    : "#DBDBDB"
                }}
              >
                {item.title}
              </span>
            </div>
          );
        })}
      </div>
    );
  }
}
