/**
 * 初始化多个页面的地图
 */
export default function () {
  const { AMap, Loca } = window;
  //驻勤点图层
  const normalMap = new AMap.Map("map_container", {
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: 12,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: [3, 20],
  });
  //海量图层
  const locaMap = new AMap.Map("map_container2", {
    // features: ["bg", "road"],
    // mapStyle: "amap://styles/midnight",
    // zoom: 5,
    // viewMode: "2D",
    // skyColor: "#33216a",
    mapStyle: "amap://styles/dark",
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: 10,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: [3, 20],
  });
  //人员图层
  const personMap = new AMap.Map("map_container3", {
    mapStyle: "amap://styles/dark",
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: 10,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: [3, 20],
  });
  if (AMap.ControlBar) {
    locaMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
    normalMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
    personMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
  }
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    offset: new AMap.Pixel(16, -45),
  });
  normalMap.on("zoomchange", (info) => {
    let zoom = normalMap.getZoom(); //获取当前地图级别
    // if (zoom > 6) {
    //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
    //     let index = i + 1;
    //     this.state['mass' + index].setStyle({
    //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
    //       anchor: new AMap.Pixel(3, 3),
    //       size: new AMap.Size(5, 5)
    //     });
    //   }
    // } else {
    //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
    //     let index = i + 1;
    //     this.state['mass' + index].setStyle({
    //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
    //       anchor: new AMap.Pixel(3, 3),
    //       size: new AMap.Size(1.5, 1.5)
    //     });
    //   }
    // }
  });
  return {
    normalMap,
    locaMap,
    personMap,
    infoWindow,
  };
}
