import React, { PureComponent } from "react";
import AllPerson from "./AllPerson";
import AddressBook from "./AddressBook/index";
import Group from "./group";
import { Tabs } from "antd";
import { connect } from "dva";

const { TabPane } = Tabs;
@connect((state) => ({
  tabIndex: state.command.tabIndex,
}))
export default class PersonMessage extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      visible: props.visible,
    };
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.visible !== this.state.visible) {
      this.setState({
        visible: nextProps.visible,
      });
    }
  }
  clickTextScheduling(item, type, isNeedRecord) {
    this.props.clickTextScheduling(item, type, isNeedRecord);
    this.props.dispatch({
      type: "command/setPersonSelectIndex",
      payload: null,
    });
  }
  render() {
    return (
      <div
        className="child-searchList all-person"
        style={{ display: this.state.visible ? "block" : "none" }}
      >
        <Tabs
          defaultActiveKey={this.props.tabIndex.person.tabIndex2 || "1"}
          onChange={(index) => {
            this.props.dispatch({
              type: "command/setTabIndex",
              payload: {
                person: {
                  tabIndex2: index,
                },
              },
            });
            this.props.dispatch({
              type: "command/clearInfoWindow",
              payload: true,
            });
          }}
        >
          <TabPane tab="所有人员" key="1">
            <AllPerson
              key="1"
              onClickPerson={(item, index) => {
                this.props.onClickPerson(item, index);
              }}
              //点击调度
              clickTextScheduling={(item, type, isNeedRecord) => {
                this.clickTextScheduling(item, type, isNeedRecord);
              }}
            />
          </TabPane>
          {/* <TabPane tab="通讯录" key="2">
            <AddressBook //点击调度
              key="2"
              clickTextScheduling={(item, type) => {
                this.clickTextScheduling(item, type);
              }}
            />
          </TabPane>
          <TabPane tab="群组" key="3">
            <Group
              key="3"
              clickTextScheduling={(item, type) => {
                this.clickTextScheduling(item, type);
              }}
              changeImStatus={(value) => {
                this.props.changeImStatus(value);
              }}
              groupVideo={(list) => {
                this.props.groupVideo(list);
              }}
            />
          </TabPane> */}
        </Tabs>
      </div>
    );
  }
}
