//打点（人员跟驻勤点的样式）
//事件列表对搜索出的人员打点
export function markEventList(eventList, where = "") {
  let eventMarkers = [];
  eventList.length > 0 &&
  eventList.map((item, index) => {
      const map = this.state.map;
      if (item.lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: "负责人:" + item.name || "--",
          content:
            '<div class="amap_lib_placeSearch_poi poibox-icon">' +
            index +
            "</div>",
          key: item.id,
          indexText: index,
        });
        const that = this;
        // 手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function () {
          that.props.dispatch({
            type: "command/setEventSelectIndex",
            payload: marker.w.key,
          });
          that.openEventInfo(item, map, marker);
        });
        marker.setAnimation("AMAP_ANIMATION_DROP");
        eventMarkers.push(marker);
      }
    });
  this.state.map.add(eventMarkers);
  this.state.map.setFitView(eventMarkers); //自适应显示所有的标注点
  return eventMarkers;
  // this.setState({ personMarkers });
}

//事件的打点更换
export function openEventInfo(item, map, marker) {
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    content: this.createEventInfoWindow(item),
    offset: new AMap.Pixel(16, -45),
  });
  infoWindow.open(this.state.map, marker.getPosition());
  const markers = this.state.eventMarkers;
  markers.map((itemMark, i) => {
    if (itemMark.w.key === item.id) {
      markers[i].setContent(
        '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div></div>"
      );
    } else {
      markers[i].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div>"
      );
    }
  });
  this.state.map.setZoomAndCenter(this.state.zoom, [
    marker.getPosition().lng,
    marker.getPosition().lat,
  ]); //同时设置地图层级与中心点
  // this.state.map.setCenter(marker.getPosition());//设置中心点
  // this.setState({
  //   personMarkers: markers,
  // });
  return markers;
}

//人员的打点更换图标，切换成未打点状态
export function closeEventMarkers() {
  const markers = this.state.eventMarkers;
  markers.map((itemMark, i) => {
    markers[i].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon">' +
        itemMark.w.indexText +
        "</div>"
    );
  });
  return markers;
}

//人员图层对搜索出的人员打点
export function markPersonList(personList, where = "") {
  // where代表搜索的值，“软件园三期”“百川信”有特殊的打点位置需求
  if (!!this.state.personMarkers) {
    this.state.map.remove(this.state.personMarkers);
  }
  if (this.state.beijingMarkers) {
    this.state.map.remove(this.state.beijingMarkers);
  }
  if (this.state.gaoqiMarkers) {
    this.state.map.remove(this.state.gaoqiMarkers);
  }
  let personMarkers = [];
  personList.length > 0 &&
    personList.map((item, index) => {
      const map = this.state.map;
      if (item.lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: "负责人:" + item.name || "--",
          content:
            '<div class="amap_lib_placeSearch_poi poibox-icon">' +
            index +
            "</div>",
          key: item.perId,
          indexText: index,
        });
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function () {
          that.props.dispatch({
            type: "command/setPersonSelectIndex",
            payload: marker.w.key,
          });
          that.openPersonInfo(item, map, marker);
        });
        marker.setAnimation("AMAP_ANIMATION_DROP");
        personMarkers.push(marker);
      }
    });
  this.state.map.add(personMarkers);
  if (where === "厦门软件园三期" || where === "软件园三期") {
    let allMark = [];
    //假的点,用来居中到软三的作用
    var marker1 = new AMap.Marker({
      position: new AMap.LngLat(118.051211, 24.60608), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
    });
    allMark.push(marker1);
    var marker2 = new AMap.Marker({
      position: new AMap.LngLat(118.047843, 24.611016), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
    });
    allMark.push(marker2);
    this.state.map.setFitView(allMark);
  } else {
    this.state.map.setFitView(personMarkers); //自适应显示所有的标注点
  }
  return personMarkers;
  // this.setState({ personMarkers });
}

//人员的打点更换
export function openPersonInfo(item, map, marker) {
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    content: this.createInfoWindow(item),
    offset: new AMap.Pixel(16, -45),
  });
  infoWindow.open(this.state.map, marker.getPosition());
  const markers = this.state.personMarkers;
  markers.map((itemMark, i) => {
    if (itemMark.w.key === item.perId) {
      markers[i].setContent(
        '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div></div>"
      );
    } else {
      markers[i].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div>"
      );
    }
  });
  this.state.map.setZoomAndCenter(this.state.zoom, [
    marker.getPosition().lng,
    marker.getPosition().lat,
  ]); //同时设置地图层级与中心点
  // this.state.map.setCenter(marker.getPosition());//设置中心点
  // this.setState({
  //   personMarkers: markers,
  // });
  return markers;
}

//人员的打点更换图标，切换成未打点状态
export function closePersonMarkers() {
  const markers = this.state.personMarkers;
  markers.map((itemMark, i) => {
    markers[i].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon">' +
        itemMark.w.indexText +
        "</div>"
    );
  });
  return markers;
}

//搜索出的驻勤点打点
export function markerAttendanceList(attendanceList, typeName = "") {
  //先删除之前的打点
  if (!!this.state.attendanceMarkers) {
    //如果是搜索列表的打点，先删除之前地图上的搜索的驻勤标记
    this.state.map.remove(this.state.attendanceMarkers);
  }
  let attendanceMarkers = [];
  const length = attendanceList.length;
  if (length > 0) {
    for (let i = 0; i < length; i++) {
      if (attendanceList[i].lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(
            attendanceList[i].lnglat[0],
            attendanceList[i].lnglat[1]
          ), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: "负责人:" + attendanceList[i].name || "--",
          content: attendanceList[i].markerIcon
            ? '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
              attendanceList[i].markerIcon +
              ')">' +
              "</div>"
            : '<div class="amap_lib_placeSearch_poi poibox-icon">' + "</div>",
          comTaskId: attendanceList[i].comTaskId,
          markerIcon: attendanceList[i].markerIcon,
          clickMarkerIcon: attendanceList[i].clickMarkerIcon,
        });
        marker.setAnimation("AMAP_ANIMATION_DROP");
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function () {
          that.props.dispatch({
            type: "command/setSelectIndex",
            // payload: marker.w.comTaskId,
            payload: i,
          });
        });
        attendanceMarkers.push(marker);
      }
    }
  }
  this.state.map.add(attendanceMarkers);
  this.state.map.setFitView(attendanceMarkers); //自适应显示所有的标注点
  return attendanceMarkers;
  // this.setState({ attendanceMarkers });
}

//驻勤点的打点更换
export function openAttendanceInfo(item, map, marker,currentIndex,afterIndex) {
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    content: this.createAttendanceInfoWindow(item),
    offset: new AMap.Pixel(16, -45),
  });
  infoWindow.open(map, marker.getPosition());
  map.setZoomAndCenter(this.state.zoom, [item.lnglat[0], item.lnglat[1]]); //同时设置地图层级与中心点
  // map.setCenter([item.lnglat[0], item.lnglat[1]]);
  const markers = this.state.attendanceMarkers;
  // markers.map((itemMark, i) => {
  //   if (itemMark.w.comTaskId == item.comTaskId) {
  //     markers[i].setContent(
  //       '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
  //         itemMark.w.clickMarkerIcon +
  //         ')">' +
  //         "</div>"
  //     );
  //   } else {
  //     markers[i].setContent(
  //       '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
  //         itemMark.w.markerIcon +
  //         ')">' +
  //         "</div>"
  //     );
  //   }
  // });
  // this.setState({
  //   attendanceMarkers: markers,
  // });
    markers[currentIndex].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
      markers[currentIndex].w.clickMarkerIcon +
        ')">' +
        "</div>"
    );
    if(afterIndex!=null&&afterIndex!=currentIndex){
        markers[afterIndex].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        markers[afterIndex].w.markerIcon +
          ')">' +
          "</div>"
      );
    }
  return markers;
}

//驻勤点的打点更换图标，切换成未打点状态
export function closeAttendanceMarker() {
  const markers = this.state.attendanceMarkers;
  markers.map((itemMark, i) => {
    markers[i].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        itemMark.w.markerIcon +
        ')">' +
        "</div>"
    );
  });
  // this.setState({
  //   attendanceMarkers: markers,
  // });
  return markers;
}
