/**
 * IM可视化视图
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, Drawer, Form, message, Button } from "antd";
import { imKey } from "../../../utils/config";
import "./im.less";
import SideBar from "./SideBar";
import CurrentConversation from "./CurrentConversation";
import tim from "../../../utils/imInitialize";
import TIM from "tim-js-sdk";
import store1 from "../../../../src/index";
import { routerRedux } from "dva/router";
// import axios from 'axios';

@connect((state) => ({
  adminPhone: state.global.companyInfo.adminPhone,
  imIsLogin: state.global.imIsLogin,
  imSig: state.global.imSig,
  username: state.user.currentUser.userName,
  currentConversation: state.im.currentConversation,
  currentMessageList: state.im.currentMessageList,
}))
export default class IM extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: props.visible,
      // creatType: props.creatType,
      // userID: props.userID,
      conversationID: props.conversationID,
    };
  }
  componentDidMount() {
    // 初始化监听器
    this.initListener();
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      visible: nextProps.visible,
      // creatType: nextProps.creatType,
      // userID: nextProps.userID,
      conversationID: nextProps.conversationID,
    });
    if (this.props.imIsLogin && nextProps.visible) {
      // this.createPerson(nextProps.userID);//创建的是个人对个人
      // this.createGroup();//创建的是普通的群聊模式，type没有设置，默认是私有群
      // this.addFriend()
    }
  }
  initListener() {
    // if (!!!this.props.imIsLogin) {
    //   console.log('重新请求');
    //   if (this.props.username) {
    //     this.props.dispatch({
    //       type: `global/imLogin`,
    //       payload: {
    //         username: this.props.username
    //       }
    //     });
    //     // this.getUsername()
    //   } else {
    //     //先去请求username，后续补充
    //     setTimeout(function() {
    //       console.log(this.props);
    //       //   this.getUsername()
    //     }, 2000);
    //   }
    // }
    // 登录成功后会触发 SDK_READY 事件，该事件触发后，可正常使用 SDK 接口
    tim.on(TIM.EVENT.SDK_READY, this.onReadyStateUpdate, this);
    // SDK NOT READT
    tim.on(TIM.EVENT.SDK_NOT_READY, this.onReadyStateUpdate, this);
    // 被踢出
    tim.on(TIM.EVENT.KICKED_OUT, () => {
      console.log("被剔出");
      const { dispatch } = store1;
      // window.close();
      dispatch(routerRedux.push("/user/logOn"));
      // this.$message.error('被踢出，请重新登录。')
      // this.$store.commit('toggleIsLogin', false)
      // this.$store.commit('reset')
    });
    // SDK内部出错
    tim.on(TIM.EVENT.ERROR, this.onError, this);
    // 收到新消息
    tim.on(TIM.EVENT.MESSAGE_RECEIVED, this.onReceiveMessage, this);
    // 会话列表更新
    tim.on(
      TIM.EVENT.CONVERSATION_LIST_UPDATED,
      this.updateConversationList,
      this
    );
    // 群组列表更新
    tim.on(TIM.EVENT.GROUP_LIST_UPDATED, (event) => {
      // this.$store.commit('updateGroupList', event.data)
      // console.log(event.data);
    });
    //如果im成功的时候，在创建会话
  }
  //创建个人会话
  // createPerson(userID) {
  //   tim.getConversationProfile(`C2C${userID}`).then(({ data }) => {
  //     // // 3.1 更新当前会话
  //     this.props.dispatch({
  //       type: `im/updateCurrentConversation`,
  //       payload: data.conversation
  //     });
  //     // // 3.2 获取消息列表
  //     // context.dispatch('getMessageList', conversationID);
  //     // return Promise.resolve();
  //   });
  // }
  //创建私有群聊
  // createGroup() {
  //   let options = {
  //     // groupID:'122',
  //     name: '新建第二个群',
  //     type: TIM.TYPES.GRP_PRIVATE
  //     // memberList:[{userID:'15985856758'},{userID:'19010100002'}]
  //     // ...this.form,
  //     // memberList: this.form.memberList.map(userID => ({ userID }))
  //   };
  //   // if (['Private', 'AVChatRoom'].includes(this.form.type)) {
  //   //   delete options.joinOption
  //   // }
  //   tim.createGroup(options).then(() => {
  //     // this.closeCreateGroupModel()
  //   });
  // }

  //sdk状态的改变,获取当前的用户信息
  onReadyStateUpdate({ name }) {
    const isSDKReady = name === TIM.EVENT.SDK_READY ? true : false;
    this.props.dispatch({
      type: 'im/toggleIsSDKReady',
      payload: isSDKReady
    });
    if (isSDKReady) {
      tim.getConversationList();
      tim.getMyProfile().then(({ data }) => {
        this.props.dispatch({
          type: "im/updateCurrentUserProfile",
          payload: data,
        });
        // this.$store.commit('updateCurrentUserProfile', data)
      });
      // this.$store.dispatch('getBlacklist')
    }
  }
  //更新列表
  updateConversationList(event) {
    this.props.dispatch({
      type: "im/conversationList",
      payload: event.data,
    });
  }
  /**sdk出错 */
  onError(e) {
    console.log(e);
    if (e.data.code === 2501) {
      message.warning("该人员未完成基础信息初始化，无法进行指挥调度");
    }
    this.props.closeClick();
    console.log("sdk出错");
  }
  //接收新消息
  onReceiveMessage({ data: messageList }) {
    this.handleAt(messageList);
    this.pushCurrentMessageList(messageList[0]);
  }
  /**
   * 处理 @ 我的消息
   * @param {Message[]} messageList
   */
  handleAt(messageList) {
    // 筛选有 @ 符号的文本消息
    const atTextMessageList = messageList.filter(
      (message) =>
        message.type === TIM.TYPES.MSG_TEXT &&
        message.payload.text.includes("@")
    );
    for (let i = 0; i < atTextMessageList.length; i++) {
      const message = atTextMessageList[i];
      const matched = message.payload.text.match(/@\w+/g);
      if (!matched) {
        continue;
      }
      // @ 我的
      // if (matched.includes(`@${this.currentUserProfile.userID}`)) {
      //   // 当前页面不可见时，调用window.Notification接口，系统级别通知。
      //   if (document.hidden) {
      //     this.notifyMe(message)
      //   }
      //   Notification({
      //     title: `有人在群${message.conversationID.slice(5)}提到了你`,
      //     message: message.payload.text,
      //     duration: 3000
      //   })
      //   this.$bus.$emit('new-messsage-at-me', {
      //     data: { conversationID: message.conversationID }
      //   })
      // }
    }
  }
  pushCurrentMessageList(messageData) {
    if (!this.props.currentConversation.conversationID) {
      return;
    }
    if (Array.isArray(messageData)) {
      // console.log(message);
      // 筛选出当前会话的消息
      // const result = messageData.filter(
      //   item =>
      //     item.conversationID === this.props.currentConversation.conversationID
      // );
      // this.props.dispatch({
      //   type: 'im/pushCurrentMessageList',
      //   payload: [...this.props.currentMessageList, messageData]
      // });
      // state.currentMessageList = [...state.currentMessageList, ...result]
      // console.log(result);
    } else if (
      messageData.conversationID ===
      this.props.currentConversation.conversationID
    ) {
      this.props.dispatch({
        type: "im/pushCurrentMessageList",
        payload: [...this.props.currentMessageList, messageData],
      });
    }
  }
  render() {
    return (
      <div
        id="tim-demo-wrapper"
        style={{
          position: "absolute",
          background: "#fff",
          top: "54px",
          right: "0",
          height: "calc(100vh - 54px)",
          // maxHeight:'calc(100vh - 54px)',
          // height:'100%',
          overflow: "auto",
          display: this.state.visible ? "flex" : "none",
        }}
      >
        {/* 当前会话内容 */}
        {/* {this.props.currentConversation.conversationID ? (
          <CurrentConversation
            visible={this.state.visible}
            closeClick={() => {
              this.props.closeClick();
            }}
          />
        ) : (
          // <BlankPage
          //   closeClick={() => {
          //     this.props.closeClick();
          //   }}
          // />
          <div></div>
        )} */}
        {/* 侧栏 */}
        <SideBar
          conversationID={this.state.conversationID}
          // closeClick={() => {
          //   this.props.closeClick();
          // }}
        />
      </div>
    );
  }
}
