/**
 * 自定义消息中的语音消息(web发送过去的语音消息)
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import { Pagination, Drawer, Tooltip, Icon, message } from 'antd';
@connect(state => ({}))
export default class CustomSoundElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      payload: props.payload,
      playState: false, //是否播放音频
      index: props.index, //key值
      isValid: true //当前的音频是否有效(默认是有效的)
    };
  }

  componentDidMount() {
    this.checkValid();
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      payload: nextProps.payload,
      index: nextProps.index
    });
  }
  //检查音频是否有效
  checkValid() {
    const that = this;
    let t2 = window.setInterval(function() {
      if (that.refs.videoDom) {
        window.clearInterval(t2);
      }
    }, 50);
  }
  render() {
    return (
      <div>
        <div
          key={this.state.index}
          className="custom-sound-element"
          onClick={() => {
            if (this.state.isValid) {
              //先保证语音可以播放的情况
              //播放音频
              this.setState({
                playState: true
              });
              let messageListNode = this.refs.videoDom;
              //paused方法用来判断语音是否播放.true是还没有播放,false是已经在播放了
              if (messageListNode.paused) {
                // this.props.dispatch({
                //   type: 'im/updateCurrentPlayVideo',
                //   payload: messageListNode
                // });
                const promise = messageListNode.play();
                if (promise) {
                  promise
                    .catch(err => {
                      console.log('播放失败');
                    })
                    .then(res => {
                      console.log(res);
                      console.log('播放成功');
                    });
                }
                const that = this;
                messageListNode.onended = function() {
                  console.log('音频播放结束');
                  that.setState({
                    playState: false
                  });
                };
              } else {
                messageListNode.pause();
                console.log('暂停播放');
                this.setState({
                  playState: false
                });
              }
            } else {
              return;
            }
          }}
        >
          <audio
            controls
            ref="videoDom"
            src={
              this.state.payload.extension.indexOf('time') > -1
                ? JSON.parse(this.state.payload.extension).url
                : this.state.payload.extension
            }
            style={{ display: 'none' }}
            onLoadedMetadata={() => {
              this.setState({ isValid: true });
            }}
            onError={()=>{
              //服务器返回的音频地址是打不开的时候
              this.setState({ isValid: false });
            }}
          ></audio>
          {this.state.isValid
            ? this.state.payload.extension.indexOf('time') > -1
              ? JSON.parse(this.state.payload.extension).time + '"'
              : ''
            : '最近的语音不能同步'}
          <img
            className="sound-img"
            style={{
              transform: 'rotate(180deg)',
              filter: this.state.isValid ? 'unset' : 'invert(1)'
            }}
            src={
              this.state.playState
                ? require('../../../../assets/images/vedio-player.gif')
                : require('../../../../assets/images/vedio-player.png')
            }
          />
          {/* {this.state.isValid ? <div>ddd</div> : ''} */}
        </div>
      </div>
    );
  }
}
