import React, { PureComponent } from "react";
import Person from "./PersonMessage";
import Attendance from "./Attendance";
import Event from "./EventList";
import PersonSearchList from "./Attendance/PersonSearchList";
import "./index.less";
import { connect } from "dva";
import { Tabs, Button } from "antd";

const { TabPane } = Tabs;
@connect((state) => ({
  selectedAttenData: state.command.attendanceList.selectedAttenData,
  tabIndex: state.command.tabIndex,
}))
export default class SearchListTab extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      buttonStatus: true, //true是打开，false是关闭
    };
  }
  render() {
    return (
      <div className="searchListTab">
        {!this.props.selectedAttenData && (
          <div>
            <div
              className="drawer_container_tab"
              style={{ boxShadow: "unset" }}
            >
              <Tabs
                defaultActiveKey={this.props.tabIndex.tabIndex1 || "1"}
                onChange={(index) => {
                  this.props.dispatch({
                    type: "command/setTabIndex",
                    payload: {
                      tabIndex1: index,
                    },
                  });
                  this.props.dispatch({
                    type: "command/clearInfoWindow",
                    payload: true,
                  });
                }}
              >
                <TabPane tab="事件列表" key="1" disabled>
                  <Event visible={this.state.buttonStatus} />
                </TabPane>
                <TabPane tab="人员信息" key="2">
                  <Person
                    visible={this.state.buttonStatus}
                    clickTextScheduling={(item, type, isNeedRecord) => {
                      this.props.clickTextScheduling(item, type, isNeedRecord);
                    }}
                    changeImStatus={(value) => {
                      this.props.changeImStatus(value);
                    }}
                    groupVideo={(list) => {
                      this.props.groupVideo(list);
                    }}
                  />
                </TabPane>
                <TabPane tab="驻勤信息" key="3">
                  <Attendance visible={this.state.buttonStatus} />
                </TabPane>
              </Tabs>
            </div>
            <div className="drawer_container_tab openButton">
              <Button
                onClick={() => {
                  this.setState({
                    buttonStatus: !this.state.buttonStatus,
                  });
                }}
              >
                <img
                  src={
                    this.state.buttonStatus
                      ? require("../../../../assets/images/prevention/open.png")
                      : require("../../../../assets/images/prevention/packup.png")
                  }
                ></img>
              </Button>
            </div>
          </div>
        )}

        <div className="drawer_container_tab">
          {this.props.selectedAttenData && (
            <PersonSearchList
              clickTextScheduling={(item, type, recordMobile) => {
                this.props.clickTextScheduling(item, type, recordMobile);
              }}
            />
          )}
        </div>
      </div>
    );
  }
}
