/**
 *所有驻勤点
 */
import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from "dva/router";
import { Pagination, message, Icon, Input, Button, Tooltip } from "antd";
import { data } from "./TypeData";
import { getComTaskList } from "../../../../../services/api";
import AttendanceItem from "./AttendanceItem";
@connect((state) => ({
  selectedId: state.command.attendanceList.selectedId,
  tabIndex2: state.command.tabIndex.attendance.tabIndex2,
}))
@withRouter
export default class AllAttendance extends Component {
  constructor(props) {
    super(props);
    console.log(props);
    this.state = {
      tabKey: "1", //tab
      currentKey: null, //主要用于处理tab页面改变，不让重新请求数据
      data: data,
      searchData: {
        //搜索数据
        pageNumber: 1,
        pageSize: 9,
        taskName: null,
      },
      selectedIndex: null, //选中哪个列表
      selectedAttenData: null, //选中的驻勤点的信息
      total: 0, //搜索总页数
      attendanceList: [], //搜索出的驻勤点的数据
      height: null, //搜索列表的最大高度
      loadingText: "暂无数据",
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.getAttendanceList(1); //默认页面中是空搜索
  }
  componentWillReceiveProps(nextProps) {
    if (
      nextProps.tabIndex2 == this.state.tabKey &&
      nextProps.tabIndex2 !== this.state.currentKey
    ) {
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
      this.getAttendanceList(this.state.searchData.pageNumber);
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  //获取搜索值
  getAttendanceList(pageNumber) {
    // this.props.attenPersonList([]);
    //先重置分页数据
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber,
        },
        selectedIndex: null, //清空驻勤的点击哪个列表的信息
        selectedAttenData: null,
        loadingText: "正在加载中...",
      },
      () => {
        getComTaskList({
          ...this.state.searchData,
        }).then((res) => {
          if (res.retType === "0") {
            const data = this.state.data;
            const attendanceList = res.data.data;
            for (let i = 0; i < attendanceList.length; i++) {
              for (let j = 0; j < data.length; j++) {
                if (attendanceList[i].taskStationType == data[j].key) {
                  attendanceList[i].markerIcon = data[j].markerIcon;
                  attendanceList[i].clickMarkerIcon = data[j].clickMarkerIcon;
                }
              }
              if (!attendanceList[i].markerIcon) {
                attendanceList[i].markerIcon = data[data.length - 1].markerIcon;
                attendanceList[i].clickMarkerIcon =
                  data[data.length - 1].clickMarkerIcon;
              }
            }
            this.setState({
              attendanceList,
              total: res.data.total,
              loadingText: res.data.data.length > 0 ? "加载完成" : "暂无数据",
            });
            this.props.dispatch({
              type: "command/fetchAllAttendanceList",
              payload: {
                attendanceList,
              },
            });
          }
        });
      }
    );
  }
  render() {
    return (
      <div className="data-list">
        <div className="input">
          <Input
            placeholder="请输入驻勤点:"
            style={{ width: 270 }}
            onChange={(e) => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  taskName: e.target.value.trim(),
                },
              });
            }}
            onPressEnter={() => {
              //按下回车获取列表值
              this.getAttendanceList(1);
            }}
          />
          <Button
            type="primary"
            onClick={() => {
              //获取搜索值
              this.getAttendanceList(1);
            }}
          >
            <Icon type="search" style={{ fontSize: "16px" }} />
          </Button>
        </div>
        <div
          className="security search-list_command amap_lib_placeSearch"
        >
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <AttendanceItem
              data={this.state.attendanceList}
              loadingText={this.state.loadingText}
            />
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getAttendanceList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{ display: this.state.total > 1 ? "block" : "none" }}
          />
        </div>
      </div>
    );
  }
}
