/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { Pagination, message, Icon, Input, Button } from "antd";
import "./person.less";
// import { getComPerLocationByKeyword } from "../../../../services/api";
import ThreeDimenVideo from "../../mapModule/threeDimenVideo";
export default class PersonSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      layerSatatus: props.layerSatatus,
      searchData: {
        pageNumber: 1,
        pageSize: 7,
        keyWord: null,
      },
      personList: [], //人员列表数据
      personClickIndex: props.personClickIndex || null, //选中的是哪个人员
      height: null, //最大高度
      beijing: false, //北京搜索框的展示状态
      beijingVideo: false, //北京视频的展示状态
      gaoqi: false, //高崎搜索框的展示状态
      treeDimenStatus: false, //三维模型的展示状态
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      layerSatatus: nextProps.layerSatatus,
      personClickIndex: nextProps.personClickIndex,
    });
  }
  getPersonList(pageNumber) {
    if (this.state.searchData.keyWord === "北京展览馆") {
      this.setState({
        beijing: true,
        personList: [],
        gaoqi: false,
      });
      this.props.markesBeiJing();
      // this.props.personList([]);
    } else if (
      this.state.searchData.keyWord === "厦门机场" ||
      this.state.searchData.keyWord === "厦门高崎机场"
    ) {
      this.setState({ gaoqi: true, personList: [], beijing: false });
      this.props.markesGaoQi();
      // this.props.personList([]);
    }
  }
  render() {
    return (
      <div
        style={{
          display: this.state.layerSatatus === "person" ? "block" : "none",
        }}
      >
        <div className="security drawer_container_person">
          <div>
            <Input
              placeholder="请输入地点:"
              style={{ width: 210 }}
              onChange={(e) => {
                this.setState({
                  searchData: {
                    ...this.state.searchData,
                    keyWord: e.target.value.trim(),
                  },
                });
              }}
              onPressEnter={() => {
                //按下回车的事件
                this.getPersonList(1);
              }}
            />
            <Button
              type="primary"
              onClick={() => {
                this.getPersonList(1);
              }}
            >
              <Icon type="search" style={{ fontSize: "16px" }} />
            </Button>
          </div>
          {/* 北京展览馆 */}
          <div
            className="beijing"
            style={{ display: this.state.beijing ? "block" : "none" }}
          >
            <div>
              <div className="text">
                <div style={{ color: "#0f71ff" }}>北京展览馆</div>
                <div>展览馆</div>
                <div>北京市西城区西直门外大街135号</div>
              </div>
              <img
                src={require("../../../../assets/images/prevention/beijing-2.jpg")}
              ></img>
            </div>
            <div style={{ marginTop: "20px" }}>
              <h3>活动列表</h3>
              <img
                style={{ float: "left" }}
                src={require("../../../../assets/images/prevention/beijing.jpg")}
              ></img>
              <div
                className="text"
                style={{ width: "70%", marginLeft: "10px" }}
              >
                <div>
                  伟大历程 辉煌成就——庆祝中华人民共和国成立70周年大型成就展
                </div>
                <div>展会时间：2019年9月23日-2019年12月31日</div>
              </div>
              <div>
                <Button
                  style={{ padding: "5px", marginRight: "5px" }}
                  type="primary"
                  onClick={() => {
                    //弹出视频
                    // this.setState({ huodongVideo: true });
                    window.open(
                      "https://114.115.173.143:8080/distinction-bcx/graph.html#/ticket/index",
                      "_blank"
                    );
                  }}
                >
                  活动票证分析
                </Button>
                <Button
                  style={{ padding: "5px" }}
                  type="primary"
                  onClick={() => {
                    //弹出视频
                    this.setState({ beijingVideo: true });
                    this.props.beijingVideo(true);
                  }}
                >
                  3D风险评估报告
                </Button>
                <Button
                  style={{ padding: "5px", margin: "5px 5px 0 0" }}
                  type="primary"
                  onClick={() => {
                    //弹出视频
                    // this.setState({ huodongVideo: true });
                    window.open(
                      "http://114.116.164.42:8014/bim/view?fileId=1896948461340768",
                      "_blank"
                    );
                    // this.setState({ treeDimenStatus: true });
                  }}
                >
                  三维模型
                </Button>
              </div>
            </div>
          </div>
          {/* 高崎机场 */}
          <div
            className="beijing"
            style={{ display: this.state.gaoqi ? "block" : "none" }}
          >
            <div>
              <div className="text">
                <div style={{ color: "#0f71ff" }}>厦门高崎国际机场</div>
                <div>厦门市湖里区翔云一路</div>
                <div>电话：0592-5706078</div>
              </div>
              <img
                src={require("../../../../assets/images/prevention/jichang.jpg")}
                style={{ marginLeft: "30px" }}
              ></img>
            </div>
            <div style={{ textAlign: "center", marginTop: "10px" }}>
              <Button
                type="primary"
                onClick={() => {
                  // this.setState({ caijiVideo: true });
                  window.open(
                    "https://114.115.173.143:8080/distinction-bcx/#/wifi/index",
                    "_blank"
                  );
                }}
                style={{ marginRight: "4px" }}
              >
                机场人流轨迹分析
              </Button>
            </div>
          </div>
        </div>

        <div
          className="security search-list amap_lib_placeSearch"
          style={{
            display: this.state.personList.length > 0 ? "block" : "none",
          }}
        >
          <div className="security-personnel">
            <span>保安人员</span>
          </div>
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            {this.state.personList.map((item, index) => {
              const xing = "********";
              let idCardNo = "";
              if (item.idCardNo) {
                let front6 = item.idCardNo.substring(0, 6);
                idCardNo =
                  front6 +
                  xing +
                  item.idCardNo.substring(14, item.idCardNo.length);
              }
              return (
                <div
                  key={index}
                  className="item"
                  onClick={() => {
                    if (item.lnglat) {
                      this.props.onClickPerson(item, index);
                      this.setState({
                        personClickIndex: index,
                      });
                    } else {
                      message.warning("该人员暂未定位");
                    }
                  }}
                >
                  <div
                    className={
                      this.state.personClickIndex === index
                        ? "selected poibox"
                        : "poibox"
                    }
                  >
                    {item.lnglat && (
                      <div className="amap_lib_placeSearch_poi poibox-icon">
                        {index}
                      </div>
                    )}
                    <div style={{ marginLeft: 25 }}>
                      <div className="name">{item.name}</div>
                      <div className="text">手机号码:{item.mobilePhone}</div>
                      <div className="text">证件号码:{idCardNo}</div>
                    </div>
                  </div>
                </div>
              );
            })}
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getPersonList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{
              display:
                this.state.total > this.state.searchData.pageSize
                  ? "block"
                  : "none",
            }}
          />
        </div>
        {/* 三维模型视图 */}
        {this.state.treeDimenStatus && (
          <ThreeDimenVideo
            changeStatus={(value) => {
              this.setState({
                treeDimenStatus: value,
              });
            }}
          />
        )}
      </div>
    );
  }
}
