import React from "react";
import { Button, Steps, Breadcrumb, } from "antd";
import { Link } from "dva/router";
import Result from "../../components/Result";
import "./ThiftManagement.less";

const { Step } = Steps;

export default props => {
  const actions = (
    <div>
      <Button
        onClick={() => {
          props.history.push("/attendancemanagement/newattendanceunit");
        }}
        type="primary"
      >
        返回内勤组管理
      </Button>
    </div>
  );
  return (
    <div className="TaskDetail TaskDetailPersonnelPlacement ThiftManagement">
      <div className="card-breadcrumb" style={{ marginLeft: '0px' }}>
        <Breadcrumb>
          <Breadcrumb.Item><Link to="/attendancemanagement/newattendanceunit">内勤组管理</Link></Breadcrumb.Item>
          <Breadcrumb.Item>排班设置</Breadcrumb.Item>
        </Breadcrumb>
      </div>
      <div className="card">排班设置</div>
      <div className="Steps">
        <Steps current={3}>
          <Step title="设置考勤人员" />
          <Step title="考勤地点" />
          <Step title="选择考勤类型" />
          <Step title="完成" />
        </Steps>
      </div>
      <Result
        type="success"
        title="考勤设置已完成"
        description="考勤设置已完成，如需更改请返回内勤组管理页面进行修改！"
        extra={null}
        actions={actions}
        style={{ marginTop: 48, marginBottom: 16 }}
      />
    </div>
  );
};
