/* 新增内勤组 */
import React, { Component } from "react";
import { connect } from "dva";
import moment from "moment";

import {
  Form,
  Input,
  Timeline,
  Row,
  Button,
  Checkbox,
  InputNumber,
  TimePicker
} from "antd";
import Drawer from "react-motion-drawer";
import "./ThiftManagement.less";

const FormItem = Form.Item;
const format = "HH:mm";

const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 10 }
  }
};

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class NewAttendanceUnit extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.open //新增班次
    };
  }

  componentWillReceiveProps(nextprops) {
    if (this.state.open !== nextprops.open) {
      this.setState({ open: nextprops.open });
    }
  }

  componentDidMount() {
    // window.initialize = this.initializeMap;
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Drawer
        overlayColor="rgba(0, 0, 0,0)"
        right
        open={this.state.open}
        noTouchClose
        width={600}
        className="drawer-box"
        zIndex={2}
        onChange={open => {
          this.setState({ open });
        }}
      >
        <div className="drawer task-drawer">
          <div className="drawer-header">新增班次</div>
          <div className="drawer-content">
            <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
              <FormItem {...formItemLayout} label="班次名称">
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(<Input />)}
              </FormItem>
              <FormItem {...formItemLayout} label="一天上下班冷饮数">
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(<Input addonAfter="次" />)}
              </FormItem>
              <FormItem
                {...formItemLayout}
                label="第一轮班次"
                style={{ marginBottom: 0 }}
              >
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(
                  <Timeline>
                    <Timeline.Item color="green">
                      上班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                    </Timeline.Item>
                    <Timeline.Item color="orange">
                      下班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                    </Timeline.Item>
                  </Timeline>
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                style={{ marginBottom: 0 }}
                label="第二轮班次"
              >
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(
                  <Timeline>
                    <Timeline.Item color="green">
                      上班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                    </Timeline.Item>
                    <Timeline.Item color="orange">
                      下班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                    </Timeline.Item>
                  </Timeline>
                )}
              </FormItem>
              <FormItem
                {...formItemLayout}
                style={{ marginBottom: 0 }}
                label="第三轮班次"
                help={
                  <div className="help">
                    合计工作时长<span>21</span>小时<span>00</span>
                  </div>
                }
              >
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(
                  <Timeline style={{ marginBottom: 0 }}>
                    <Timeline.Item color="green">
                      上班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                    </Timeline.Item>
                    <Timeline.Item color="orange">
                      下班：<TimePicker
                        className="task-TimePicker"
                        defaultValue={moment("12:08", format)}
                        format={format}
                      />
                      <span
                        style={{
                          position: "absolute",
                          right: 0,
                          top: 4,
                          marginRight: -40,
                          color: "#F5222E"
                        }}
                      >
                        次日
                      </span>
                    </Timeline.Item>
                  </Timeline>
                )}
              </FormItem>
              <div
                style={{ borderBottom: "1px solid#E9E9E9", margin: "24px" }}
              />
              <FormItem
                {...{
                  labelCol: {
                    xs: { span: 24 },
                    sm: { span: 7 }
                  },
                  wrapperCol: {
                    xs: { span: 24 },
                    sm: { span: 12 },
                    md: { span: 16 }
                  }
                }}
                label="附加设置"
              >
                {getFieldDecorator("address", {
                  rules: [{ required: true, message: "请输入" }]
                })(
                  <Checkbox.Group
                    onChange={e => {
                      console.log(e);
                    }}
                  >
                    <Row style={{ marginBottom: 24 }}>
                      {" "}
                      <Checkbox value="A">允许迟到</Checkbox>
                      <InputNumber
                        style={{ width: 88 }}
                        min={1}
                        max={10}
                        defaultValue={3}
                      />分钟
                    </Row>
                    <Row style={{ marginBottom: 24 }}>
                      {" "}
                      <Checkbox value="A">迟到超过</Checkbox>
                      <InputNumber
                        style={{ width: 88 }}
                        min={1}
                        max={10}
                        defaultValue={3}
                      />分钟{" "}
                      <span style={{ color: "#FFAA00" }}>(视为严重迟到)</span>
                    </Row>
                    <Row style={{ marginBottom: 24 }}>
                      {" "}
                      <Checkbox value="A">迟到超过</Checkbox>
                      <InputNumber
                        style={{ width: 88 }}
                        min={1}
                        max={10}
                        defaultValue={3}
                      />分钟<span style={{ color: "#F5222E" }}>(视为旷工)</span>
                    </Row>
                  </Checkbox.Group>
                )}
              </FormItem>
            </Form>
          </div>
          <div className="drawer-footer">
            <Button
              onClick={() => {
                this.setState({ open: false });
                this.props.cancel(false);
              }}
            >
              取消
            </Button>
            <Button
              onClick={() => {
                this.setState({ open: true });
                this.setState(true);
              }}
              type="primary"
            >
              修改班次
            </Button>
          </div>
        </div>
      </Drawer>
    );
  }
}
