import React, {Component} from 'react';

import {Input, Button,Modal} from 'antd';
import * as api from "../../../services/api";
import "./less/labor.less";
import PTable from "../../../components/Pro/PTable";
import PSelect from "../../../components/Pro/PSelect";
const { confirm } = Modal;


export default class LaborBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      number: 0,
      forceUpdate: false,
      pageParm: {
        reportType: "",
        reportName: "",
        pageSize: "10",
        pageNumber: "1"
      },
      reportName: "",
      reportType: "",
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
  };


  /******************************ajax请求******************************/


  /******************************相关事件******************************/
    //报表类型-选择
  handleChange = (value) => {
    console.log(`selected ${value}`);
  };

  //输入框的书写
  inputTracknameChange = (e) => {
    this.setState({reportName: e.target.value.trim()});
  };

  //点击搜索
  search = () => {
    const pageParm = {...this.state.pageParm};
    const {reportName,reportType} = this.state;
    pageParm.reportName = reportName;
    pageParm.reportType = reportType;
    this.setState({pageParm, forceUpdate: true}, () => {
      this.setState({forceUpdate: false});
    });
  };

  //重置
  resetQueryCond =() =>{
    this.setState({
      pageParm: {
        reportType: "",
        reportName: "",
        pageSize: "10",
        pageNumber: "1"
      },
      reportType: "",
      reportName: "",
    },
    () => {
      this.search();
    });
  }

  showDeleteConfirm = (id,reportName) => {
    const that = this;
    confirm({
      title: '删除的报表不可恢复',
      content: '确认删除“' + reportName + '”？',
      okText: '确认',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
         // 报表删除
        api.enterpriseSalaryComReportDeleteCompanyReport({id}).then((data) => {
          // console.log(data);
          that.search();
        }, (err) => {
          console.log(err);
        });
      },
      onCancel() {
        console.log('Cancel');
      },
    });
  };
  //table 数据变化
  dateTableChange = (data) => {
    this.setState({number: data.total});
  };

  //报表类型 change
  pSelectChange = (value, type) => {
    this.setState({[type]: value});
  };


  /******************************render******************************/
  renderTable = () => {
    const columns = [
      {
        title: '表头',
        key: 'reportName',
        render: (text, record) => (
          <div>
            <p>{record.reportName}</p>
            <span>{record.remark}</span>
          </div>
        ),
        minwidth: 380,
      },
      {
        title: '表的类别',
        dataIndex: 'reportType',
        key: 'reportType',
        render: (text, record) => (
          <div>
            {record.reportType === "1" ? "普通报表" : "月度报表"}
          </div>
        ),
      },
      {
        title: '时间',
        key: '2',
        render: (text, record) => (
          <div>
            <p>修改时间：<span>{record.updateTime}</span></p>
          </div>
        ),
      },
      {
        title: "操作",
        key: '3',
        render: (text, record) => (
          <div>
            <span style={{color: "#108EE9", cursor: "pointer", marginRight: "20px"}}
                  onClick={() => {
                    this.props.history.push(`/adminis/reportUpdate/${record.payReportId + ""}/${record.reportType}`);
                  }}>编辑</span>
            <span style={{color: "#108EE9", cursor: "pointer"}}
                  onClick={this.showDeleteConfirm.bind(this, record.payReportId, record.reportName)}>删除</span>
          </div>
        )
      },
    ];
    return (
      <PTable
        columns={columns}
        showHeader={false}
        url="enterpriseSalaryComReportCompanyReportList"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
      />
    );
  };

  render() {

    return (
      <div className="labor">
        <p>共检索到<span>{this.state.number}</span>条数据</p>
        <div className="labor-chearch">
          <label>报表类型：
            <PSelect type="reportType" onChange={this.pSelectChange} value={this.state.reportType} addOption/>
          </label>
          <Input style={{width: 214, marginLeft: '16px'}}
                 placeholder="搜索报表名称"
                 onChange={this.inputTracknameChange}
                 value={this.state.reportName}
                 maxLength={25}
          />
          <Button style={{marginLeft: 16}} type="primary" onClick={this.search}>搜索</Button>
          <Button style={{marginLeft:16}} onClick={this.resetQueryCond}>重置</Button>
        </div>
        <div className="new-report">
          <Button type="primary"
                  onClick={() => {
                    this.props.history.push("/adminis/newlabor");
                  }}>新建报表</Button>
        </div>
        {this.renderTable()}
      </div>
    );
  }
}

