import React, { PureComponent } from "react";

import style from "styled-components";
import LaborContract from "./LaborContract";
import NotSigned from "./NotSigned";
import NotAssociated from "./NotAssociated";
import { Tabs } from "antd";

const { TabPane } = Tabs;
export default class LaborIndex extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      keyTab: this.props.location.state
        ? this.props.location.state.keyTab
        : "1",
    };
  }

  render() {
    return (
      <Container>
        <Tabs defaultActiveKey={this.state.keyTab||'1'}>
          <TabPane tab="全部" key="1">
            <LaborContract />
          </TabPane>
          <TabPane tab="未签订人员" key="2">
            <NotSigned />
          </TabPane>
          <TabPane tab="未关联合同" key="3">
            <NotAssociated />
          </TabPane>
        </Tabs>
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
`;
