import React, { Component } from 'react';
import { connect } from 'dva';
import { notification } from 'antd';
import {
  Input,
  Button,
  Form,
  Select,
  DatePicker,
  InputNumber,
  Radio,
  Upload,
  Icon,
  message,
  Drawer,
  Table,
  Popconfirm,
  Tooltip,
  Checkbox
} from 'antd';
import moment from 'moment';
import $perModal from '../../../utils/modal/perModal';
import { getDateInterval } from '../../../utils/utils';
import * as api from '../../../services/api';
import './less/contract.less';
import PSelect from '../../../components/Pro/PSelect';

const FormItem = Form.Item;
const Option = Select.Option;
const RadioGroup = Radio.Group;
const { TextArea } = Input;
const dateFormat = 'YYYY-MM-DD';
const { RangePicker } = DatePicker;

@connect(state => ({ profile: state.profile }))
@Form.create()
export default class ContractDrawer extends Component {
  taskStationList=0
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visiable, //编辑查看
      editable: this.props.editable, //抽屉的输入框是否可编辑
      editOrGo: this.props.editOrGo, //抽屉的输入框是否可编辑
      wenUrl: '', //查看状态下的预览文件地址
      wenUrlMore: '', //第一次进来的预览文件地址
      comContractId: 0,
      contractType: '01',
      distributionModeList: [], //发放/结算方式
      currentRow: {
        contractType: '', //合同类型
        contractName: '', //合同名称
        comFileNo: '', //企业档案编号
        comParty: '', //企业所在方
        firstPartyName: '', //甲方名称
        firstPartyTel: '', //甲方联系电话
        secondPartyName: '', //乙方名称
        secondPartyTel: '', //乙方联系电话
        effectStartDate: '', //生效开始日期
        effectEndDate: '', //生效终止日期
        payAmount: '', //付费金额
        payDate: '', //付费日期
        secondPartyIdCardNo: '', //乙方身份证号码
        workPost: '', //工作岗位
        content: '', //工作/劳务内容
        postSalary: '', //岗位薪资
        periodSalary: '', //试用期工资
        period: 0, //试用期
        distributionMode: '', //发放/结算方式
        workPlace: '', //工作/劳务地点'
        serviceAmount: '', //劳务费用
        serviceTotalAmount: '', //劳务总金额
        agreementSignDate: null, //协议签订日期
        contractUrl: '', //合同文件url
        remark: '', //备注
        timeLimit: '', //合同期限
      },
      taskStationList:[],
      fileListWed: [
        {
          uid: 1,
          name: '附件',
          status: 'done',
          url: 'http://www.baidu.com/yyy.png'
        }
      ],
      radioYiTypeValue: '01', //乙方类型按钮值，默认是"从组织架构选择"
      changeRadioValue: '', //按钮是甲方还是乙方,默认是甲方
      perId: '',  //人员id
      Indefinite:'',//合同是否有期限
    };
    //文件上传
    const that = this;
    that.modelUpload = {
      name: 'xfile',
      action: api.uploadUrl,
      headers: {
        authorization: 'authorization-text'
      },
      beforeUpload(info) {
        //上传过程中，先判断是否符合上传规则
        // const types = [
        //   'application/pdf',
        //   'application/msword',
        //   'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        //   'application/x-zip-compressed',
        //   'application/x-rar',
        //   ''
        // ];
        const isLt8M = info.size / 1024 / 1024 < 100;
        if(!(info.name + '').toLocaleLowerCase().match(/(\.doc)|(\.docx)|(\.pdf)/)) {
          message.error('请上传拓展名为.doc\.docx\.pdf文件!');
          return false;
        }
        // if (types.indexOf(info.type) === -1) {
        //   message.error('只能上传.doc\.docx\.pdf\.zip\.rar类型的文件!');
        //   return false;
        // } else 
        if (!isLt8M) {
          message.error('文件必须小于100MB!');
          return false;
        }
      },
      onChange: info => {
        const { setFieldsValue } = that.props.form;
        // if (info.file.size / 1024 / 1024 >= 8) {
        //   message.error('文件必须小于8MB!');
        //   return false;
        // }
        let fileList = info.fileList;
        fileList = fileList.slice(-1);
        if (info.file.status) {
          this.setState({ fileListWed: fileList });
        }
        if (info.file.status === 'removed') {
          that.setState({
            fileNumber: 0
          });
        }
        if (info.file.status !== 'uploading') {
        }
        if (info.file.status === 'done') {
          if (info.file.response.retType === '0') {
            //上传成功，并且后台校验失败
            message.success(`${info.file.name} 文件上传成功`);
            that.setState({ contractUrl: fileList[0].response.data });
            setFieldsValue({ contractUrl: fileList[0].response.data });
            that.setState({
              fileNumber: 1
            });
            this.renderCheckOthers(fileList[0].response.data);
          } else {
            this.state.fileListWed[0].status = 'error';
            setFieldsValue({ contractUrl: '' });
            message.error(`${info.file.response.msg}`);
          }
        } else if (info.file.status === 'error') {
          // setFieldsValue({ contractUrl: "" });
          message.error(`${info.file.name} 文件上传失败.`);
        }
      }
    };
  }
  /**iverry */
  checkContract = (url, wenUrl) => {
    if(url) {
      window.open(wenUrl);
    }else {
      notification.warning({
        message: '该合同未上传附件！',
        description: '请先上传合同文件，方可查看。'
      });
    }
  }
  /**iverry end */
  componentWillReceiveProps(nextProps) {
    this.setState({ open: nextProps.visiable });
    this.setState({ editable: nextProps.editable });
    this.setState({ editOrGo: nextProps.editOrGo });
    this.setState({ contractType: nextProps.typesd });

    // if (nextProps.comContractId !== this.state.comContractId) {
    if (
      nextProps.comContractId === 0 ||
      nextProps.comContractId === undefined
    ) {
      return;
    }
    this.setState({
      comContractId: nextProps.comContractId
    });
    if (nextProps.comContractId !== this.state.comContractId) {
      this.props.openUpdate();
    }
    if (nextProps.update && nextProps.visiable) {
      this.renderDate(nextProps.comContractId);
      this.props.closeUpdate();
      this.setState({Indefinite:false})
    }
    // }
  }
  //初始化编辑合同列表数据
  renderDate = pro => {
    api.enterpriseComContractGetComContractById({ comContractId: pro }).then(
      data => {
        let contractExtraName = data.data.contractUrl.split('/');
        contractExtraName = contractExtraName[contractExtraName.length - 1];
        const currentRow = {
          ...data.data,
          period: Number(data.data.period) >= 0 ? data.data.period : '',
          agreementSignDate: data.data.agreementSignDate || null,
          taskStationList:data.data.taskStationList|| [],
          taskStationArr:data.data.taskStationList|| [],
        };
        Object.keys(currentRow).forEach(key => {
          if(!currentRow[key]) {
            currentRow[key] = '';
          }
        });
        this.setState(
          {
            currentRow,
            perId: data.data.perId || '',
            contractType: data.data.contractType || '',
            changeRadioValue: data.data.comParty || '',
            fileListWed: [
              {
                ...this.state.fileListWed[0],
                name: contractExtraName || '附件'
              }
            ]
          },
          () => {
            this.renderCheckOthers(this.state.currentRow.contractUrl);
            // this.renderCheckOthersMore(this.state.currentRow.contractUrl);
          }
        );
        //如果是固定的日期，需让复选框选上
        if(data.data.effectEndDate.indexOf('9999-12-31')>-1){
          this.setState({Indefinite:true})
        }
      },
      err => {
        console.log(err);
      }
    );
  };

  //生命周期
  componentDidMount = () => {
    this.setState({
      fileListWed: [
        {
          uid: 1,
          name: '附件',
          status: 'done',
          url: this.props.fileUrl
        }
      ]
    });
    this.DistributionModeList();
  };
  DistributionModeList = () => {
    api
      .publicCommonDictGetDictByCodeTypes({ codeTypes: 'distributionMode' })
      .then(data => {
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            distributionModeList: data.data.distributionMode
          });
        }
      });
  };
  $add() {
    const newData = this.state.currentRow.taskStationList.map(item => ({ ...item }));
    newData.push({
      // [idName]: `NEW_TEMP_ID_${this[param]}`,
      comContractStationId: `NEW_TEMP_ID_${this.taskStationList}`,
      stationName: '',
      stationAddress: '',
    });
    this.taskStationList += 1;
    this.setState({ 
      currentRow:{
        ...this.state.currentRow,
        taskStationList: newData
      }
    });
  }
   //删除
   $remove(id) {
    const newData = this.state.currentRow.taskStationList.filter(item => item.comContractStationId !== id);
    this.setState({ 
      currentRow:{
        ...this.state.currentRow,
        taskStationList: newData
      }
    });
  }
  $handleFieldChange(id,value, name) {
    const newData = this.state.currentRow.taskStationList.map(item => ({ ...item }));
    const target = this.$getRowByKey(id,newData);
    if (target) {
      target[name] = value;
      this.setState({ 
        currentRow:{
          ...this.state.currentRow,
          taskStationList: newData
        }
      });
    }
  }
  $getRowByKey( id,newData) {
    return (newData||this.state.currentRow.taskStationList).filter(
      item => item.comContractStationId === id
    )[0];
  }
  handleEditContractSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        if (
          values.agreementSignDate &&
          values.agreementSignDate !== undefined &&
          values.agreementSignDate !== null
        ) {
          values.agreementSignDate = values['agreementSignDate'].format(
            'YYYY-MM-DD'
          );
        } else {
          values.agreementSignDate = '';
        }
        // if (
        //   values.effectDate &&
        //   values.effectDate !== undefined &&
        //   values.effectDate !== null
        // ) {
        //   values.effectStartDate = values['effectDate'][0].format('YYYY-MM-DD');
        //   values.effectEndDate = values['effectDate'][1].format('YYYY-MM-DD');
        //   delete values.effectDate;
        // } else {
        //   values.effectStartDate = '';
        //   values.effectEndDate = '';
        //   delete values.effectDate;
        // }
        if(new Date(values['effectStartDate'].format(dateFormat))>new Date(values['effectEndDate'].format(dateFormat))){
          return message.warning("结束时间要晚于开始时间")
        }
          values.effectStartDate = values['effectStartDate'].format(dateFormat);
          values.effectEndDate = values['effectEndDate'].format(dateFormat);
        if (
          values.payDateSd &&
          values.payDateSd !== undefined &&
          values.payDateSd !== null
        ) {
          values.payDate = values['payDateSd'].format('YYYY-MM-DD');
        } else {
          values.payDate = '';
        }
        //1、修改文件给出contractUrl: "http://183.250.166.207:8762/public/common/file/get-resource?path=2018-10-12/153933462618250645.jpg"  string
        //2、不修改文件给出的contractUrl:[{}]
        // if (values.contractUrl.fileList) {
        //   values.contractUrl = values.contractUrl.fileList[0].response.data;
        // } else {
        //   values.contractUrl = this.props.fileUrl;
        // }
        if (typeof values.contractUrl === 'object') {
          values.contractUrl = this.props.fileUrl;
        }
        if (this.state.currentRow.contractType=='01'){
          if(this.state.currentRow.taskStationList.length > 0){
            //如果信息不完善
            const data = this.state.currentRow.taskStationList;
            for (let i = 0; i < data.length; i++) {
              if (
                !data[i].stationName ||
                !data[i].stationAddress 
              ) {
                message.error('请填写完整驻勤点信息');
                return;
              }else{
                const list = JSON.parse(JSON.stringify(this.state.currentRow.taskStationList))
                const taskStationValue=[]
                list.map(item=>{
                  taskStationValue.push({
                    stationName:item.stationName,
                    stationAddress:item.stationAddress
                  })
                })
                values.taskStationArrs=JSON.stringify(taskStationValue)
              }
            }
          }else{
            return message.error("请填写驻勤点信息")
          }
        } 
        // 选择的人员id
        values.perId = this.state.perId;
        //编辑与续签用不同的接口调用
        if(this.state.editOrGo){//是编辑
          values.comContractId = this.state.comContractId;
          api.enterpriseComContractUpdateComContract({ ...values }).then(
            () => {
              // message.success('保存成功！');
              this.props.changeTable();
              this.props.openUpdate();
              this.setState({
                open: false,
                radioYiTypeValue: '01' //每次关闭都让乙方类型这个字段置为01
              });
            },
            err1 => {
              console.log(err1);
            }
          );
        }else{//是续签
          api.enterpriseComContractInsertComContract({ ...values }, true).then(
            () => {
              notification.success({
                message: '续签成功'
              });
              this.props.changeTable();
              this.props.openUpdate();
              this.setState({
                open: false,
                radioYiTypeValue: '01' //每次关闭都让乙方类型这个字段置为01
              });
            },
            err1 => {
              notification.error({
                message: err1.msg
              });
            }
          );
        }
        
      }
    });
  };

  //合同有效期-合同期限
  validDeadlineChange = (date, dateString) => {
    const currentRow = Object.assign({}, this.state.currentRow);
    currentRow.timeLimit = getDateInterval(date);
    this.setState({ currentRow }, () => {
    });
  };

  //报表类型 change
  pSelectChange = (value, type) => {
    this.setState({ [type]: value });
  };
  changeEditable = () => {
    this.setState({ editable: false });
  };
  //发放/结算方式
  renderDistributionModeList = () => {
    return this.state.distributionModeList.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  //校验金额
  checkJinE = (rule, value, callback) => {
    if (value === ' ') {
      callback('输入不能为空！');
    } else if (value && !/^([1-9][0-9]*|0)(\.[0-9]{1,2})?$/.test(value)) {
      callback('输入不正确！');
    } else {
      callback();
    }
  };

  renderCheckOthers = sValue => {
    api
      .publicCommonFileFilePreview({
        url: sValue,
        isLoad: '1'
      })
      .then(data => {
        if (data.data) {
          this.setState({
            wenUrl: data.data,
            wenUrlMore: data.data
          });
        }
      });
  };

  //甲方乙方按钮切换
  onChangeRadio = e => {
    const val = e.target.value;
    const { setFieldsValue, getFieldsValue } = this.props.form;
    let { 
      firstPartyName, firstPartyIdCardNo, firstPartyTel, firstPartyAddress,
      secondPartyName, secondPartyIdCardNo, secondPartyTel, secondPartyAddress,
      thirdPartyName, thirdPartyIdCardNo, thirdPartyTel, thirdPartyAddress
    } = getFieldsValue();
    let { changeRadioValue } = this.state;

    if((val == '1' && changeRadioValue == '2') || (val == '2' && changeRadioValue == '1')) {
      setFieldsValue({
        firstPartyName: secondPartyName,
        firstPartyIdCardNo: secondPartyIdCardNo, 
        firstPartyTel: secondPartyTel, 
        firstPartyAddress: secondPartyAddress,
        secondPartyName: firstPartyName,
        secondPartyIdCardNo: firstPartyIdCardNo, 
        secondPartyTel: firstPartyTel, 
        secondPartyAddress: firstPartyAddress
      });
    }

    if((val == '1' && changeRadioValue == '3') || (val == '3' && changeRadioValue == '1')) {
      setFieldsValue({
        firstPartyName: thirdPartyName,
        firstPartyIdCardNo: thirdPartyIdCardNo, 
        firstPartyTel: thirdPartyTel, 
        firstPartyAddress: thirdPartyAddress,
        thirdPartyName: firstPartyName,
        thirdPartyIdCardNo: firstPartyIdCardNo, 
        thirdPartyTel: firstPartyTel, 
        thirdPartyAddress: firstPartyAddress
      });
    }

    if((val == '2' && changeRadioValue == '3') || (val == '3' && changeRadioValue == '2')) {
      setFieldsValue({
        secondPartyName: thirdPartyName,
          secondPartyIdCardNo: thirdPartyIdCardNo, 
          secondPartyTel: thirdPartyTel, 
          secondPartyAddress: thirdPartyAddress,
          thirdPartyName: secondPartyName,
          thirdPartyIdCardNo: secondPartyIdCardNo, 
          thirdPartyTel: secondPartyTel, 
          thirdPartyAddress: secondPartyAddress
      });
    }
    this.setState({
      changeRadioValue: val
    });
    
  };

  //乙方类型按钮切换
  onChangeyiTypeRadio = e => {
    const { setFieldsValue } = this.props.form;
    this.setState({
      radioYiTypeValue: e.target.value
    });
    setFieldsValue({
      secondPartyName: '',
      secondPartyIdCardNo: '',
      secondPartyTel: ''
    });
  };
  // renderCheckOthersMore = sValue => {
  //   api
  //     .publicCommonFileFilePreview({
  //       url: sValue,
  //       isLoad: '1'
  //     })
  //     .then(data => {
  //       if (data.data) {
  //         this.setState({
  //           wenUrlMore: data.data
  //         });
  //       }
  //     });
  // };

  selectView = () => {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 20
        },
        md: {
          span: 16
        }
      }
    };
    const { getFieldDecorator } = this.props.form;
    const currentContractType = this.state.contractType;
    if (currentContractType === '01') {
      //	企业服务合同
      return (
        <div>
          <FormItem {...formItemLayout} label="联系电话">
            {getFieldDecorator('secondPartyTel', {
              initialValue: this.state.currentRow.secondPartyTel || '',
              rules: [
                {
                  required: false,
                  message: '请输入联系电话'
                },
                {
                  pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                  message: '联系电话格式错误！'
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          {/*{this.state.currentRow.effectStartDate ? <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate', {*/}
          {/*initialValue: [moment(this.state.currentRow.effectStartDate, dateFormat), moment(this.state.currentRow.effectEndDate, dateFormat)],*/}
          {/*})(<RangePicker disabled={this.state.editable} />)}*/}
          {/*</FormItem> : <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate')(<RangePicker disabled={this.state.editable} />)}*/}
          {/*</FormItem>}*/}

          <FormItem {...formItemLayout} label="付费金额">
            {getFieldDecorator('payAmount', {
              initialValue: this.state.currentRow.payAmount || '',
              rules: [
                {
                  validator: this.checkJinE
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                maxLength={15}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          {this.state.currentRow.payDate ? (
            <FormItem {...formItemLayout} label="付费日期">
              {getFieldDecorator('payDateSd', {
                initialValue: moment(this.state.currentRow.payDate, dateFormat)
              })(
                <DatePicker
                  format="YYYY-MM-DD"
                  disabled={this.state.editable}
                />
              )}
            </FormItem>
          ) : (
            <FormItem {...formItemLayout} label="付费日期">
              {getFieldDecorator('payDateSd', {})(
                <DatePicker
                  format="YYYY-MM-DD"
                  disabled={this.state.editable}
                />
              )}
            </FormItem>
          )}
        </div>
      );
    }
    if (currentContractType === '02' || currentContractType === '03') {
      //劳动合同/劳务合同-个人
      const smallTag =
        currentContractType === '02' ? (
          <FormItem {...formItemLayout} label="工作岗位">
            {getFieldDecorator('workPost', {
              initialValue: this.state.currentRow.workPost || ''
            })(
              <Input
                placeholder={
                  this.state.editable === true ? '' : '请输入岗位名称'
                }
                disabled={this.state.editable}
              />
            )}
          </FormItem>
        ) : (
          <FormItem {...formItemLayout} label="工作内容">
            {getFieldDecorator('content', {
              initialValue: this.state.currentRow.content || ''
            })(
              <Input
                placeholder={
                  this.state.editable === true ? '' : '请输入岗位及内容'
                }
                disabled={this.state.editable}
              />
            )}
          </FormItem>
        );
      return (
        <div>
          <FormItem {...formItemLayout} label="身份证号码">
            {getFieldDecorator('secondPartyIdCardNo', {
              initialValue: this.state.currentRow.secondPartyIdCardNo || '',
              rules: [
                {
                  required: false,
                  message: '请输入身份证号码'
                },
                {
                  pattern: /(^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$)|(^[1-9]\d{5}\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{2}$)/,
                  message: '证件格式错误'
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={
                  this.state.editable
                    ? true
                    : this.state.radioYiTypeValue === '01' &&
                      this.state.changeRadioValue === '1'
                    ? this.state.currentRow.contractType === '02' ||
                      this.state.currentRow.contractType === '03'
                      ? true
                      : false
                    : false
                }
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="联系电话">
            {getFieldDecorator('secondPartyTel', {
              initialValue: this.state.currentRow.secondPartyTel || '',
              rules: [
                {
                  required: false,
                  message: '请输入联系电话'
                },
                {
                  pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                  message: '联系电话格式错误！'
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={
                  this.state.editable
                    ? true
                    : this.state.radioYiTypeValue === '01' &&
                      this.state.changeRadioValue === '1'
                    ? this.state.currentRow.contractType === '02' ||
                      this.state.currentRow.contractType === '03'
                      ? true
                      : false
                    : false
                }
                maxLength={13}
              />
            )}
          </FormItem>

          {/*{this.state.currentRow.effectStartDate ? <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate', {*/}
          {/*initialValue: [moment(this.state.currentRow.effectStartDate, dateFormat), moment(this.state.currentRow.effectEndDate, dateFormat)],*/}
          {/*})(<RangePicker format={dateFormat} disabled={this.state.editable} />)}*/}
          {/*</FormItem> : <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate', {})(<RangePicker format={dateFormat} disabled={this.state.editable} />)}*/}
          {/*</FormItem>}*/}

          <FormItem {...formItemLayout} label="试用期">
            {getFieldDecorator('period', {
              initialValue: this.state.currentRow.period,
              rules: [
                {
                  required: false
                }
              ]
            })(
              <InputNumber
                min={0}
                max={100}
                style={{ width: '260px' }}
                disabled={this.state.editable}
              />
            )}
            <span>月</span>
          </FormItem>
          {smallTag}
          <FormItem {...formItemLayout} label="岗位工资">
            {getFieldDecorator('postSalary', {
              initialValue: this.state.currentRow.postSalary || '',
              rules: [
                {
                  validator: this.checkJinE
                }
              ]
            })(
              <Input
                style={{ width: 294 }}
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="试用期工资">
            {getFieldDecorator('periodSalary', {
              initialValue: this.state.currentRow.periodSalary || '',
              rules: [
                {
                  validator: this.checkJinE
                }
              ]
            })(
              <Input
                style={{ width: 294 }}
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="按">
            {getFieldDecorator('distributionMode', {
              initialValue: this.state.currentRow.distributionMode || ''
            })(
              <Select
                style={{ width: '254px', marginRight: '8px' }}
                disabled={this.state.editable}
              >
                {this.renderDistributionModeList()}
              </Select>
            )}
            <span>发放</span>
          </FormItem>
        </div>
      );
    }
    if (currentContractType === '04') {
      //劳务合同-单位
      return (
        <div>
          <FormItem {...formItemLayout} label="身份证号码">
            {getFieldDecorator('secondPartyIdCardNo', {
              initialValue: this.state.currentRow.secondPartyIdCardNo,
              rules: [
                {
                  required: false,
                  message: '请输入证件号码'
                },
                {
                  pattern: /(^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$)|(^[1-9]\d{5}\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{2}$)/,
                  message: '证件格式错误'
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                maxLength={18}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="联系电话">
            {getFieldDecorator('secondPartyTel', {
              initialValue: this.state.currentRow.secondPartyTel,
              rules: [
                {
                  required: false,
                  message: '请输入联系电话'
                },
                {
                  pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                  message: '联系电话格式错误！'
                }
              ]
            })(
              <Input
                placeholder={this.state.editable === true ? '' : '请输入'}
                disabled={this.state.editable}
                maxLength={13}
              />
            )}
          </FormItem>
          {/*<FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate', {})(<RangePicker format={dateFormat} disabled={this.state.editable} />)}*/}
          {/*</FormItem>*/}
          {/*{this.state.currentRow.effectStartDate  ? <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate', {*/}
          {/*initialValue: [moment(this.state.currentRow.effectStartDate, dateFormat), moment(this.state.currentRow.effectEndDate, dateFormat)],*/}
          {/*})(<RangePicker disabled={this.state.editable} />)}*/}
          {/*</FormItem> : <FormItem {...formItemLayout} label="合同有效期">*/}
          {/*{getFieldDecorator('effectDate')(<RangePicker disabled={this.state.editable} />)}*/}
          {/*</FormItem>}*/}
          <FormItem {...formItemLayout} label="劳务内容">
            {getFieldDecorator('content', {
              initialValue: this.state.currentRow.content
            })(
              <Input
                placeholder={
                  this.state.editable === true ? '' : '请输入劳务内容'
                }
                maxLength={20}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="劳务地点">
            {getFieldDecorator('workPlace', {
              initialValue: this.state.currentRow.workPlace
            })(
              <Input
                placeholder={
                  this.state.editable === true ? '' : '请输入劳务地点'
                }
                maxLength={50}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="劳务费用" className="lao_108">
            {getFieldDecorator('serviceAmount', {
              initialValue: this.state.currentRow.serviceAmount,
              rules: [
                {
                  validator: this.checkJinE
                }
              ]
            })(
              <Input
                suffix="元"
                placeholder={this.state.editable === true ? '' : '请输入'}
                maxLength={8}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="按">
            {getFieldDecorator('distributionMode', {
              initialValue: this.state.currentRow.distributionMode
            })(
              <Select
                disabled={this.state.editable}
                style={{ width: '255px', marginRight: '8px' }}
              >
                {this.renderDistributionModeList()}
              </Select>
            )}
            <span>发放</span>
          </FormItem>
          <FormItem {...formItemLayout} label="劳务总金额" className="lao_108">
            {getFieldDecorator('serviceTotalAmount', {
              initialValue: this.state.currentRow.serviceTotalAmount,
              rules: [
                {
                  validator: this.checkJinE
                }
              ]
            })(
              <Input
                suffix="元"
                placeholder={this.state.editable === true ? '' : '请输入'}
                maxLength={8}
                disabled={this.state.editable}
              />
            )}
          </FormItem>
        </div>
      );
    }
  };

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 17
        },
        md: {
          span: 17
        }
      }
    };
    const { getFieldDecorator, getFieldValue } = this.props.form;
    const editableView =
      this.state.editable === true ? (
        <FormItem {...formItemLayout} label="合同电子文件">
          {getFieldDecorator('contractUrl', {
            rules: [
              {
                required: true,
                message: '请上传合同文件'
              }
            ]
          })(
            <div style={{ position: 'relative' }}>
              <div
                width="100%"
                style={{
                  width: '100%',
                  height: '35px',
                  position: 'absolute',
                  zIndex: '9'
                }}
              />
              <Upload
                fileList={this.state.fileListWed}
                style={{ width: '100%' }}
              />
              <a
                // href={this.state.wenUrl}
                href="javascript:void(0);"
                // target="_blank"
                style={{ color: '#999' }}
                id="cha_fu"
                onClick={this.checkContract.bind(this, this.state.currentRow.contractUrl, this.state.wenUrl)}
                // onClick={this.checkContract.bind(this, this.state.wenUrl)}
              >
                查看附件
              </a>
            </div>
          )}
        </FormItem>
      ) : (
        <FormItem {...formItemLayout} label="合同电子文件">
          {getFieldDecorator('contractUrl', {
            initialValue: this.state.fileListWed,
            rules: [
              {
                required: true,
                message: '请上传合同文件'
              }
            ]
          })(
            <div className="popo-url-upload">
              <Upload
                fileList={this.state.fileListWed}
                {...this.modelUpload}
                style={{ width: '100%' }}
                onRemove={() => {
                  return false;
                }}
                className="remove-no"
              >
                <Button style={{ marginRight: '8px' }}>
                  <Icon type="upload" />
                  替换文件
                </Button>
                支持:.doc\.docx\.pdf
              </Upload>
              <a
                className="upload-p"
                onClick={this.checkContract.bind(this, this.state.currentRow.contractUrl, this.state.wenUrl)}
                // href={this.state.wenUrl}
                // target="_blank"
              />
            </div>
          )}
        </FormItem>
      );
      const taskColumns=[
        {
          title: '序号',
          dataIndex: 'name',
          key: 'name',
          width: '20px',
          render: (text, record,index) => {
            return (
              <span>{index+1}</span>
            );
          }
        },
        {
          title: '驻勤点名称',
          dataIndex: 'stationName',
          key: 'stationName',
          render: (text, record) => {
            return (
              <span>
                {
                  this.state.editable?
                     <Tooltip placement="topLeft" title={text}>
                      <Input
                        value={text}
                        disabled={this.state.editable}
                        placeholder="请输入驻勤点名称"
                      />
                    </Tooltip>: <Input
                      value={text}
                      onChange={e =>
                        this.$handleFieldChange(
                          record.comContractStationId,
                          e.target.value,
                          'stationName',
                        )
                      }
                      disabled={this.state.editable}
                      placeholder="请输入驻勤点名称"
                    />
                }
              </span>
           
            );
          }
        },
        {
          title: '驻勤点地址',
          dataIndex: 'stationAddress',
          key: 'stationAddress',
          render: (text, record) => {
            return (
              <span>
                {
                  this.state.editable?<Tooltip placement="topLeft" title={text}>
                    <Input
                      value={text}
                      onChange={e =>
                        this.$handleFieldChange(
                          record.comContractStationId,
                          e.target.value,
                          'stationAddress',
                        )
                      }
                      disabled={this.state.editable}
                      placeholder="请输入驻勤点地址"
                    />
                  </Tooltip>: <Input
                      value={text}
                      onChange={e =>
                        this.$handleFieldChange(
                          record.comContractStationId,
                          e.target.value,
                          'stationAddress',
                        )
                      }
                      disabled={this.state.editable}
                      placeholder="请输入驻勤点地址"
                    />
                }
              </span>
             
            );
          }
        },
        {
          title: '操作',
          dataIndex: 'option',
          key: 'option',
          width: '80px',
          render: (text, record) => (
            <div>
              <span
                style={{
                  color: '#D9001B',
                  cursor: 'pointer',
                  marginRight: '20px'
                }}
              >
                <Popconfirm
                  title="是否要删除此行？"
                  onConfirm={e =>
                    this.$remove(
                      record.comContractStationId
                    )
                  }
                >
                  <a disabled={this.state.editable}>删除</a>
                </Popconfirm>
              </span>
            </div>
          )
        }
      ]
    return (
      <div>
        <Drawer
          title={this.state.editable === true ? '查看合同' : this.state.editOrGo?'编辑合同':'续签合同'}
          width={600}
          closable={false}
          destroyOnClose
          onClose={() => {
            if (!this.state.editable) {
              //编辑合同表框
              // if (!this.state.currentRow.contractUrl) {
              //   message.warn('当前合同电子文件为空或者不正确，请重新添加');
              // } else {
                this.props.changeTable();
                this.props.openUpdate();
                // this.setState({ open: false,wenUrl:'' });
                this.setState({
                  open: false,
                  wenUrl: this.state.wenUrlMore,
                  radioYiTypeValue: '01' //每次关闭都让乙方类型这个字段置为01
                });
                this.props.onChange(false);
              // }
            } else {
              //查看合同表框
              this.setState({
                open: false
              });
              this.props.onChange(false);
            }
          }}
          visible={this.state.open}
          zIndex={11}
          style={{ paddingRight: '70px', paddingBottom: '60px' }}
        >
          <div>
            <div>
              <Form onSubmit={this.handleEditContractSubmit}>
                <FormItem {...formItemLayout} label="合同类型">
                  {getFieldDecorator('contractType', {
                    initialValue: this.state.currentRow.contractType || '',
                    rules: [
                      {
                        required: true,
                        message: '请选择合同类型'
                      }
                    ]
                  })(
                    <PSelect
                      style={{ width: 294 }}
                      placeholder="请选择"
                      type="contractType"
                      onChange={this.pSelectChange}
                      disabled
                    />
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="合同名称">
                  {getFieldDecorator('contractName', {
                    initialValue: this.state.currentRow.contractName,
                    rules: [
                      {
                        required: true,
                        message: '请输入合同名称'
                      }
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      disabled={this.state.editable
                        // ?this.state.editable:this.state.currentRow.contractType=='02'?true:false
                      }
                      maxLength={30}
                    />
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="企业档案编号">
                  {getFieldDecorator('comFileNo', {
                    initialValue: this.state.currentRow.comFileNo || '',
                    rules: [
                      {
                        required: true,
                        message: '请输入企业档案编号'
                      },
                      // {
                      //   // pattern: /[0-9]/,
                      //   pattern: /^[A-Za-z0-9]+$/,
                      //   message: '请输入数字或者英文,限制30个字符'
                      // }
                    ]
                  })(
                    <Input
                      placeholder="请输入"
                      disabled={this.state.editable}
                      maxLength={30}
                    />
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="我方为">
                  {getFieldDecorator('comParty', {
                    initialValue: this.state.currentRow.comParty || '',
                    rules: [
                      {
                        required: true,
                        message: '请选择甲方/乙方'
                      }
                    ]
                  })(
                    <RadioGroup
                      onChange={this.onChangeRadio}
                      disabled={this.state.editable}
                    >
                      <Radio value={'1'}>甲方</Radio>
                      <Radio value={'2'}>乙方</Radio>
                      {this.state.contractType == "01" && (
                        <Radio value={"3"}>丙方</Radio>
                      )}
                    </RadioGroup>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="甲方名称">
                  {getFieldDecorator('firstPartyName', {
                    initialValue: this.state.currentRow.firstPartyName,
                    rules: [{
                      required: true,
                      message: '请输入'
                    }]
                  })(
                    <Input
                      placeholder="请输入"
                      disabled={this.state.editable || getFieldValue('comParty') == '1'}
                      maxLength={30}
                      onClick={() => {
                        if(this.state.editable || this.state.changeRadioValue != '2') return;
                        if (
                          this.state.currentRow.contractType === '02' ||
                          this.state.currentRow.contractType === '03'
                        ) {
                          $perModal({
                            type: 'radio',
                            value: this.state.perId,
                            onOk: (values, close) => {
                              close();
                              const { setFieldsValue } = this.props.form;
                              this.setState({
                                perId: values[0].perId,
                              });
                              setFieldsValue({
                                firstPartyName: values[0].name,
                                firstPartyIdCardNo: values[0].idCardNo,
                                firstPartyTel: values[0].mobilePhone
                              });
                              if(this.state.currentRow.contractType=='02'){
                                setFieldsValue({
                                  contractName:values[0].name+"劳动合同"
                                })
                              }
                            }
                          });
                        }
                      }}
                    />
                  )}
                </FormItem>

                <FormItem {...formItemLayout} label="甲方联系电话">
                  {getFieldDecorator('firstPartyTel', {
                    initialValue: this.state.currentRow.firstPartyTel,
                    rules: [
                      {
                        required: true,
                        message: '请输入联系电话'
                      },
                      {
                        pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                        message: '联系电话格式错误！'
                      }
                    ]
                  })(
                    <Input
                      placeholder={this.state.editable === true ? '' : '请输入'}
                      disabled={this.state.editable}
                    />
                  )}
                </FormItem>
                {
                  this.state.currentRow.contractType==='01'?this.state.editable?
                    <FormItem {...formItemLayout} label="甲方办公地址">
                    {getFieldDecorator('firstPartyAddress', {
                      initialValue:this.state.currentRow.firstPartyAddress,
                      rules:[
                        {
                          required: true,
                          message: '请输入办公地址'
                        }
                    ]
                  })(
                    <Tooltip placement="topLeft" title={this.state.currentRow.firstPartyAddress}>
                      <Input placeholder="请输入" maxLength={50} disabled={this.state.editable} value={this.state.currentRow.firstPartyAddress}/>
                    </Tooltip>
                  )}
                  </FormItem>:<FormItem {...formItemLayout} label="甲方办公地址">
                    {getFieldDecorator('firstPartyAddress', {
                      initialValue:this.state.currentRow.firstPartyAddress,
                      rules:[
                        {
                          required: true,
                          message: '请输入办公地址'
                        }
                    ]
                  })(
                    <Input placeholder="请输入" maxLength={50} disabled={this.state.editable}/>
                  )}
                  </FormItem>:''
                }
                {/* <FormItem {...formItemLayout} label="甲方办公地址">
                  {getFieldDecorator('firstPartyAddress', {
                    initialValue:this.state.currentRow.firstPartyAddress,
                    rules:[
                      {
                        required: true,
                        message: '请输入办公地址'
                      }
                  ]
                })(
                  <Input placeholder="请输入" maxLength={50} disabled={this.state.editable}/>
                )}
                </FormItem> */}

                <FormItem {...formItemLayout} label="乙方名称">
                  {getFieldDecorator('secondPartyName', {
                    initialValue: this.state.currentRow.secondPartyName,
                    rules: [{
                      required: true,
                      message: '请输入'
                    }]
                  })(
                    <Input
                      placeholder={this.state.editable === true ? '' : '请输入'}
                      disabled={this.state.editable || getFieldValue('comParty') == '2'}
                      maxLength={30}
                      onClick={() => {
                        if (
                          !!!this.state.editable &&
                          this.state.radioYiTypeValue === '01' &&
                          this.state.changeRadioValue === '1'
                        ) {
                          if(this.state.changeRadioValue == '2') return;
                          if (
                            this.state.currentRow.contractType === '02' ||
                            this.state.currentRow.contractType === '03'
                          ) {
                            $perModal({
                              type: 'radio',
                              value: this.state.perId,
                              onOk: (values, close) => {
                                close();
                                const { setFieldsValue } = this.props.form;
                                this.setState({
                                  perId: values[0].perId,
                                });
                                setFieldsValue({
                                  secondPartyName: values[0].name,
                                  secondPartyIdCardNo: values[0].idCardNo,
                                  secondPartyTel: values[0].mobilePhone
                                });
                                if(this.state.currentRow.contractType=='02'){
                                  setFieldsValue({
                                    contractName:values[0].name+"劳动合同"
                                  })
                                }
                              }
                            });
                          }
                        }
                      }}
                    />
                  )}
                </FormItem>
               
                <FormItem {...formItemLayout} label="乙方联系电话">
                  {getFieldDecorator('secondPartyTel', {
                    initialValue: this.state.currentRow.secondPartyTel,
                    rules: [
                      {
                        required: true,
                        message: '请输入联系电话'
                      },
                      {
                        pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                        message: '联系电话格式错误！'
                      }
                    ]
                  })(
                    <Input
                      placeholder={this.state.editable === true ? '' : '请输入'}
                      disabled={this.state.editable}
                    />
                  )}
                </FormItem>
                {
                  this.state.currentRow.contractType==='01'?this.state.editable? <FormItem {...formItemLayout} label="乙方办公地址">
                  {getFieldDecorator('secondPartyAddress', {
                     initialValue:this.state.currentRow.secondPartyAddress,
                        rules:[
                          {
                            required: true,
                            message: '请输入'
                          }
                      ]
                  })(
                    <Tooltip placement="topLeft" title={this.state.currentRow.secondPartyAddress}>
                      <Input placeholder="请输入" maxLength={50} disabled={this.state.editable} value={this.state.currentRow.secondPartyAddress}/>
                    </Tooltip>
                  )}
                </FormItem>:<FormItem {...formItemLayout} label="乙方办公地址">
                  {getFieldDecorator('secondPartyAddress', {
                     initialValue:this.state.currentRow.secondPartyAddress,
                        rules:[
                          {
                            required: true,
                            message: '请输入'
                          }
                      ]
                  })(
                    <Input placeholder="请输入" maxLength={50} disabled={this.state.editable}/>
                  )}
                </FormItem>:''
                }

                <div style={{display: this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3"? 'block': 'none'}}>
                <FormItem {...formItemLayout} label="丙方名称">
                  {getFieldDecorator('thirdPartyName', {
                    initialValue: this.state.currentRow.thirdPartyName,
                    rules: [{
                      required: this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3",
                      message: '请输入'
                    }]
                  })(
                    <Input
                      placeholder="请输入"
                      disabled={this.state.editable || getFieldValue('comParty') == '3'}
                      maxLength={30}
                    />
                  )}
                </FormItem>

                <FormItem {...formItemLayout} label="丙方联系电话">
                  {getFieldDecorator('thirdPartyTel', {
                    initialValue: this.state.currentRow.thirdPartyTel,
                    rules: [
                      {
                        required: this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3",
                        message: '请输入联系电话'
                      },
                      {
                        pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                        message: '联系电话格式错误！'
                      }
                    ]
                  })(
                    <Input
                      placeholder={this.state.editable === true ? '' : '请输入'}
                      disabled={this.state.editable}
                    />
                  )}
                </FormItem>
                {
                  this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3"?this.state.editable?
                    <FormItem {...formItemLayout} label="丙方办公地址">
                    {getFieldDecorator('thirdPartyAddress', {
                      initialValue:this.state.currentRow.thirdPartyAddress,
                      rules:[
                        {
                          required: this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3",
                          message: '请输入办公地址'
                        }
                    ]
                  })(
                    <Tooltip placement="topLeft" title={this.state.currentRow.thirdPartyAddress}>
                      <Input placeholder="请输入" maxLength={50} disabled={this.state.editable} value={this.state.currentRow.thirdPartyAddress}/>
                    </Tooltip>
                  )}
                  </FormItem>:<FormItem {...formItemLayout} label="丙方办公地址">
                    {getFieldDecorator('thirdPartyAddress', {
                      initialValue:this.state.currentRow.thirdPartyAddress,
                      rules:[
                        {
                          required: this.state.currentRow.contractType==='01'&&this.props.form.getFieldValue("comParty") === "3",
                          message: '请输入办公地址'
                        }
                    ]
                  })(
                    <Input placeholder="请输入" maxLength={50} disabled={this.state.editable }/>
                  )}
                  </FormItem>:''
                }
                </div>
                
                {/* {this.state.currentRow.effectStartDate !== '' ? (
                  <div> */}
                    <FormItem {...formItemLayout} label="合同开始时间"
                    extra={
                      <Checkbox
                        disabled={this.state.editable}
                        checked={this.state.Indefinite}
                        onChange={(value) => {
                          this.setState({
                            Indefinite:value.target.checked
                          })
                          const { setFieldsValue } = this.props.form;
                          if(!value.target.checked){
                            setFieldsValue({
                              effectEndDate:this.state.currentRow.effectEndDate&&this.state.currentRow.effectEndDate.indexOf('9999-')==-1?moment(this.state.currentRow.effectEndDate, dateFormat):null,
                            });
                          }else{
                            setFieldsValue({
                              effectEndDate:moment('9999-12-31'),
                            });
                          }
                        }}
                      >
                        此合同为无固定期限合同
                      </Checkbox>
                    }>
                      {getFieldDecorator("effectStartDate", {
                        initialValue: this.state.currentRow.effectStartDate?moment(this.state.currentRow.effectStartDate, dateFormat):null,
                        rules: [
                          {
                            required: true,
                            message: "请选择合同开始时间"
                          }
                        ]
                      })(
                        <DatePicker
                          format={dateFormat}
                          disabled={this.state.editable}
                        />
                      )}
                    </FormItem>
                    <FormItem {...formItemLayout} label="合同结束时间">
                      {getFieldDecorator("effectEndDate", {
                        initialValue: this.state.currentRow.effectEndDate?moment(this.state.currentRow.effectEndDate, dateFormat):null,
                        rules: [
                          {
                            required: true,
                            message: "请选择合同结束时间"
                          }
                        ]
                      })(
                        <DatePicker
                          format={dateFormat}
                          disabled={this.state.editable?this.state.editable:this.state.Indefinite}
                        />
                      )}
                    </FormItem>
                    {/* <FormItem {...formItemLayout} label="合同有效期">
                      {getFieldDecorator('effectDate', {
                        initialValue: [
                          moment(
                            this.state.currentRow.effectStartDate,
                            dateFormat
                          ),
                          moment(
                            this.state.currentRow.effectEndDate,
                            dateFormat
                          )
                        ],
                        rules: [
                          {
                            required: true,
                            message: '请选择合同有效期'
                          }
                        ]
                      })(
                        <RangePicker
                          onChange={this.validDeadlineChange}
                          disabled={this.state.editable}
                        />
                      )}
                    </FormItem> */}
                  {/* </div>
                ) : (
                  <div>
                    <FormItem {...formItemLayout} label="合同有效期">
                      {getFieldDecorator('effectDate', {
                      rules: [
                        {
                          required: true,
                          message: '请选择合同有效期'
                        }
                      ]
                    })(
                        <RangePicker
                          onChange={this.validDeadlineChange}
                          disabled={this.state.editable}
                        />
                      )}
                    </FormItem>
                  </div>
                )} */}
                <FormItem {...formItemLayout} label="合同备注信息">
                  {getFieldDecorator('remark', {
                    initialValue: this.state.currentRow.remark || '',
                    rules: [
                      {
                        required: false,
                        pattern: /(^[\s\S]{1,300}$)/,
                        message: '请输入中文字符，限制长度300个字符'
                      }
                    ]
                  })(
                    <TextArea
                      rows={4}
                      placeholder={
                        this.state.editable === true ? '' : '请输入合同备注信息'
                      }
                      disabled={this.state.editable}
                    />
                  )}
                </FormItem>

                {editableView}
                {
                  this.state.currentRow.contractType==='01'&&<Form.Item {...formItemLayout} label="驻勤点信息" style={{marginBottom:'40px'}}>
                  {getFieldDecorator('taskStationArr', {
                    initialValue: this.state.currentRow.taskStationArr,
                    rules: [
                      {
                        required:true,
                        message: '请输入驻勤点信息!'
                      }
                    ]
                  })(
                    <div>
                      <Table
                        dataSource={this.state.currentRow.taskStationList}
                        columns={taskColumns}
                        pagination={false}
                      />
                      {
                        !this.state.editable&&<Button
                        type="primary"
                        onClick={() => {
                          this.$add(
                            // 'taskStationList',
                          );
                        }}
                      >
                        + 添加一行
                        </Button>
                      }
                      
                    </div>
                  )}
                </Form.Item>
                }
              </Form>
            </div>
            <div
              style={{
                position: 'absolute',
                bottom: 0,
                width: '100%',
                borderTop: '1px solid #e8e8e8',
                padding: '10px 16px',
                textAlign: 'right',
                left: 0,
                background: '#fff',
                borderRadius: '0 0 4px 4px'
              }}
            >
              <Button
                style={{
                  marginRight: 8
                }}
                onClick={() => {
                  if (!this.state.editable) {
                    //编辑合同表框
                    // if (!this.state.currentRow.contractUrl) {
                    //   message.warn(
                    //     '当前合同电子文件为空或者不正确，请重新添加'
                    //   );
                    // } else {
                      this.props.changeTable();
                      // this.setState({ open: false,wenUrl:'' });
                      this.setState({
                        open: false,
                        wenUrl: this.state.wenUrlMore,
                        radioYiTypeValue: '01' //每次关闭都让乙方类型这个字段置为01
                      });
                      this.props.onChange(false);
                    // }
                  } else {
                    //查看合同表框
                    this.setState({
                      open: false
                    });
                    this.props.onChange(false);
                  }
                }}
              >
                返回
              </Button>
              {this.state.editable ? (
                ''
              ) : (
                <Button type="primary" onClick={this.handleEditContractSubmit}>
                  保存
                </Button>
              )}
            </div>
          </div>
        </Drawer>
        
      </div>
    );
  }
}
