import React from 'react';
// import RreactDom from 'react-dom';
import PropTypes, { func } from 'prop-types';
import {
  Layout,
  Menu,
  Icon,
  Avatar,
  Dropdown,
  Modal,
  message, /* Tag, message */
  notification,
  Button
} from 'antd';
import tim from '../utils/imInitialize'
import DocumentTitle from 'react-document-title';
import { connect } from 'dva';
import { Link, Route, Redirect, Switch } from 'dva/router';
import { gup } from '../utils/utils';
/* import groupBy from "lodash/groupBy";
 */ import { ContainerQuery } from 'react-container-query';
import classNames from 'classnames';
import Debounce from 'lodash-decorators/debounce';
/* import HeaderSearch from "../components/HeaderSearch";
 */ import NoticeIcon from '../components/NoticeIcon';
import GlobalFooter from '../components/GlobalFooter';
import NotFound from '../routes/Exception/404';
import styles from './BasicLayout.less';
import IconS from '../components/IconS';
import Utils from '../common/bcx_utils';
import {
  // httpsAddress, 
  domainConfig
} from '../utils/config';
import moment from 'moment';
import {
  systemComVaseInfoGet,
  systemOauthGetUserMenus,
  updateSelectMessageRead, //设置所有未读消息为已读（new）
  queryNotices,
  systemPerAccountInfoGetUserAccount,
  getComProblemPerNum,
  comSalarySyncInitCheckIsInit, // 校验企业是否完成了薪酬同步初始化
} from '../services/api';
import MessageDetail from '../routes/Administrative/MessageSettings/messageDetail';
import ChangePassword from '../routes/User/ChangePassword';
import Welcome from '../routes/Enterprise/Organization/Welcome';
import IEReminder from '../routes/Enterprise/Organization/IEReminder';
// import Initialization from '../routes/Enterprise/HomePage/Initialization';
import ReceiveList from '../routes/Administrative/MessageSettings/ReceiveList';
import NotifList from '../routes/Administrative/MessageSettings/NotifList';
import $nModal from '../utils/modal/nModal';
import $modal from '../utils/modal';
import "moment/locale/zh-cn";
moment.locale('zh-cn');
const store = require('store');
// 默认头像
const defaultAvatar = require('../assets/images/avatar.png');
let slideMenuPath = [];

const { Header, Sider, Content } = Layout;
const { SubMenu } = Menu;

//  侧边一级导航
const menugroup = {
  0: ['企业首页', '企业管理'],
  1: ['数据地图'],
  2: ['人事管理', '内勤管理', '驻勤管理', '薪酬管理', '五险一金设置', '奖惩管理', '临保任务'],
  3: ['消息', '审批', '劳务薪酬', '设备管理', '合同管理'],
  4: ['活动管理', '项目管理', '备案许可申报', '申报业务','统计调查'],
  5: ['课件管理', '培训管理', '在线培训', '考试管理', '保安资格证管理', '保安等级证管理', '考培负责人管理', '岗位适应性培训','等级证学员实习记录'],
  6: ['企业保险', '金融钱包', '薪资发放管理','业务发票'],
  7: ['大型活动'],
  8: [
    '地图可视化',
    '活动统计',
    '项目统计',
    '任务统计',
    '审批统计',
    '考勤统计',
    '培训统计',
    '保险统计'
  ],
  9: ['仪表盘', '表单页', '列表页', '详情页', '结果', '异常', '云会议'],
  10: ['企业统计', '数据统计'],
  11:["防空指挥"],
  12: ['保安员考培信息抽查管理','补贴发放管理'],
  13: ['薪酬服务']
};

/**
 * iverry remark
 * 头部导航，以及导航对应左边的菜单栏
 */
const topMenu = [
  {
    // to: "/HomePage/Initialization",
    to: '/enterprise/company',
    text: '',
    items: ['企业首页', '企业通讯录', '企业管理']
  },
  // {
  //   to: "/PersonnelRecruitment/ListContainer",
  //   text: "人事",
  //   items: ["人事管理", "内勤管理", "五险一金设置", "奖惩管理"]
  // },
  {
    to: '/datamap/onekeysearch',
    text: '数据地图',
    items: ['数据地图']
  },
  {
    to: '/PersonnelRecruitment/departmentmanagement',
    text: '人事',
    items: ['人事管理', '内勤管理', '驻勤管理', '薪酬管理', '五险一金设置', '奖惩管理', '临保任务']
  },
  {
    to: '/xiaoxitongzhi/Messages',
    text: '行政',
    items: ['消息', '审批', '劳务薪酬', '设备管理', '合同管理']
  },
  {
    // to: '/taskmanager/tasklist',
    to: '/PoliceDeclare/DeclarationList',
    text: '业务',
    items: ['活动管理', '项目管理', '备案许可申报', '申报业务']
  },
  {
    to: '/TrainingUnitsTrainingManagement/CoursesList',
    text: '培训',
    items: ['课件管理', '培训管理', '在线培训', '考试管理', '资格证打印', '等级证管理', '考培负责人管理']
  },
  {
    to: '/insurancemanagement/enterpriseinsurance',
    text: '金融保险',
    items: ['企业保险']
  },
  {
    to: '/publicsafety/system',
    text: '大型活动',
    items: ['大型活动']
  },
  {
    to: '/data/com-statistics',
    text: '数据统计',
    items: ['企业统计']
  },
  {
    to: '/meeting/buy-setMeal',
    text: '会议',
    items: ['云会议']
  },
  {
    to: '/command/prevention-and-control',
    text: '防控指挥',
  },
  {
    to: '/command/fuse',
    text: '融合调度指挥平台',
  },
  {
    to: '/spotCheck/certificateMessage',
    text: '协会服务',
    items:['保安员考培信息抽查管理']
  },
  {
    to: '/salary/service',
    text: '薪酬服务',
    items: ['薪酬服务']
  }
  // {
  //   to: "/exception/404",
  //   text: "统计",
  //   items: [
  //     "地图可视化",
  //     "活动统计",
  //     "项目统计",
  //     "任务统计",
  //     "审批统计",
  //     "考勤统计",
  //     "培训统计",
  //     "保险统计"
  //   ]
  // }
];
const query = {
  'screen-xs': {
    maxWidth: 575
  },
  'screen-sm': {
    minWidth: 576,
    maxWidth: 767
  },
  'screen-md': {
    minWidth: 768,
    maxWidth: 991
  },
  'screen-lg': {
    minWidth: 992,
    maxWidth: 1199
  },
  'screen-xl': {
    minWidth: 1200
  }
};

/**
通知头像
01开头：系统通知
02开头：任务通知
03开头：企业通知
04开头：考试通知
05开头：公安通知
06开头：平台通知 */
const noticeAwars = {
  '01': (
    <IconS
      style={{ fontSize: 34, color: '#A3DEDE' }}
      type="xitongtongzhixin saas2"
    />
  ),
  '02': (
    <IconS
      style={{ fontSize: 34, color: '#8DC9F7' }}
      type="renwuxinxin1 saas2"
    />
  ),
  '03': (
    <IconS style={{ fontSize: 34, color: '#FFCE3C' }} type="qiyexinxi saas2" />
  ),
  '04': (
    <IconS style={{ fontSize: 34, color: '#C9A3DE' }} type="kaoshiicon saas2" />
  ),
  '05': (
    <IconS
      style={{ fontSize: 34, color: '#0F71FF' }}
      type="gonganbuxinxi1 saas2"
    />
  ),
  '06': (
    <IconS
      style={{ fontSize: 34, color: '#B7D4FF' }}
      type="renyuanfasongxinxi saas2"
    />
  ),
  '07': (
    <IconS
      style={{ fontSize: 34, color: '#8DC9F7' }}
      type="shenpixiaoxi saas2"
    />
  )
};

@connect(state => ({
  companyInfo: state.global.companyInfo,
  imIsLogin: state.global.imIsLogin,
  lMenu: state.global.lMenu,
  tMenu: state.global.tMenu,
  menuInfo: state.global.menuInfo,
  footer: state.global.footer,
  client: state.client.client,
  im: state.im,
}))
class BasicLayout extends React.PureComponent {
  static childContextTypes = {
    location: PropTypes.object,
    breadcrumbNameMap: PropTypes.object
  };
  constructor(props) {
    super(props);
    // 把一级 Layout 的 children 作为菜单项
    this.menus = props.navData.reduce(
      (arr, current) => arr.concat(current.children),
      []
    );
    // const currentGroup = 
    //   refresh[this.props.location.pathname.split('/')[1]] || 0;
    this.state = {
      menuauth: [], //后台返回的菜单
      openKeys: this.getDefaultCollapsedSubMenus(props),
      currentGroup: 0, //当前组
      topMenu,
      record: {},
      checkModal: false,
      changePasswordVisible: false, //修改密码Modal
      popupVisible: false, //消息通知弹窗是否显示
      isShowIEPrompt: false, //是否IE浏览器
      currentKey: '0',
      userMobilePhone: null,//用户登录手机号码
      noticeIsInit: false, //消息弹窗是否已经弹出
      commandWindow: null,//浏览器上是否新增了防控指挥的窗口，用于后续退出登录的时候，将防控指挥的窗口关闭
    };
    this.loginOut();
    this.systemComVaseInfoGet();
    if (store.get('saas') !== undefined) {
      // this.systemComVaseInfoGet();
      this.systemOauthGetUserMenus();
      // this.systemPerAccountInfoGetUserAccount1();
      // this.props.dispatch({
      //   type: 'global/fetchNotices'
      // });
    }

    // 判断url上是否带上token （防控指挥需要跳转到https页面，url上会携带token）
    const access_token = gup('access_token', window.location.href);
    if (!!access_token) {
      const saas = store.get('saas') || {};
      store.set('saas', { ...saas, access_token });
      // this.systemOauthGetUserMenus();
      store.set('isShowContent', { isShowContent: true });
    }
  }
  componentWillMount() {
    const pathName = window.location.pathname;
    if (/^\/bbdweb.*/.test(pathName)) {
      const path = window.location.pathname.replace(/^\/bbdweb(\/#\/)?/, '');
      this.props.history.replace(path);
    }
    // 全局问题人员通知
    const noticePerMsg = () => {
      const reFatch = () => {
        if(window.noticePerMsgTimer){
          clearTimeout(window.noticePerMsgTimer);
          window.noticePerMsgTimer = null;
        }
        window.noticePerMsgTimer = setTimeout(() => {
          noticePerMsg();
        }, 1000 * 60 * 5);
      };
      // const close = () => {
      //   const noticeWraps = document.getElementsByClassName('proble_notice');
      //   Reflect.apply(Array.prototype.forEach, noticeWraps, [item => {
      //     item.style.display = 'none';
      //     // RreactDom.unmountComponentAtNode(item.parentNode);
      //     // item.parentNode.removeChild(item);
      //     store.set('isShowContent', { isShowContent: true });
      //     this.props.history.push('/PersonnelRecruitment/problemPersonnel');
      //   }]);
      // }
      if (this.props.companyInfo.isInit == "0" || this.props.companyInfo.isInit==undefined) {
        reFatch();
      } else {
        getComProblemPerNum().then(res => {
          const num = res.data;
          if (!num) {
            reFatch();
          } else {
            if (num == '0') {
              reFatch();
            } else {
              $modal(
                `您企业有待处理问题人员${num}人`,
                (
                  <div style={{ color: 'red' }}>
                    请访问【人事】-【问题人员】页面尽快处理<br />
                    {/* <a onClick={() => {
                      // close();
                      store.set('isShowContent', { isShowContent: true });
                      console.log(this);
                      this.props.history.push('/PersonnelRecruitment/problemPersonnel');
                      reFatch();
                    }}>查看</a> */}
                  </div>
                ),
                [
                  {
                    type: 'primary',
                    text: '查看',
                    onPress: () => {
                      store.set('isShowContent', { isShowContent: true });
                      this.props.history.push('/PersonnelRecruitment/problemPersonnel');
                      reFatch();
                    }
                  }
                ],
                'warning',
                false,
                { color: 'red' }
              );
              // close();
              // notification.warning({
              //   className: 'proble_notice',
              //   message: `您企业有待处理问题人员${num}人`,
              //   description: (
              //     <div style={{color: 'red'}}>
              //       请访问【人事】-【问题人员】页面尽快处理<br />
              //       <a onClick={() => {
              //         close();
              //         reFatch();
              //       }}>查看</a>
              //     </div>
              //   ),
              //   duration: null,
              //   placement: 'topRight',
              //   icon: <Icon style={{color: 'red'}} type="exclamation-circle" />,
              //   onClose: () => {
              //     reFatch();
              //   }
              // });
            }
          }
        }).catch(err => {
          console.log(err);
          reFatch();
        });
      }
    }
    noticePerMsg();
  }
  componentDidMount() {
    this.isShowIEPrompt(); //调用判断浏览器方法
    // 临时调用修复消息和名字获取失败问题
    // 获取消息
    this.props.dispatch({
      type: 'global/changeNoticeLoading',
      payload: false
    });
    this.props.dispatch({ type: "global/menuChange" });
    queryNotices().then(data => {
      if (data !== undefined) {
        this.props.dispatch({
          type: 'global/saveNotices',
          payload: data.data
        });
        this.props.dispatch({
          type: 'user/changeNotifyCount',
          payload: data.length
        });
      }
    });
    // 获取用户信息
    try {
      systemPerAccountInfoGetUserAccount({}).then(data => {
        this.setState({
          userMobilePhone: data.data.mobilePhone
        })
        this.props.dispatch({
          type: 'user/saveCurrentUser',
          payload: data.data
        });
      });
    } catch (err) {
      console.log(err);
    }

    
  }

  componentDidCatch() {
    console.log('有点小错误');
  }

  componentWillUpdate() {
    this.loginOut();
  }

  componentWillReceiveProps(props) {
    // const pathName = window.location.pathname;
    // if(pathName == '/') {
    //   // 设置为欢迎页面
    //   store.set('isShowContent', { isShowContent: false });
    // }else {
    //   store.set('isShowContent', { isShowContent: true});
    // }
    if (props.currentKey !== this.state.currentKey) {
      const {
        location: { pathname }
      } = props || this.props;
      this.setState({
        currentGroup: Number(props.currentKey),
        currentKey: props.currentKey,
        openKeys: pathname.split('/').slice(1)
      });
    }
  }

  componentWillUnmount() {
    this.triggerResizeEvent.cancel();
  }

  //调用判断浏览器方法
  isShowIEPrompt = () => {
    if (Utils.isIEBrowser()) {
      this.setState({
        isShowIEPrompt: true
      });
    }
  };
  log = (key, value) => {
    if (typeof key == 'object') {
      key = JSON.stringify(key);
    }
    if (typeof key == 'object') {
      value = JSON.stringify(value);
    }
  };
  systemComVaseInfoGet = () => {
    // if (systemComVaseInfoGet({}) !== undefined) {
    if (!!this.props.companyInfo.comName) {
      const topMenu1 = this.state.topMenu;
      topMenu1[0].text = this.props.companyInfo.comName;
      this.props.dispatch({
        type: 'global/companyInfo',
        payload: this.props.companyInfo,
        topMenu: [...topMenu1]
      });
    } else {
      systemComVaseInfoGet({}).then(
        response => {
          const topMenu1 = this.state.topMenu;
          topMenu1[0].text = response.data.comName;
          this.props.dispatch({
            type: 'global/companyInfo',
            payload: response.data,
            topMenu: [...topMenu1]
          });
        },
        err => {
          console.log(err, 'systemComVaseInfoGet-err-获取企业详情');
        }
      );
      // }
    }
  };

  //获取用户登陆菜单
  systemOauthGetUserMenus = () => {
    if (store.get('saas') !== undefined) {
      let { menuInfo } = this.props;
      const menuauth = [];
      const setMenus = arr => {
        arr.forEach(val => {
          if (val.menuId && val.menuId === '50010001') {
            store.set('coursesListURL', { coursesListURL: val.menuUrl });
            // store.set('coursesListURL', { coursesListURL: val.menuUrl.replace(' http://test.bktang.cn/', 'http://localhost:8888/') });
            /******* 百课堂平台ID 百课堂-门户网站-默认路由修改 ********/
            if (val.platformId === '1401') {
              const menus = this.state.topMenu;
              menus.forEach(item => {
                if (
                  item.to ===
                  '/TrainingInstitutionsCoursewareManagement/CoursewareLibraryManagement'
                ) {
                  item.to = '/TrainingUnitsTrainingManagement/CoursesList';
                }
              });
              this.setState({
                topMenu: menus
              });
            }
          } else if (val.menuId && val.menuId === '50010002') {
            store.set('orderManagementURL', {
              orderManagementURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '50010003') {
            store.set('studentManagementURL', {
              studentManagementURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '50010004') {
            store.set('LearningStatisticsURL', {
              LearningStatisticsURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80010001') {
            store.set('coursewareLibraryManagementURL', {
              coursewareLibraryManagementURL: val.menuUrl
            });
            /******* 百课堂平台ID 百课堂-后台管理-默认路由修改 ********/
            if (val.platformId === '1402') {
              const menus = this.state.topMenu;
              menus.forEach(item => {
                if (
                  item.to === '/TrainingUnitsTrainingManagement/CoursesList'
                ) {
                  item.to =
                    '/TrainingInstitutionsCoursewareManagement/CoursewareLibraryManagement';
                }
              });
              this.setState({
                topMenu: menus
              });
            }
          } else if (val.menuId && val.menuId === '80020001') {
            store.set('orderManagementOtherURL', {
              orderManagementOtherURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80020002') {
            store.set('studentManagementOtherURL', {
              studentManagementOtherURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80020003') {
            store.set('classManagementURL', {
              classManagementURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80020004') {
            store.set('LearningStatisticsOtherURL', {
              LearningStatisticsOtherURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80030100') {
            //百课堂-考试管理-题库管理
            store.set('QuestionBankURL', {
              QuestionBankURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80030200') {
            //百课堂-考试管理-试卷管理
            store.set('TestPaperURL', {
              TestPaperURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80030300') {
            //百课堂-考试管理-考试安排
            store.set('ExamArrangeURL', {
              ExamArrangeURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '80030400') {
            //百课堂-考试管理-补考人员
            store.set('RemedialStaffURL', {
              RemedialStaffURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '90010100') {
            //百保盾-一键搜
            store.set('OneKeySearchURL', {
              OneKeySearchURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '20010400') {
            //百保盾-问题人员
            store.set('ProblemPersonnelURL', {
              ProblemPersonnelURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '30020300') {
            //百保盾-枪支管理
            store.set('GunControlURL', {
              GunControlURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '30020400') {
            //百保盾-车辆管理
            store.set('VehicleManageURL', {
              VehicleManageURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '40040100') {
            //百保盾-申报列表
            store.set('DeclarationListURL', {
              DeclarationListURL: val.menuUrl
            });
          }else if (val.menuId && val.menuId === '40050100') {
            //百保盾-年度调查表
            store.set('AnnualQuestionnaireURL', {
              AnnualQuestionnaireURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === "40040300") {
            //公安消息通知
            store.set('policeNoticeURL', {
              policeNoticeURL: val.menuUrl
            });
          } else if (val.menuId && val.menuId === '100010000') {
            //PSS-大型活动
            store.set('PublicSafetySystemURL', {
              PublicSafetySystemURL: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === '80040100') {
            store.set('PrintingCertificateURL', {
              PrintingCertificateURL: val.menuUrl
            });
          }
          // 补证管理
          else if (val.menuId && val.menuId === '80040200') {
            store.set('SupplementaryEvidenceURL', {
              SupplementaryEvidenceURL: val.menuUrl
            });
          }
          // 打印记录
          else if (val.menuId && val.menuId === '80040300') {
            store.set('PrintRecordURL', {
              PrintRecordURL: val.menuUrl
            });
          }
          // 资格证补贴批次管理
          else if (val.menuId && val.menuId === '80040400') {
            store.set('subsidyBatchUrl', {
              subsidyBatchUrl: val.menuUrl
            });
          }
          // 资格证比对人员名单
          else if (val.menuId && val.menuId === '80040500') {
            store.set('comparisonPersonnelUrl', {
              comparisonPersonnelUrl: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === '50010006') {
            store.set('refundManageURL', val.menuUrl);
          } else if (val.menuId && val.menuId === '50010005') {
            store.set('refundRecordURL', val.menuUrl);
          } else if (val.menuId && val.menuId === "50020001") {
            //百保盾-培训-等级证管理-人员对比
            store.set('researchersComparedURL', {
              researchersComparedURL: val.menuUrl
            });
          } 
          else if (val.menuId && val.menuId === "50020002") {
            //百保盾-培训-等级证管理-证书管理
            store.set('certificateManaURL', {
              certificateManaURL: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === "50020006") {
            //百保盾-培训-等级证补贴
            store.set('subsidyManagementUrl', {
              subsidyManagementUrl: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === "50020007") {
            //百保盾-培训-等级证人员比对
            store.set('comparison', {
              comparison: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === "50020009") {
            //百保盾-培训-等级证补贴可申请人员名单
            store.set('canComparison', {
              canComparison: val.menuUrl
            });
          }
          else if (val.menuId && val.menuId === "200000000") {
            store.set('salaryUrl', val.menuUrl)
          }
          //驻勤管理--疫情防控
          else if (val.menuId && val.menuId === '40030600') {
            store.set('EpidemicURL', {
              EpidemicURL: val.menuUrl
            });
          } 
          //保安资格证管理--资格证课程学习记录
          else if (val.menuId && val.menuId === '80040600') {
            store.set('QualificationStudyRecordURL', {
              QualificationStudyRecordURL: val.menuUrl
            });
          } 
          //保安等级证管理--等级证课程学习记录
          else if (val.menuId && val.menuId === '50020010') {
            store.set('GradeStudyRecordURL', {
              GradeStudyRecordURL: val.menuUrl
            });
          } 
          //统计调查--保安员离京登记
          else if (val.menuId && val.menuId === '40050200') {
            store.set('RegistrationFromBeijingURL', {
              RegistrationFromBeijingURL: val.menuUrl
            });
          } 
          //统计调查--临勤临保任务登记
          else if (val.menuId && val.menuId === '40050300') {
            store.set('TaskRegistrationURL', {
              TaskRegistrationURL: val.menuUrl
            });
          } 
          //统计调查--保安协会等级评定
          else if (val.menuId && val.menuId === '40050400') {
            store.set('SecurityAssociationURL', {
              SecurityAssociationURL: val.menuUrl
            });
          } 
          // 忽略的菜单列表
          const ignoreList = ['保险方案书'];
          if (ignoreList.join('').indexOf(val.menuName) === -1) {
            menuauth.push(val.menuName);
          }
          // menuauth.push('薪资发放管理','企业发薪账户', '在线薪资代发申请', '线下薪资发放记录');
          // menuauth.push('资格证比对人员名单');
        });
        //临时菜单，上线前注释掉，菜单后端生成，名称需一致（所有菜单名）
        if (process.env.NODE_ENV == 'development'
          || window.location.hostname == 'saasweb.test.baibaodun.cn'
        ) {
          // const temporaryMenuArr = ['等级证补贴人员管理','等级证补贴比对人员名单','等级证补贴可申请人员名单'];
          // menuauth.push('保安协会等级评定');
          // console.log(menuauth)
        }
        this.setState({ menuauth });
      }
      if (menuInfo.length == 0) {
        systemOauthGetUserMenus({}).then(
          response => {
            setMenus(response.data || []);
            // 储存时间用于控制时间控件
            window.sessionStorage.setItem('requestDate', moment(response.date).valueOf());
          },
          err => {
            console.log(err, 'systemOauthGetUserMenus-err-获取用户登陆菜单');
          }
        );
      }else {
        // 从登录页进来以后已经有菜单数据了，不用再次去请求数据
        setTimeout(() => {
          setMenus(menuInfo || []);
        }, 500);
      }
    }
  };
  //获取当前登陆用户账号信息
  systemPerAccountInfoGetUserAccount1 = () => {
    this.props.dispatch({
      type: 'user/fetchCurrent'
    });
  };

  getChildContext() {
    const { location, navData, getRouteData } = this.props;
    const routeData = getRouteData('BasicLayout');
    const firstMenuData = navData.reduce(
      (arr, current) => arr.concat(current.children),
      []
    );
    const menuData = this.getMenuData(firstMenuData, '');
    const breadcrumbNameMap = {};

    routeData.concat(menuData).forEach(item => {
      breadcrumbNameMap[item.path] = {
        name: item.name,
        component: item.component
      };
    });
    return { location, breadcrumbNameMap };
  }

  onCollapse = collapsed => {
    this.props.dispatch({
      type: 'global/changeLayoutCollapsed',
      payload: collapsed
    });
  };
  onMenuClick = ({ key }) => {
    if (key === 'logout') {
      this.logout();
    } else if (key === 'edit') {
      this.showChangePasswordModal();
    }
  };
  logout = () => {
    store.clearAll();
    this.props.dispatch({
      type: 'login/logout'
    });
    //im的退出
    if(this.props.im && this.props.im.isSDKReady){
      tim.logout();
    }
    //华为云视频退出，token数据清空
    if (this.props.client && this.props.client._loginStatus) {
      this.props.client.logout();
      this.props.dispatch({
        type: `client/setLogin`,
        payload: {
          loginStatus: false
        }
      });
      const value = {
        accessToken: null,
        huaweiUserName: null,
        huaweiPassWord: null,
        huaweiSipName: null
      };
      this.props.dispatch({
        type: `client/setMeetingToken`,
        payload: {
          meetingAcc: value
        }
      });
    }
    //如果有防控指挥的窗口，一并关闭
    if(this.state.commandWindow){
      this.state.commandWindow.close()
    }
    this.props.dispatch({
      type: 'global/changeShowSystemNotice',
      payload: false,
    });
    // let promise = tim.logout();
    // promise.then(function(imResponse) {
    //   console.log(imResponse.data); // 登出成功
    // }).catch(function(imError) {
    //   console.warn('logout error:', imError);
    // });
  };
  cancelChangePasswordModal = () => {
    this.setState({
      changePasswordVisible: false
    });
    this.child.clearValue();
  };
  reef = ref => {
    this.child = ref;
  };
  showChangePasswordModal = () => {
    this.setState({
      changePasswordVisible: true
    });
  };
  getMenuData = (data, parentPath) => {
    let arr = [];
    data.forEach(item => {
      if (item.children) {
        arr.push({ path: `${parentPath}/${item.path}`, name: item.name });
        arr = arr.concat(
          this.getMenuData(item.children, `${parentPath}/${item.path}`)
        );
      }
    });
    return arr;
  };
  getDefaultCollapsedSubMenus(props) {
    const currentMenuSelectedKeys = [...this.getCurrentMenuSelectedKeys(props)];
    currentMenuSelectedKeys.splice(-1, 1);
    if (currentMenuSelectedKeys.length === 0) {
      return ['dashboard'];
    }
    return currentMenuSelectedKeys;
  }
  getCurrentMenuSelectedKeys(props) {
    const {
      location: { pathname }
    } = props || this.props;
    const keys = pathname.split('/').slice(1);
    if (keys.length === 1 && keys[0] === '') {
      return [this.menus[0].key];
    }
    return keys;
  }
  getNavMenuItems(menus, parentPath = '') {
    if (!menus) {
      return [];
    }
    let menusData = menus;
    if (!parentPath) {
      menusData = menus.filter(val => {
        return menugroup[this.state.currentGroup].indexOf(val.name) !== -1;
      });
    }

    return menusData.map(item => {
      if (this.state.menuauth.indexOf(item.name) === -1) {
        return null;
      }
      if (!item.name) {
        return null;
      }
      let itemPath;
      if (item.path.indexOf('http') === 0) {
        itemPath = item.path;
      } else {
        itemPath = `${parentPath}/${item.path || ''}`.replace(/\/+/g, '/');
      }
      if (item.children && item.children.some(child => child.name)) {
        return (
          <SubMenu
            title={
              item.icon ? (
                <span>
                  <IconS type={item.icon} />
                  <span>{item.name}</span>
                </span>
              ) : (
                  item.name
                )
            }
            key={item.key || item.path}
          >
            {this.getNavMenuItems(item.children, itemPath)}
          </SubMenu>
        );
      }
      const icon = item.icon && <IconS type={item.icon} />;
      slideMenuPath.push(itemPath);
      return (
        <Menu.Item key={item.key || item.path.split('/')[0]}>
          {/^https?:\/\//.test(itemPath) ? (
            <a href={itemPath} target={item.target}>
              {icon}
              <span>{item.name}</span>
            </a>
          ) : (
              <Link
                to={itemPath}
                target={item.target}
                replace={itemPath === this.props.location.pathname}
              >
                {icon}
                <span>{item.name}</span>
              </Link>
            )}
        </Menu.Item>
      );
    });
  }
  getPageTitle() {
    const { location, getRouteData, companyInfo } = this.props;
    const { pathname } = location;
    // let title = '百保盾企业管理平台';
    let title = domainConfig.getName(companyInfo.regProvince,companyInfo.regCity);
    getRouteData('BasicLayout').forEach(item => {
      // 修改网页title显示
      if (
        item.path === pathname && item.name
      ) {
        title = item.name + '-' + title;
      }
    });
    return title;
  }
  getNoticeData() {
    const { notices = [] } = this.props;
    if (notices.length === 0) {
      return [];
    }

    const newNotices = notices.map(notice => {
      const newNotice = { ...notice };
      //消息接口返回值messageType判空处理
      if (notice.messageType) {
        if (notice.messageType.substr(0, 2) > '07') {
          newNotice.avatar = (
            <IconS
              style={{ fontSize: 34, color: '#8DC9F7' }}
              type="renwutonngzhi1 saas2"
            />
          );
        } else {
          newNotice.avatar = noticeAwars[newNotice.messageType.substr(0, 2)];
        }
      } else {
        newNotice.avatar = (
          <IconS
            style={{ fontSize: 34, color: '#A3DEDE' }}
            type="xitongxinxi1 saas2"
          />
        );
      }
      if (newNotice.datetime) {
        newNotice.datetime = moment(notice.datetime).fromNow();
      }
      // transform id to item key
      if (newNotice.id) {
        newNotice.key = newNotice.id;
      }
      return newNotice;
    });
    return newNotices;
  }

  loginOut = () => {
    if (store.get('saas') === undefined) {
      this.props.dispatch({
        type: 'login/logout'
      });
    }
  };

  mainmenu = key => {
    //登录后是否是否展示内容,默认 欢迎页面
    if (
      store.get('isShowContent') &&
      !store.get('isShowContent')['isShowContent']
    ) {
      store.set('isShowContent', { isShowContent: true });
    }

    slideMenuPath = [];
    this.setState({
      currentGroup: key
    });
    setTimeout(() => {
      this.setState(
        {
          openKeys: this.getDefaultCollapsedSubMenus(this.props)
        },
        () => {
          this.props.history.replace(slideMenuPath[0]);
          // this.props.history.push(slideMenuPath[0]);
        }
      );
    }, 10);
  };

  handleOpenChange = openKeys => {
    const lastOpenKey = openKeys[openKeys.length - 1];
    const isMainMenu = this.menus.some(
      item =>
        lastOpenKey && (item.key === lastOpenKey || item.path === lastOpenKey)
    );
    this.setState({
      openKeys: isMainMenu ? [lastOpenKey] : [...openKeys]
    });
  };
  toggle = () => {
    const { collapsed } = this.props;
    this.props.dispatch({
      type: 'global/changeLayoutCollapsed',
      payload: !collapsed
    });
    this.triggerResizeEvent();
  };

  @Debounce(600)
  triggerResizeEvent() {
    // eslint-disable-line
    const event = document.createEvent('HTMLEvents');
    event.initEvent('resize', true, false);
    window.dispatchEvent(event);
  }
  //原来的清空改成查看所有通知
  handleSearchFor = (type) => {
    // this.props.history.replace('/xiaoxitongzhi/Messages');
    if(type=='message'){
      $nModal({
        title: "我的消息",
        footer: null,
        width: 800,
        content: (
          <ReceiveList basicLayoutDispatch= {this.props.dispatch}/>
        )
      });
    }else if(type == 'notify'){
      $nModal({
        title: "平台通知",
        footer: null,
        width: 800,
        content: (
          <NotifList/>
        )
      });
    }
    
    this.setState({
      popupVisible: false
    });

    //登录后是否是否展示内容,默认 欢迎页面
    if (!store.get('isShowContent')['isShowContent']) {
      store.set('isShowContent', { isShowContent: true });
    }
  };
  //设置所有未读消息为已读（new）s
  handleReadAll = () => {
    const keyId = this.props.notices.map(val => val.id);
    if (this.props.notices.length <= 0) {
      message.success('无未标记消息');
      return;
    }
    updateSelectMessageRead({
      messageJson: JSON.stringify(this.props.notices)
    })
      .then(data => {
        this.props.dispatch({
          type: 'global/fetchNotices'
        });
        // this.props.history.replace('/xiaoxitongzhi/Messages');
        this.setState({
          popupVisible: false
        });

        //登录后是否是否展示内容,默认 欢迎页面
        if (!store.get('isShowContent')['isShowContent']) {
          store.set('isShowContent', { isShowContent: true });
        }
      })
      .catch(err => {
        // console.log('设置为已读失败', err);
        // message.warning('设置为已读失败！' + err);
      });
  };
  handleNoticeVisibleChange = visible => {
    if (visible) {
      this.props.dispatch({
        type: 'global/fetchNotices'
      });
      this.setState({
        popupVisible: true
      });
    } else {
      this.setState({
        popupVisible: false
      });
    }
  };
  render() {
    const {
      currentUser,
      collapsed,
      fetchingNotices,
      getRouteData
    } = this.props;
    const isShowContent = store.get('isShowContent')
      ? store.get('isShowContent')['isShowContent']
      : '';
    currentUser.avatar = currentUser.photoUrl
      ? currentUser.photoUrl
      : defaultAvatar;

    const menu = (
      <Menu
        className={styles.menu}
        selectedKeys={[]}
        onClick={this.onMenuClick}
      >
        <Menu.Item key="edit">
          <Icon type="edit" />
          修改密码
        </Menu.Item>
        <Menu.Divider />
        <Menu.Item key="logout">
          <Icon type="logout" />
          退出登录
        </Menu.Item>
      </Menu>
    );
    const noticeData = this.getNoticeData();
    /**
     * 消息通知右上角弹窗
     */

    if (noticeData.length > 0 && !this.state.noticeIsInit) {
      const hasPoliceNotice = noticeData.some(item => (item.messageType + '').indexOf('050301') != -1);
      if (hasPoliceNotice) {
        const key = new Date().getTime() + '';
        this.setState({
          noticeIsInit: true
        }, () => {
          notification.info({
            placement: 'topRight',
            duration: null,
            key,
            className: 'basic_notice',
            message: <span style={{ color: '#ff4d4f' }}>您有新的公安机关通知，请及时查看！</span>,
            description: <Button style={{ marginTop: 15 }} onClick={() => {
              notification.close(key);
              store.set('isShowContent', { isShowContent: true });
              this.props.history.push('/PoliceDeclare/police-notice');
            }} type="danger">去查看</Button>
          });
        });
      }
    }
    /**
     * 消息通知右上角弹窗end
     */

    // Don't show popup menu when it is been collapsed
    const menuProps = collapsed
      ? {}
      : {
        openKeys: this.state.openKeys
      };

    const __renderTopMenu = (val, index) => {
      // 防空指挥跳转到https地址
      // if (val.to === '/command/prevention-and-control' && store.get('saas')) {
        if (/\/command\//.test(val.to) && store.get('saas')) {
        // return ''
        const hostName = domainConfig.https;
        return (
          // <a href={store.get('saas') ? `${hostName}${val.to}?access_token=${store.get('saas')['access_token']}` : ''} target="_blank" onClick={() => {
          //   // //获取并登录im
          //   this.props.dispatch({
          //     type: `global/imLogin`,
          //     payload: {
          //       username: this.state.userMobilePhone
          //     }
          //   });
          // }}>{val.text}</a>
          <a onClick={() => {
            //利用此方法，让只打开一个新窗口，并记录下防控指挥的打开窗口
            const commandWindow = window.open(store.get('saas') ? `${hostName}${val.to}?access_token=${store.get('saas')['access_token']}` : '', "scrollbars=yes,resizable=1,modal=false,alwaysRaised=yes");
            this.setState({commandWindow})
            //获取并登录im
            this.props.dispatch({
              type: `global/imLogin`,
              payload: {
                username: this.state.userMobilePhone
              }
            });
          }}>{val.text}</a>
        );
      }
      // else if (val.to == '/salary/service') { //薪酬服务
      //   return (
      //     <Link
      //       key={val.to + index}
      //       onClick={async () => {
      //         store.set('isShowContent', { isShowContent: true });
      //         const { thirdSessionId } = store.get('saas');
      //         const url = store.get('salaryUrl');
      //         try{
      //           const isInitRes = await comSalarySyncInitCheckIsInit({});
      //           // 0:代表未完成初始化  1：已完成初始化
      //           if(isInitRes.data == '1') {
      //             if (thirdSessionId && url) {
      //               this.props.history.goBack();
      //               window.open(url + 'loginkey=' + thirdSessionId);
      //             } else {
      //               this.props.history.push(val.to + '?url=' + url);
      //               this.mainmenu(index);
      //             }
      //           }
      //         }catch(ex) {
      //           console.log(ex);
      //           Modal.error({
      //             title:'请求错误',
      //             content:'请稍后重试',
      //             okText: '确定'
      //           });
      //         }
      //       }}
      //       className={
      //         this.state.currentGroup === index ? 'selected' : ''
      //       }
      //       to={val.to}
      //       replace={val.to === this.props.location.pathname}
      //     >
      //       {val.text}
      //     </Link>
      //   );
      // } 
      else if (val.to === '/data/com-statistics') {//数据统计
        return (
          <a href="https://console.huaweicloud.com/dlvapp/screen.html?share=ebc9ddc4aa764c19a85c0f9f8f1e35f2&locale=zh-cn&region=cn-north-1" target="_blank" key={val.to + index}>{val.text}</a>
        );
      } else {
        return (
          <Link
            key={val.to + index}
            onClick={() => {
              if (val.to === '/publicsafety/system') {
                // //获取并登录im
                this.props.dispatch({
                  type: `global/imLogin`,
                  payload: {
                    username: this.state.userMobilePhone
                  }
                });
              }
              this.mainmenu(index);
            }}
            className={
              this.state.currentGroup === index ? 'selected' : ''
            }
            to={val.to}
            replace={val.to === this.props.location.pathname}
          >
            {val.text}
          </Link>
        );
      }
    }
    const layout = (
      <Layout>
        {this.state.isShowIEPrompt && <IEReminder />}
        <Header style={{ display: this.props.tMenu ? 'block' : 'none' }} className={styles.header}>
          <div className={styles.logo}>
            <IconS type="logo-" style={{ cursor: 'pointer' }} onClick={() => {
              window.open('https://ars.baibaodun.cn');
            }} />
            <h1>
              {this.state.topMenu.map((val, index) => {
                if (index === 0) {
                  return (
                    <span key={index}>
                      {store.get('isHasEnterpriseMenu') !== undefined ? (
                        <Link
                          key={val.to + index}
                          onClick={() => {
                            this.mainmenu(index);
                          }}
                          to={val.to}
                          replace={val.to === this.props.location.pathname}
                          title={
                            this.props.companyInfo.comName ||
                            this.state.topMenu[0].text
                          }
                        >
                          {this.props.companyInfo.comName ||
                            this.state.topMenu[0].text}
                        </Link>
                      ) : (
                          <a
                            style={{ cursor: 'default' }}
                            title={
                              this.props.companyInfo.comName ||
                              this.state.topMenu[0].text
                            }
                          >
                            {this.props.companyInfo.comName ||
                              this.state.topMenu[0].text}
                          </a>
                        )}
                    </span>
                  );
                } else {
                  return '';
                }
              })}
              <Icon type="setting" />
            </h1>
          </div>
          <div className={styles.topmenu}>
            {this.state.topMenu.map((val, index) => {
              if (this.state.menuauth.indexOf(val.text) === -1) {
                return null;
              }
              if (index === 0) {
                return '';
              }
              return (
                __renderTopMenu(val, index)
              );
            })}
          </div>

          <div className={styles.right}>
            {/* <HeaderSearch
              className={`${ styles.action } ${ styles.search } `}
              placeholder="站内搜索"
              dataSource={["搜索提示一", "搜索提示二", "搜索提示三"]}
              onSearch={value => {
                console.log("input", value); // eslint-disable-line
              }}
              onPressEnter={value => {
                console.log("enter", value); // eslint-disable-line
              }}
            /> */}
            <span style={{ marginRight: 15, color: '#fff' }}>{domainConfig.getName(this.props.companyInfo.regProvince,this.props.companyInfo.regCity)}</span>
            <NoticeIcon
              className={styles.action}
              count={noticeData.length}
              onItemClick={(item /* tabProps */) => {
                const { messageType } = item;
                if ((messageType + '').indexOf('050301') != -1) {
                  this.props.history.push('/PoliceDeclare/police-notice');
                } else {
                  // this.setState({ record, checkModal: true });
                  this.setState({ record: item, checkModal: true });
                }
              }}
              searchFor={this.handleSearchFor}
              readAll={this.handleReadAll}
              onPopupVisibleChange={this.handleNoticeVisibleChange}
              loading={fetchingNotices}
              popupAlign={{ offset: [20, -16] }}
              popupVisible={this.state.popupVisible}
            >
              <NoticeIcon.Tab
                list={noticeData}
                title="消息"
                emptyText="无未读消息"
                emptyImage="https://gw.alipayobjects.com/zos/rmsportal/wAhyIChODzsoKIOBHcBk.svg"
              />
              {/* <NoticeIcon.Tab
                list={noticeData["消息"]}
                title="消息"
                emptyText="您已读完所有消息"
                emptyImage="https://gw.alipayobjects.com/zos/rmsportal/sAuJeJzSKbUmHfBQRzmZ.svg"
              />
              <NoticeIcon.Tab
                list={noticeData["待办"]}
                title="待办"
                emptyText="你已完成所有待办"
                emptyImage="https://gw.alipayobjects.com/zos/rmsportal/HsIsxMZiWKrNUavQUXqx.svg"
              /> */}
            </NoticeIcon>
            {/*             {currentUser.name ? (
             */}
            <Dropdown overlay={menu}>
              <span className={`${styles.action} ${styles.account} `}>
                <Avatar
                  size="biger"
                  className={styles.avatar}
                  src={currentUser.avatar}
                />
                <span>{currentUser.name}</span>
              </span>
            </Dropdown>
            <span style={{ margin: '0 10px' }}>
              <Icon
                style={{ verticalAlign: 'middle' }}
                type="question-circle-o"
              />
              <span style={{ margin: '0 6px' }}>
                <a
                  style={{ color: '#fff', textDecoration: 'none' }}
                  // href="http://47.93.117.58:8012/view?token=aHR0cDovL2JjeGludmVkaW8ub3NzLWNuLXNoYW5naGFpLmFsaXl1bmNzLmNvbS9wZWl4dW4vc2Fhcy9iYmRzYWFzX2hlbHAucGRm"
                  href="http://wiki.baibaodun.cn/document/indexout?document_id=552"
                  target="_blank"
                >
                  帮助
                </a>
              </span>
            </span>
            {/*   ) : (
              <Spin size="small" style={{ marginLeft: 8 }} />
            )}  */}
          </div>
        </Header>
        {/* {(store.get("isShowContent")["isShowContent"] || this.props.companyInfo.isInit === '0') ? */}

        {isShowContent || this.props.companyInfo.isInit === '0' ? (
          <Layout>
            <Sider
              trigger={null}
              collapsible
              collapsed={collapsed}
              breakpoint="md"
              onCollapse={this.onCollapse}
              width={254}
              className={styles.sider}
              style={{ display: this.props.lMenu ? 'block' : 'none' }}
            >
              <Icon
                className={styles.trigger}
                type={collapsed ? 'menu-unfold' : 'menu-fold'}
                onClick={this.toggle}
              />
              <Menu
                className="sidemenu"
                theme="light"
                mode="inline"
                {...menuProps}
                onOpenChange={this.handleOpenChange}
                selectedKeys={this.getCurrentMenuSelectedKeys()}
                style={{ margin: '16px 0', width: '100%' }}
              >
                {/* 传入前端配置的路由 */}
                {this.getNavMenuItems(this.menus)}
              </Menu>
            </Sider>
            <Content
              className={`layout - content${
                this.getDefaultCollapsedSubMenus(this.props)[0]
                } `}
            >
              <Switch>
                {getRouteData('BasicLayout').map(item => (
                  <Route
                    exact={item.exact}
                    key={item.path}
                    path={item.path}
                    component={item.component}
                  />
                ))}

                {(() => {
                  function RedirectComponent(props) {
                    // 默认重定向到欢饮页面
                    store.set('isShowContent', { isShowContent: false });
                    return (
                      <Redirect
                        {...props}
                      />
                    );
                  }
                  // 如果有组织架构菜单
                  if (this.state.menuauth.indexOf('10020100')) {
                    if (this.props.companyInfo.isInit === '0') {
                      return (
                        <RedirectComponent exact from="/" to="/HomePage/Initialization" />
                      );
                    }
                    if (this.props.companyInfo.isInit === '1') {
                      return (
                        <RedirectComponent
                          exact
                          from="/"
                          to="/"
                        // to="/PersonnelRecruitment/departmentmanagement"
                        />
                      );
                    }
                    if (!(
                      this.props.companyInfo.isInit === '0' ||
                      this.props.companyInfo.isInit === '1'
                    )) {
                      return (<RedirectComponent
                        exact
                        from="/"
                        // to="/PersonnelRecruitment/departmentmanagement"
                        to="/"
                      />);
                    }
                  } else {
                    return (
                      <RedirectComponent exact from="/" to="/HomePage/Initialization" />
                    );
                  }
                })()}
                {/* {this.props.companyInfo.isInit === '0' && (
                  <Redirect exact from="/" to="/HomePage/Initialization" />
                )}
                {this.props.companyInfo.isInit === '1' && (
                  <Redirect
                    exact
                    from="/"
                    to="/PersonnelRecruitment/departmentmanagement"
                  />
                )}
                {!(
                  this.props.companyInfo.isInit === '0' ||
                  this.props.companyInfo.isInit === '1'
                ) && (
                    <Redirect
                      exact
                      from="/"
                      to="/PersonnelRecruitment/departmentmanagement"
                    />
                  )} */}
                <Route component={NotFound} />
              </Switch>

              {
                this.props.footer &&
                <GlobalFooter
                  className="oneKeySearchHidden"
                  copyright={
                    // <div>
                    //   {/* Copyright  */}
                    //   平台运营与技术支持&nbsp;&nbsp;
                    //   <Icon type="copyright" />{' '}
                    //   {new Date().getFullYear()}
                    //   百川信（北京）信息服务有限公司
                    // </div>
                    <div>此平台由百川信（北京）信息服务有限公司开发与运营，产生的问题最终解释权归百川信所有</div>
                  }
                />
              }
            </Content>
          </Layout>
        ) : (
            <Layout style={{ height: 'calc(100vh - 72px)', background: '#fff' }}>
              <Welcome
                ok={() => {
                  this.props.companyInfo.isInit = '1';
                  // this.setState({
                  //   isShowContent:'true'
                  // },()=>{
                  store.set('isShowContent', { isShowContent: true });
                  // });
                  this.props.history.push(`/PoliceDeclare/DeclarationList`);
                }}
              />
              {/* {this.props.companyInfo.isInit === '0' && <Initialization />}
            {this.props.companyInfo.isInit === '1' && <Welcome />}
            {!(
              this.props.companyInfo.isInit === '0' ||
              this.props.companyInfo.isInit === '1'
            ) && <Welcome />} */}
            </Layout>
          )}
        <MessageDetail
          record={this.state.record}
          visible={this.state.checkModal}
          closeModal={() => {
            this.setState({ checkModal: false });
          }}
        />
        <Modal
          width={800}
          title="修改密码"
          visible={this.state.changePasswordVisible}
          onCancel={() => {
            this.cancelChangePasswordModal();
          }}
          footer={null}
        >
          <div>
            <ChangePassword
              reef={this.reef}
              cancelChangePasswordModal={this.cancelChangePasswordModal}
              logout={this.logout}
              mobilePhone={this.props.currentUser.mobilePhone}
            />
          </div>
        </Modal>
      </Layout>
    );

    return (
      <DocumentTitle title={this.getPageTitle()}>
        <ContainerQuery query={query}>
          {params => <div className={classNames(params)}>{layout}</div>}
        </ContainerQuery>
      </DocumentTitle>
    );
  }
}

export default connect(state => ({
  currentUser: state.user.currentUser,
  collapsed: state.global.collapsed,
  fetchingNotices: state.global.fetchingNotices,
  notices: state.global.notices,
  companyInfo: state.global.companyInfo,
  currentKey: state.global.currentKey
}))(BasicLayout);
