#!/bin/bash

# Kafka Broker 地址（替换为你的 Kafka Broker 地址）
BROKER="localhost:9092"
TOPICS=(
"baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_base_info"
"baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_person_info"
"baibaodunflow.binlog-cdc.topic.v2.tlk_goodperson"
"baibaodunflow.binlog-cdc.topic.v2.tlk_punish"
"baibaodunflow.binlog-cdc.topic.v2.tlk_awardk"
"baibaodunflow.binlog-cdc.topic.v2.tlk_jfdevice_2"
"baibaodunflow.binlog-cdc.topic.v2.tlk_vehicle"
"obpm2.binlog-cdc.topic.v2.tenant_contracts"
"baibaodunflow.binlog-cdc.topic.v2.tlk_contracttoenterprise"
"mcs.binlog-cdc.topic.v2.tlk_customerfollow"
"obpm2.binlog-cdc.topic.v2.tenant_organizations"
"obpm2.binlog-cdc.topic.v2.tenant_companies"
"obpm2.binlog-cdc.topic.v2.tenant_departments"
"baibaodunflow.binlog-cdc.topic.v2.tlk_subcompanyinformation"
"baibaodunflow.binlog-cdc.topic.v2.tlk_managementlayer"
"baibaodunflow.binlog-cdc.topic.v2.tlk_shareholderinformation"
"obpm2.binlog-cdc.topic.v2.tenant_user_credentials"
"obpm2.binlog-cdc.topic.v2.tenant_users"
"baibaodunflow.binlog-cdc.topic.v2.tlk_securitymastermanagement"
"obpm2.binlog-cdc.topic.v2.tenant_user_credential_details"
"obpm2.binlog-cdc.topic.v2.tenant_employees"
"obpm2.binlog-cdc.topic.v2.tenant_employee_records"
"companyinfocollect.binlog-cdc.topic.v2.employees"
)

  # 遍历所有 Topic 并创建
  for TOPIC in "${TOPICS[@]}"; do
    echo "Creating topic: $TOPIC"
    ./kafka-topics.sh --create \
      --bootstrap-server $BROKER \
      --topic $TOPIC \
      --partitions 3 \
      --replication-factor 1
  done

  echo "All topics created successfully!"