/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.impls;

import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.event.job.core.domain.utils.DocumentTypeUtil;
import com.bcxin.tenant.data.etc.tasks.components.BinlogRawValue;
import com.bcxin.tenant.data.etc.tasks.components.CustomJdbcAcceptPreparedStatementParameter;
import com.bcxin.tenant.data.etc.tasks.components.CustomJdbcOutputFormatParameterWrapper;
import com.bcxin.tenant.data.etc.tasks.components.DataSourceUtil;
import com.bcxin.tenant.data.etc.tasks.components.builder.DataBuilderAbstract;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CustomJdbcAcceptPreparedStatementParameterImpl
implements CustomJdbcAcceptPreparedStatementParameter {
    private static final Logger logger = LoggerFactory.getLogger(CustomJdbcAcceptPreparedStatementParameterImpl.class);

    @Override
    public void accept(PreparedStatement statement, BinlogRawValue o, CacheProvider cacheProvider, CustomJdbcOutputFormatParameterWrapper paramWrapper) {
        JsonProviderImpl jsonProvider = new JsonProviderImpl();
        Map<String, Object> sourceParams = null;
        StringBuilder trace = new StringBuilder();
        List<int[]> pIndexes = paramWrapper.getParameterIndexes();
        List<String> pNames = paramWrapper.getParameterNames();
        Boolean hasDependencyTable = paramWrapper.getParameterNames().stream().anyMatch(ix -> !ix.toLowerCase().startsWith("before.") && !ix.toLowerCase().startsWith("after."));
        trace.append(String.format("hasDependencyTable=%s;", hasDependencyTable));
        try {
            sourceParams = o.getParameters((JsonProvider)jsonProvider, cacheProvider, (dt, id) -> {
                try {
                    return this.getDocMapFromDb(paramWrapper.getJdbcConnectionOptions(), dt, statement.getConnection(), id);
                }
                catch (Exception ex) {
                    throw new BadEventException(String.format("\u83b7\u53d6\u6570\u636e(dt=%s;id=%s)\u53d1\u751f\u5f02\u5e38", dt, id), ex);
                }
            }, hasDependencyTable);
            Object sourceTable = sourceParams.get("source.table");
            DocumentType documentType = DocumentTypeUtil.translate2CacheableDocumentType((String)String.valueOf(sourceTable));
            if (documentType != null) {
                cacheProvider.expireCache(documentType, String.valueOf(o.getReadyPkId()));
            }
            trace.append(sourceParams == null ? "sourceParams is null " : "sourceParams \u5927\u5c0f=" + String.valueOf(sourceParams.size()));
            for (int index = 0; index < pIndexes.size(); ++index) {
                String fieldName = pNames.get(index);
                trace.append(String.format("fieldName=%s;", fieldName));
                Object fieldValue = this.getFieldValueFromMap(sourceParams, fieldName, null);
                trace.append(String.format("fieldValue=%s;", fieldValue));
                if (sourceTable != null && !String.valueOf(sourceTable).equalsIgnoreCase("tenant_user_credentials") && !String.valueOf(sourceTable).equalsIgnoreCase("tenant_user_credential_details") && fieldValue != null && fieldValue instanceof Date) {
                    Date date = (Date)fieldValue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    if (calendar.get(1) < 1001 || calendar.get(1) >= 9990) {
                        try {
                            logger.error("\u9519\u8bef\u6570\u636e={}\u7684\u65e5\u671f\u4fe1\u606f:{}", (Object)jsonProvider.getJson(sourceParams), (Object)date);
                        }
                        catch (Exception ex) {
                            logger.error("\u65f6\u95f4\u89e3\u6790\u5904\u7406\u5f02\u5e38:{}={}", new Object[]{fieldName, fieldValue, ex});
                        }
                    }
                }
                statement.setObject(index + 1, fieldValue);
            }
        }
        catch (Exception ex) {
            logger.error("v3: \u6267\u884c\u5f52\u96c6\u7684\u65f6\u5019sql={};\u53c2\u6570\u5217\u8868:{};\u8ddf\u8e2a={}", new Object[]{paramWrapper.getSql(), jsonProvider.getJson(pNames), trace, ex});
            throw new BadEventException(ex);
        }
    }

    private Object getFieldValueFromMap(Map<String, Object> sourceParams, String fieldName, String prefix) {
        Optional<String> fieldNameOptional;
        if (StringUtils.hasLength((String)prefix)) {
            fieldName = String.format("%s.%s", prefix, fieldName);
        }
        String finalFieldName = fieldName;
        Object fieldValue = sourceParams.get(fieldName);
        if (fieldValue == null && (fieldNameOptional = sourceParams.keySet().stream().filter(ix -> ix.equalsIgnoreCase(finalFieldName.trim())).findFirst()).isPresent()) {
            fieldValue = sourceParams.get(fieldNameOptional.get());
        }
        if (FlinkConstants.isDateTimeField((String)finalFieldName)) {
            if (fieldValue instanceof Double) {
                fieldValue = Instant.ofEpochMilli((Long)fieldValue);
            } else if (fieldValue instanceof Long) {
                fieldValue = Timestamp.from(Instant.ofEpochMilli((Long)fieldValue));
            } else if (fieldValue instanceof String) {
                try {
                    fieldValue = new Date(DataBuilderAbstract.getTimeValue(fieldName, fieldValue));
                }
                catch (Exception ex) {
                    logger.error("\u83b7\u53d6\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38:{}={}", new Object[]{fieldName, fieldValue, ex});
                }
            }
        }
        if (fieldValue == null && fieldName.contains(".after.")) {
            String replacedFieldName = fieldName.replace("after.", "");
            return this.getFieldValueFromMap(sourceParams, replacedFieldName, prefix);
        }
        return fieldValue;
    }

    private Map<String, String> getDocMapFromDb(JdbcConnectionOptions connectionOptions, DocumentType documentType, Connection connection, String id) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        int retryIndex = 0;
        while (retryIndex < 10) {
            HashMap<String, String> hashMap;
            block21: {
                PreparedStatement statement = connection.prepareStatement(documentType.getFetchSql());
                try {
                    statement.setString(1, id);
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            if (map.isEmpty()) {
                                map.put("dt", documentType.name());
                                map.put("id", id);
                                map.put("datetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            }
                            int columnCount = resultSet.getMetaData().getColumnCount();
                            for (int index = 0; index < columnCount; ++index) {
                                String columnName = resultSet.getMetaData().getColumnLabel(index + 1);
                                Object value = resultSet.getObject(columnName);
                                if (value == null) continue;
                                map.put(columnName, String.valueOf(value));
                            }
                        }
                    }
                    hashMap = map;
                    if (statement == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        if (connectionOptions == null) {
                            throw new BadEventException(String.format("\u627e\u4e0d\u5230\u8fde\u63a5\uff08\u6570\u636esql=%s\uff09\u5bf9\u8c61\u4fe1\u606f:%s;\u5f02\u5e38:%s", documentType.getFetchSql(), ExceptionUtils.getMessage((Throwable)ex), ExceptionUtils.getStackTrace((Throwable)ex)));
                        }
                        connection = DataSourceUtil.getDataSource(connectionOptions.getDriverName(), connectionOptions.getDbURL(), (String)connectionOptions.getUsername().get(), (String)connectionOptions.getPassword().get()).getConnection();
                        if (retryIndex > 5) {
                            throw new BadEventException(String.format("\u65e0\u6cd5\u83b7\u53d6(sql=%s,dt=%s,id=%s)\u6570\u636e\u4fe1\u606f:%s", documentType.getFetchSql(), documentType, id, ex));
                        }
                        ++retryIndex;
                    }
                }
                statement.close();
            }
            return hashMap;
        }
        return map;
    }
}

