/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.tenant.data.etc.tasks.components.builder.BusinessDataBuilder;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TenantContractDataBuilder
extends BusinessDataBuilder {
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        String employeeId = (String)TenantContractDataBuilder.getKeyValue(data = super.build(cacheProvider, data, tableName, dbExtractor), "after.employee_id");
        if (StringUtils.hasLength((String)employeeId)) {
            Map userMap;
            Map employeeMap = cacheProvider.getDocumentFromCache(DocumentType.Employee, employeeId, dbExtractor);
            String tenantUserId = null;
            if (employeeMap != null && employeeMap.size() > 1) {
                for (String hKey : employeeMap.keySet()) {
                    data.put(String.format("employee.%s", hKey), this.formatValue(hKey, (String)employeeMap.get(hKey)));
                    if (!hKey.equalsIgnoreCase("tenant_user_id")) continue;
                    tenantUserId = (String)employeeMap.get(hKey);
                }
            }
            if (StringUtils.hasLength(tenantUserId) && (userMap = cacheProvider.getDocumentFromCache(DocumentType.User, tenantUserId, dbExtractor)) != null && userMap.size() > 1) {
                for (String hKey : userMap.keySet()) {
                    data.put(String.format("user.%s", hKey), this.formatValue(hKey, (String)userMap.get(hKey)));
                }
            }
        }
        return data;
    }
}

