/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.tenant.data.etc.tasks.components.builder.DataBuilderAbstract;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PlatformDataBuilder
extends DataBuilderAbstract {
    private static final Logger logger = LoggerFactory.getLogger(PlatformDataBuilder.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        StringBuilder sb = new StringBuilder();
        if (tableName.equalsIgnoreCase("tenant_user_credential_details")) {
            Object objValue = null;
            try {
                objValue = PlatformDataBuilder.getKeyValue(data, "after.tenant_user_id");
                String tenantUserId = null;
                try {
                    tenantUserId = (String)objValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean isNotMatch = false;
                if (StringUtils.hasLength((String)tenantUserId)) {
                    String certificateType;
                    String beforeCertificateType = (String)PlatformDataBuilder.getKeyValue(data, "before.certificateType");
                    String afterCertificateType = (String)PlatformDataBuilder.getKeyValue(data, "after.certificateType");
                    String string = certificateType = StringUtils.hasLength((String)afterCertificateType) ? afterCertificateType : beforeCertificateType;
                    if (certificateType.equalsIgnoreCase("1") || certificateType.equalsIgnoreCase("2")) {
                        isNotMatch = true;
                        cacheProvider.expireCache(DocumentType.User_Business_Credentials, tenantUserId);
                        String idNum = (String)PlatformDataBuilder.getKeyValue(data, "after.idnum");
                        if (certificateType.equalsIgnoreCase("1") && StringUtils.hasLength((String)idNum)) {
                            cacheProvider.expireCache(DocumentType.ZsbhByIdCardNo, idNum);
                        }
                    }
                }
                if (isNotMatch) return data;
                logger.warn(String.format("TenantUserId(%s)\u4fe1\u606f\u975e\u9884\u671f\u65e0\u6548(id=%s)!", tenantUserId, PlatformDataBuilder.getKeyValue(data, "after.id")));
                return data;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error("\u6570\u636e\u7cfb\u7edf\u5f02\u5e38:{},value={}, \u5f02\u5e38={}", new Object[]{tableName, objValue, ExceptionUtils.getStackTrace((Throwable)ex)});
                throw ex;
            }
        }
        if (!tableName.equalsIgnoreCase("tenant_users")) return data;
        String tenantUserId = (String)PlatformDataBuilder.getKeyValue(data, "after.id");
        Integer beforeCheckedStatus = (Integer)PlatformDataBuilder.getKeyValue(data, "before.checked_status");
        Integer checkedStatus = (Integer)PlatformDataBuilder.getKeyValue(data, "after.checked_status");
        if (checkedStatus != null && (beforeCheckedStatus == null || beforeCheckedStatus.intValue() != checkedStatus.intValue())) {
            data = this.bindUserBusinessData(tenantUserId, data, cacheProvider, dbExtractor);
        }
        sb.append(String.format("tenantUserId=%s", tenantUserId));
        return data;
    }
}

