/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.tenant.data.etc.tasks.components.builder.EmployeeDataBuilder;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class EmployeeRecordDataBuilder
extends EmployeeDataBuilder {
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        Map employee;
        String employeeId = (String)EmployeeRecordDataBuilder.getKeyValue(data, "after.employee_id");
        int afterStatus = (Integer)EmployeeRecordDataBuilder.getKeyValue(data, "after.status");
        int beforeStatus = -1;
        Object bs = EmployeeRecordDataBuilder.getKeyValue(data, "before.status");
        if (bs != null) {
            beforeStatus = (Integer)bs;
        }
        if (!StringUtils.hasLength((String)employeeId)) {
            employeeId = (String)EmployeeRecordDataBuilder.getKeyValue(data, "before.employee_id");
            beforeStatus = (Integer)EmployeeRecordDataBuilder.getKeyValue(data, "before.status");
        }
        if (beforeStatus != afterStatus && (employee = cacheProvider.getDocumentFromCache(DocumentType.Employee, employeeId, dbExtractor)) != null) {
            Optional<String> tenantUserIdOptional;
            Optional<String> organizationKeyOptional = employee.keySet().stream().filter(ix -> ix.equalsIgnoreCase("organization_id")).findFirst();
            if (organizationKeyOptional.isPresent()) {
                data.put("after.organization_id", employee.get(organizationKeyOptional.get()));
            }
            if ((tenantUserIdOptional = employee.keySet().stream().filter(ix -> ix.equalsIgnoreCase("tenant_user_id")).findFirst()).isPresent()) {
                data.put("after.tenant_user_id", employee.get(tenantUserIdOptional.get()));
            }
        }
        return super.build(cacheProvider, data, tableName, dbExtractor);
    }
}

