/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.tenant.data.etc.tasks.components.builder.AttendanceSitePersonDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.BusinessDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.EmployeeRecordDataBuilder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EmployeeDataBuilder
extends BusinessDataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeDataBuilder.class);

    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        data = super.build(cacheProvider, data, tableName, dbExtractor);
        return this.processEmployee(cacheProvider, tableName, data, dbExtractor);
    }

    protected Map<String, Object> processEmployee(CacheProvider cacheProvider, String tableName, Map<String, Object> _parameters, DockMapDbExtractor dbExtractor) {
        Map departmentMap;
        Map userMap;
        String userId = (String)EmployeeDataBuilder.getKeyValue(_parameters, "after.tenant_user_id");
        String employeeId = null;
        employeeId = this instanceof EmployeeRecordDataBuilder ? (String)EmployeeDataBuilder.getKeyValue(_parameters, "after.employee_id") : (this instanceof AttendanceSitePersonDataBuilder ? (String)EmployeeDataBuilder.getKeyValue(_parameters, "after.ITEM_securityId") : (String)EmployeeDataBuilder.getKeyValue(_parameters, "after.id"));
        HashMap<String, String> employeeMap = null;
        if (!tableName.equalsIgnoreCase("tenant_employees")) {
            employeeMap = cacheProvider.getDocumentFromCache(DocumentType.Employee, employeeId, dbExtractor);
        } else if (tableName.equalsIgnoreCase("tenant_employees") && _parameters != null && _parameters.get("after.status").equals(0) && (_parameters.get("before.status") == null || _parameters.get("before.status").equals(1))) {
            employeeMap = new HashMap<String, String>();
            for (String key : _parameters.keySet()) {
                Object value = _parameters.get(key);
                if (value == null) continue;
                employeeMap.put(key, String.valueOf(value));
            }
        }
        String department_id = (String)EmployeeDataBuilder.getKeyValue(_parameters, "after.department_id");
        if (employeeMap != null && !employeeMap.isEmpty()) {
            if (this instanceof EmployeeDataBuilder && !(this instanceof EmployeeRecordDataBuilder) && !(this instanceof AttendanceSitePersonDataBuilder)) {
                Object stationMap;
                if (!employeeMap.containsKey("security_station_id") && (stationMap = cacheProvider.getDocumentFromCache(DocumentType.Employee_Selected_Security_Station, employeeId, dbExtractor)) != null && !stationMap.isEmpty()) {
                    employeeMap.put("security_station_id", (String)stationMap.get("ID"));
                    employeeMap.put("security_station_name", (String)stationMap.get("ITEM_attendanceSiteName"));
                    employeeMap.put("security_supervise_depart_id", (String)stationMap.get("ITEM_officePoliceAddressID"));
                    employeeMap.put("security_supervise_depart_name", (String)stationMap.get("ITEM_officePoliceAddress"));
                    employeeMap.put("security_supervise_depart_id_index", (String)stationMap.get("ITEM_officePoliceIDIndex"));
                }
                _parameters.put("security_station_id", employeeMap.get("security_station_id"));
                _parameters.put("security_station_name", employeeMap.get("security_station_name"));
                _parameters.put("security_supervise_depart_id", employeeMap.get("security_supervise_depart_id"));
                _parameters.put("security_supervise_depart_name", employeeMap.get("security_supervise_depart_name"));
                _parameters.put("security_supervise_depart_id_index", employeeMap.get("security_supervise_depart_id_index"));
            } else {
                department_id = (String)employeeMap.get("department_id");
                for (String hKey : employeeMap.keySet()) {
                    _parameters.put(String.format("employee.%s", hKey), this.formatValue(hKey, (String)employeeMap.get(hKey)));
                }
            }
        }
        if (this instanceof AttendanceSitePersonDataBuilder && !CollectionUtils.isEmpty((Map)employeeMap)) {
            userId = (String)employeeMap.get("tenant_user_id");
        }
        if ((userMap = cacheProvider.getDocumentFromCache(DocumentType.User, userId, dbExtractor)) != null && userMap.size() > 1) {
            boolean checkedStatus = false;
            for (String hKey : userMap.keySet()) {
                _parameters.put(String.format("user.%s", hKey), this.formatValue(hKey, (String)userMap.get(hKey)));
                if (!hKey.equalsIgnoreCase("checked_status") || "0".equalsIgnoreCase((String)userMap.get(hKey))) continue;
                checkedStatus = true;
            }
            Object afterStatus = EmployeeDataBuilder.getKeyValue(_parameters, "after.status");
            Object beforeStatus = EmployeeDataBuilder.getKeyValue(_parameters, "before.status");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Object after_hired_operator_created_time = EmployeeDataBuilder.getKeyValue(_parameters, "after.hired_operator_created_time");
            Object before_hired_operator_created_time = EmployeeDataBuilder.getKeyValue(_parameters, "before.hired_operator_created_time");
            boolean isTimeChanged = false;
            try {
                isTimeChanged = before_hired_operator_created_time == null || after_hired_operator_created_time == null || !dateFormat.format(before_hired_operator_created_time).equalsIgnoreCase(dateFormat.format(after_hired_operator_created_time));
            }
            catch (Exception ex) {
                isTimeChanged = true;
                ex.printStackTrace();
                try {
                    logger.error("\u65f6\u95f4(before={};after={})\u6bd4\u8f83\u53d1\u751f\u5f02\u5e38:{}", new Object[]{before_hired_operator_created_time, after_hired_operator_created_time, ex});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (beforeStatus == null || !String.valueOf(beforeStatus).equalsIgnoreCase(String.valueOf(afterStatus)) || before_hired_operator_created_time == null || after_hired_operator_created_time == null || !dateFormat.format(before_hired_operator_created_time).equalsIgnoreCase(dateFormat.format(after_hired_operator_created_time))) {
                _parameters = this.bindUserBusinessData(userId, _parameters, cacheProvider, dbExtractor);
            }
        }
        if ((departmentMap = cacheProvider.getDocumentFromCache(DocumentType.Department, department_id, dbExtractor)) != null && !departmentMap.isEmpty()) {
            for (String hKey : departmentMap.keySet()) {
                _parameters.put(String.format("department.%s", hKey), this.formatValue(hKey, (String)departmentMap.get(hKey)));
            }
        }
        return _parameters;
    }
}

