/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.tenant.data.etc.tasks.components.builder.AttendanceSiteDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.AttendanceSitePersonDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.BusinessDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.DataBuilderAbstract;
import com.bcxin.tenant.data.etc.tasks.components.builder.EmployeeDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.EmployeeRecordDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.PlatformDataBuilder;
import com.bcxin.tenant.data.etc.tasks.components.builder.TenantContractDataBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DataBuilderDecorator
extends DataBuilderAbstract
implements Serializable {
    public static final String TENANT_USER = "tenant_users";
    public static final String EMPLOYEE_USER = "tenant_employees";
    public static final String TENANT_USER_CREDENTIAL = "tenant_user_credentials";
    public static final String TENANT_CONTRACTS = "tenant_contracts";
    public static final String TENANT_EMPLOYEE_RECORDS = "tenant_employee_records";
    public static final String TLK_ATTENDANCE_SITE_PERSON_INFO = "tlk_attendance_site_person_info";
    public static final String TLK_ATTENDANCE_SITE_BASE_INFO = "tlk_attendance_site_base_info";
    public static final String TENANT_USER_CREDENTIAL_DETAILS = "tenant_user_credential_details";
    private static final String DEFAULT = "DEFAULT";
    private static Map<String, DataBuilderAbstract> _dataBuilderMap = new ConcurrentHashMap<String, DataBuilderAbstract>();
    private static DataBuilderDecorator _instance;

    private DataBuilderDecorator() {
    }

    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        Optional<String> builderSelectedKeyOptional = _dataBuilderMap.keySet().stream().filter(ix -> tableName.equalsIgnoreCase((String)ix)).findFirst();
        if (builderSelectedKeyOptional.isPresent()) {
            return _dataBuilderMap.get(builderSelectedKeyOptional.get()).build(cacheProvider, data, tableName, dbExtractor);
        }
        return _dataBuilderMap.get(DEFAULT).build(cacheProvider, data, tableName, dbExtractor);
    }

    public static DataBuilderDecorator getInstance() {
        if (_instance == null) {
            _instance = new DataBuilderDecorator();
        }
        return _instance;
    }

    static {
        PlatformDataBuilder platformDataBuilder = new PlatformDataBuilder();
        _dataBuilderMap.put(TENANT_USER, platformDataBuilder);
        _dataBuilderMap.put(TENANT_USER_CREDENTIAL, platformDataBuilder);
        _dataBuilderMap.put(TENANT_USER_CREDENTIAL_DETAILS, platformDataBuilder);
        EmployeeDataBuilder employeeDataBuilder = new EmployeeDataBuilder();
        _dataBuilderMap.put(EMPLOYEE_USER, employeeDataBuilder);
        _dataBuilderMap.put(TENANT_EMPLOYEE_RECORDS, new EmployeeRecordDataBuilder());
        _dataBuilderMap.put(TLK_ATTENDANCE_SITE_PERSON_INFO, new AttendanceSitePersonDataBuilder());
        _dataBuilderMap.put(TLK_ATTENDANCE_SITE_BASE_INFO, new AttendanceSiteDataBuilder());
        _dataBuilderMap.put(TENANT_CONTRACTS, new TenantContractDataBuilder());
        _dataBuilderMap.put(DEFAULT, new BusinessDataBuilder());
    }
}

