/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.utils.DebeziumUtil;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.tenant.data.etc.tasks.components.JedisPoolFactory;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class DataBuilderAbstract
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DataBuilderAbstract.class);

    public abstract Map<String, Object> build(CacheProvider var1, Map<String, Object> var2, String var3, DockMapDbExtractor var4);

    protected String getRedisKey(String db, String tableName, String domainId, String id) {
        return JedisPoolFactory.getRedisFormatKey(String.format("%s:%s:%s_%s", db, tableName, domainId, id));
    }

    protected static Object getKeyValue(Map<String, Object> pams, String key) {
        if (pams == null || pams.isEmpty()) {
            return null;
        }
        Optional<String> keyOptional = pams.keySet().stream().filter(ix -> ix.equalsIgnoreCase(key)).findFirst();
        if (!keyOptional.isPresent()) {
            return null;
        }
        return pams.get(keyOptional.get());
    }

    protected DataCoreMeta getDataMeta(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        return new DataCoreMeta(data);
    }

    protected Object formatValue(String nodeKey, String nodeValue) {
        if (!StringUtils.hasLength((String)nodeKey)) {
            return null;
        }
        if (!StringUtils.hasLength((String)nodeValue)) {
            return null;
        }
        if (nodeValue.contains("0000-00-00") || nodeValue.contains("9999-")) {
            nodeValue = null;
        }
        try {
            if (FlinkConstants.isDateTimeField((String)nodeKey)) {
                return new Date(DataBuilderAbstract.getTimeValue(nodeKey, nodeValue));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nodeValue;
    }

    public static long getTimeValue(String key, Object value) {
        if (value == null) {
            return Instant.now().getEpochSecond();
        }
        if (value != null && String.valueOf(value).contains("-")) {
            StringBuilder sb = new StringBuilder();
            try {
                String dateValue = String.valueOf(value);
                sb.append("\u503c=" + dateValue);
                try {
                    String timeStr = dateValue.replace("T", " ").replace("Z", "");
                    if (timeStr.contains(".")) {
                        timeStr = timeStr.substring(0, timeStr.indexOf("."));
                    }
                    if (timeStr.indexOf(":") > 0 && timeStr.indexOf(":") == timeStr.lastIndexOf(":")) {
                        timeStr = timeStr + ":00";
                    }
                    Date dateTime = DateUtils.parseDate((String)timeStr, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                    if (dateValue.endsWith("Z")) {
                        dateTime = DateUtils.addHours((Date)dateTime, (int)8);
                    }
                    return dateTime.getTime();
                }
                catch (Exception ex) {
                    if (dateValue.contains("T")) {
                        return DateUtils.parseDate((String)dateValue.substring(0, dateValue.indexOf("T")), (String[])new String[]{"yyyy-MM-dd"}).getTime();
                    }
                    return DateUtils.parseDate((String)dateValue, (String[])new String[]{"yyyy-MM-dd"}).getTime();
                }
            }
            catch (Exception e) {
                logger.error("\u3010\u5148\u8df3\u8fc7\u3011\u7c7b\u578b\u8f6c\u6362\u5931\u8d25:\u539f\u503c={};key={};\u5f02\u5e38={}", new Object[]{value, key, e.toString() + sb});
                return Instant.now().getEpochSecond();
            }
        }
        try {
            String xValue = String.valueOf(value);
            if (xValue.length() < 8) {
                return DebeziumUtil.translate2ValueInMils((long)Long.parseLong(String.valueOf(value)));
            }
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception ex) {
            return (long)Double.parseDouble(String.valueOf(value));
        }
    }

    protected Map<String, Object> bindUserBusinessData(String userId, Map<String, Object> data, CacheProvider cacheProvider, DockMapDbExtractor dbExtractor) {
        Map userBusinessMap = cacheProvider.getDocumentFromCache(DocumentType.User_Business_Credentials, userId, dbExtractor, 7200);
        if (userBusinessMap != null && userBusinessMap.size() > 1) {
            for (String hKey : userBusinessMap.keySet()) {
                String cValue;
                Object ucValue = this.formatValue(hKey, (String)userBusinessMap.get(hKey));
                if (ucValue == null || (cValue = StringUtils.trimLeadingCharacter((String)StringUtils.trimTrailingCharacter((String)String.valueOf(ucValue).replace(";;", ";"), (char)';'), (char)';')).equalsIgnoreCase(";")) continue;
                data.put(String.format("userCredential.%s", hKey), cValue);
            }
        }
        return data;
    }

    protected static class DataCoreMeta
    implements Serializable {
        private final String dbName;
        private final String tableName;
        private final String domainId;
        private final String id;

        protected DataCoreMeta(Map<String, Object> data) {
            String pId;
            this.dbName = (String)data.get("source.db");
            this.tableName = (String)data.get("source.table");
            Object keyValue = DataBuilderAbstract.getKeyValue(data, "after.id");
            String string = pId = keyValue == null ? null : keyValue.toString();
            if (StringUtils.hasLength((String)pId)) {
                String oId = (String)DataBuilderAbstract.getKeyValue(data, "after.domainid");
                if (!StringUtils.hasLength((String)oId)) {
                    oId = (String)DataBuilderAbstract.getKeyValue(data, "after.organization_id");
                }
                this.domainId = oId;
                this.id = String.valueOf(DataBuilderAbstract.getKeyValue(data, "after.id"));
            } else {
                String oId = (String)DataBuilderAbstract.getKeyValue(data, "before.domainid");
                if (!StringUtils.hasLength((String)oId)) {
                    oId = (String)DataBuilderAbstract.getKeyValue(data, "before.organization_id");
                }
                this.domainId = oId;
                this.id = (String)DataBuilderAbstract.getKeyValue(data, "before.id");
            }
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public String getId() {
            return this.id;
        }
    }
}

