/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class TableMapSnapshot
implements Serializable {
    private String tableName;
    private Collection<Column> columns;
    private String sqlMapping;
    private boolean autoMap;

    public void addColumn(String fieldName, Object defaultValue) {
        Collection<Column> tmpColumns = this.getColumns();
        if (tmpColumns == null) {
            tmpColumns = new ArrayList<Column>();
            this.setColumns(tmpColumns);
        }
        tmpColumns.add(Column.add(fieldName, defaultValue));
    }

    public void addColumnWithFixedValue(String fieldName, Object fixedValue) {
        Collection<Column> tmpColumns = this.getColumns();
        if (tmpColumns == null) {
            tmpColumns = new ArrayList<Column>();
            this.setColumns(tmpColumns);
        }
        Column column = Column.add(fieldName, fixedValue);
        column.setFixedValue(fixedValue);
        tmpColumns.add(column);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public String getSqlMapping() {
        return this.sqlMapping;
    }

    public boolean isAutoMap() {
        return this.autoMap;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumns(Collection<Column> columns) {
        this.columns = columns;
    }

    public void setSqlMapping(String sqlMapping) {
        this.sqlMapping = sqlMapping;
    }

    public void setAutoMap(boolean autoMap) {
        this.autoMap = autoMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMapSnapshot)) {
            return false;
        }
        TableMapSnapshot other = (TableMapSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoMap() != other.isAutoMap()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Collection<Column> this$columns = this.getColumns();
        Collection<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$sqlMapping = this.getSqlMapping();
        String other$sqlMapping = other.getSqlMapping();
        return !(this$sqlMapping == null ? other$sqlMapping != null : !this$sqlMapping.equals(other$sqlMapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableMapSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoMap() ? 79 : 97);
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Collection<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $sqlMapping = this.getSqlMapping();
        result = result * 59 + ($sqlMapping == null ? 43 : $sqlMapping.hashCode());
        return result;
    }

    public String toString() {
        return "TableMapSnapshot(tableName=" + this.getTableName() + ", columns=" + this.getColumns() + ", sqlMapping=" + this.getSqlMapping() + ", autoMap=" + this.isAutoMap() + ")";
    }

    public static class Column
    implements Serializable {
        private String fieldName;
        private Object defaultValue;
        private Object fixedValue;
        private boolean onlyForNew;

        public static Column add(String fieldName, Object defaultValue) {
            Column column = new Column();
            column.setFieldName(fieldName);
            column.setDefaultValue(defaultValue);
            return column;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Object getFixedValue() {
            return this.fixedValue;
        }

        public boolean isOnlyForNew() {
            return this.onlyForNew;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setFixedValue(Object fixedValue) {
            this.fixedValue = fixedValue;
        }

        public void setOnlyForNew(boolean onlyForNew) {
            this.onlyForNew = onlyForNew;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOnlyForNew() != other.isOnlyForNew()) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Object this$fixedValue = this.getFixedValue();
            Object other$fixedValue = other.getFixedValue();
            return !(this$fixedValue == null ? other$fixedValue != null : !this$fixedValue.equals(other$fixedValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Column;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOnlyForNew() ? 79 : 97);
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Object $fixedValue = this.getFixedValue();
            result = result * 59 + ($fixedValue == null ? 43 : $fixedValue.hashCode());
            return result;
        }

        public String toString() {
            return "TableMapSnapshot.Column(fieldName=" + this.getFieldName() + ", defaultValue=" + this.getDefaultValue() + ", fixedValue=" + this.getFixedValue() + ", onlyForNew=" + this.isOnlyForNew() + ")";
        }
    }
}

