/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.tenant.data.etc.tasks.components.DataSourceUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleDataSourceJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final JdbcConnectionOptions jdbcOptions;
    private transient Connection connection;
    private String prefixMessage = System.getProperty("ENV").concat(".").concat(System.getProperty("CONFIG_FILE"));

    public SimpleDataSourceJdbcConnectionProvider(JdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnectionValid() throws SQLException {
        return this.connection != null && this.connection.isValid(this.jdbcOptions.getConnectionCheckTimeoutSeconds());
    }

    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        this.connection = this.getDataSource(this.jdbcOptions).getConnection();
        return this.connection;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.warn("JDBC connection close failed.", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.closeConnection();
        return this.getOrEstablishConnection();
    }

    protected DataSource getDataSource(JdbcConnectionOptions jdbcOptions) {
        DataSource dataSource = DataSourceUtil.getDataSource(jdbcOptions.getDriverName(), jdbcOptions.getDbURL(), (String)jdbcOptions.getUsername().get(), (String)jdbcOptions.getPassword().get());
        return dataSource;
    }
}

