/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolFactory
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(JedisPoolFactory.class);
    private static JedisPool jedisPool;
    private static JedisPoolFactory jedisPoolFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JedisPool getJedisPoolInstance(RedisConfig redisConfig) {
        if (jedisPool != null) {
            return jedisPool;
        }
        Class<JedisPoolFactory> clazz = JedisPoolFactory.class;
        synchronized (JedisPoolFactory.class) {
            if (jedisPool == null) {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(100);
                config.setMinIdle(2);
                config.setMaxWait(Duration.of(20L, ChronoUnit.SECONDS));
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimout(), redisConfig.getPassword());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jedisPool;
        }
    }

    public Jedis getDefaultJedis(RedisConfig config) {
        Jedis jedis = JedisPoolFactory.getJedisPoolInstance(config).getResource();
        jedis.select(3);
        this.logger.error("\u521b\u5efaRedisJedis\u5b9e\u4f8b\u5bf9\u8c61");
        return jedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JedisPoolFactory getInstance() {
        if (jedisPoolFactory == null) {
            jedisPoolFactory = new JedisPoolFactory();
        }
        Class<JedisPoolFactory> clazz = JedisPoolFactory.class;
        synchronized (JedisPoolFactory.class) {
            if (jedisPoolFactory == null) {
                jedisPoolFactory = new JedisPoolFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jedisPoolFactory;
        }
    }

    public static String getRedisFormatKey(String businessKey) {
        return String.format("flink:cdc:%s", businessKey);
    }
}

