/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;

public class JdbcParameterWrapper
implements Serializable {
    private List<int[]> parameterIndexes;
    private List<String> parameterNames;
    private String sql;
    private String originalSql;
    private Map<Integer, Tuple2<Integer, String>> parameterAscIndexNameMap = null;

    public Map<Integer, Tuple2<Integer, String>> getParameterAscIndexNameMap() {
        if (this.parameterAscIndexNameMap == null || this.parameterAscIndexNameMap.isEmpty()) {
            this.parameterAscIndexNameMap = new HashMap<Integer, Tuple2<Integer, String>>();
            List sortedParIndexes = this.parameterIndexes.stream().sorted((r1, r2) -> r1[0] < r2[0] ? -1 : 1).collect(Collectors.toList());
            int index = 0;
            for (int[] item : sortedParIndexes) {
                String fieldName = this.originalSql.substring(item[0], item[1]).substring(1);
                this.parameterAscIndexNameMap.put(item[0], (Tuple2<Integer, String>)Tuple2.of((Object)index, (Object)fieldName));
                ++index;
            }
        }
        return this.parameterAscIndexNameMap;
    }

    public static JdbcParameterWrapper create(String originalSql, String sql, List<int[]> parameterIndexes, List<String> parameterNames) {
        JdbcParameterWrapper wrapper = new JdbcParameterWrapper();
        wrapper.setParameterNames(parameterNames);
        wrapper.setParameterIndexes(parameterIndexes);
        wrapper.setSql(sql);
        wrapper.setOriginalSql(originalSql);
        return wrapper;
    }

    public List<int[]> getParameterIndexes() {
        return this.parameterIndexes;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getSql() {
        return this.sql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public void setParameterIndexes(List<int[]> parameterIndexes) {
        this.parameterIndexes = parameterIndexes;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setOriginalSql(String originalSql) {
        this.originalSql = originalSql;
    }

    public void setParameterAscIndexNameMap(Map<Integer, Tuple2<Integer, String>> parameterAscIndexNameMap) {
        this.parameterAscIndexNameMap = parameterAscIndexNameMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcParameterWrapper)) {
            return false;
        }
        JdbcParameterWrapper other = (JdbcParameterWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<int[]> this$parameterIndexes = this.getParameterIndexes();
        List<int[]> other$parameterIndexes = other.getParameterIndexes();
        if (this$parameterIndexes == null ? other$parameterIndexes != null : !((Object)this$parameterIndexes).equals(other$parameterIndexes)) {
            return false;
        }
        List<String> this$parameterNames = this.getParameterNames();
        List<String> other$parameterNames = other.getParameterNames();
        if (this$parameterNames == null ? other$parameterNames != null : !((Object)this$parameterNames).equals(other$parameterNames)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$originalSql = this.getOriginalSql();
        String other$originalSql = other.getOriginalSql();
        if (this$originalSql == null ? other$originalSql != null : !this$originalSql.equals(other$originalSql)) {
            return false;
        }
        Map<Integer, Tuple2<Integer, String>> this$parameterAscIndexNameMap = this.getParameterAscIndexNameMap();
        Map<Integer, Tuple2<Integer, String>> other$parameterAscIndexNameMap = other.getParameterAscIndexNameMap();
        return !(this$parameterAscIndexNameMap == null ? other$parameterAscIndexNameMap != null : !((Object)this$parameterAscIndexNameMap).equals(other$parameterAscIndexNameMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcParameterWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<int[]> $parameterIndexes = this.getParameterIndexes();
        result = result * 59 + ($parameterIndexes == null ? 43 : ((Object)$parameterIndexes).hashCode());
        List<String> $parameterNames = this.getParameterNames();
        result = result * 59 + ($parameterNames == null ? 43 : ((Object)$parameterNames).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $originalSql = this.getOriginalSql();
        result = result * 59 + ($originalSql == null ? 43 : $originalSql.hashCode());
        Map<Integer, Tuple2<Integer, String>> $parameterAscIndexNameMap = this.getParameterAscIndexNameMap();
        result = result * 59 + ($parameterAscIndexNameMap == null ? 43 : ((Object)$parameterAscIndexNameMap).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcParameterWrapper(parameterIndexes=" + this.getParameterIndexes() + ", parameterNames=" + this.getParameterNames() + ", sql=" + this.getSql() + ", originalSql=" + this.getOriginalSql() + ", parameterAscIndexNameMap=" + this.getParameterAscIndexNameMap() + ")";
    }
}

