/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.tenant.data.etc.tasks.components.TableMapSnapshot;
import com.mysql.cj.jdbc.Driver;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class JdbcMetaUtil
implements Serializable {
    private static Map<String, TableMapSnapshot> tableUpsetStatementMap = new ConcurrentHashMap<String, TableMapSnapshot>();

    public static TableMapSnapshot getTableUpsetStatement(String driverClassName, String url, String userName, String password, String tableName) {
        TableMapSnapshot tableMapSnapshot;
        block19: {
            if (tableUpsetStatementMap.containsKey(tableName)) {
                return tableUpsetStatementMap.get(tableName);
            }
            Properties properties = System.getProperties();
            properties.setProperty("datasource.driver-class-name", driverClassName);
            properties.setProperty("datasource.url", url);
            properties.setProperty("datasource.username", userName);
            properties.setProperty("datasource.password", password);
            Connection connection = JdbcMetaUtil.getConnection();
            try {
                TableMapSnapshot snapshot = new TableMapSnapshot();
                String pingSql = String.format("select * from %s where 1<>1 limit 1", tableName);
                StringBuilder upsetClare = new StringBuilder();
                try (Statement pingStatement = connection.createStatement();){
                    ResultSet resultSet = pingStatement.executeQuery(pingSql);
                    StringBuilder insertColumNames = new StringBuilder();
                    StringBuilder insertValueColumNames = new StringBuilder();
                    StringBuilder upsetColumn = new StringBuilder();
                    for (int columnIndex = 0; columnIndex < resultSet.getMetaData().getColumnCount(); ++columnIndex) {
                        String columName = resultSet.getMetaData().getColumnName(columnIndex + 1);
                        snapshot.addColumn(columName, null);
                        if (insertColumNames.length() > 0) {
                            insertColumNames.append(",");
                            insertValueColumNames.append(",");
                        }
                        insertColumNames.append(columName);
                        insertValueColumNames.append(String.format(":%s", columName));
                        if (columName.equalsIgnoreCase("id")) continue;
                        if (upsetColumn.length() > 0) {
                            upsetColumn.append(",");
                        }
                        upsetColumn.append(String.format("%s=:%s", columName, columName));
                    }
                    upsetClare.append(String.format("INSERT INTO %s (%s) values(%s) ON DUPLICATE KEY  UPDATE %s", tableName, insertColumNames, insertValueColumNames, upsetColumn));
                    snapshot.setSqlMapping(upsetClare.toString());
                    snapshot.setTableName(tableName);
                    snapshot.setAutoMap(true);
                }
                tableUpsetStatementMap.put(tableName, snapshot);
                tableMapSnapshot = snapshot;
                if (connection == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return tableMapSnapshot;
    }

    public static Connection getConnection() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String driverClassName = System.getProperties().getProperty("datasource.driver-class-name");
        String url = System.getProperties().getProperty("datasource.url");
        String userName = System.getProperties().getProperty("datasource.username");
        String password = System.getProperties().getProperty("datasource.password");
        Class<?> driverClass = JdbcMetaUtil.class.getClassLoader().loadClass(driverClassName);
        Driver driver = (Driver)driverClass.newInstance();
        DriverManager.registerDriver((java.sql.Driver)driver);
        return DriverManager.getConnection(url, userName, password);
    }
}

