/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.event.core.exceptions.BadEventException;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceUtil {
    private static Logger logger = LoggerFactory.getLogger(DataSourceUtil.class);
    private static volatile Map<String, DataSource> dataSourceMapContainer = new ConcurrentHashMap<String, DataSource>();

    public static DataSource getDataSource(String driveClassName, String url, String username, String password) {
        String dbKey = String.format("%s-%s-%s", driveClassName, url, username);
        if (dataSourceMapContainer.containsKey(dbKey)) {
            return dataSourceMapContainer.get(dbKey);
        }
        Class<DataSourceUtil> clazz = DataSourceUtil.class;
        synchronized (DataSourceUtil.class) {
            if (dataSourceMapContainer.containsKey(dbKey)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return dataSourceMapContainer.get(dbKey);
            }
            try {
                HikariDataSource dataSource = new HikariDataSource();
                dataSource.setDriverClassName(driveClassName);
                if (url.contains("rewriteBatchedStatements")) {
                    dataSource.setJdbcUrl(url);
                } else {
                    dataSource.setJdbcUrl(String.format("%s&rewriteBatchedStatements=true", url));
                }
                url = String.format("%s&sessionVariables=sql_mode='STRICT_ALL_TABLES'&testWhileIdle=true", url);
                dataSource.setUsername(username);
                dataSource.setPassword(password);
                dataSource.setAutoCommit(false);
                dataSource.setConnectionTimeout(260000L);
                dataSource.setIdleTimeout(20000L);
                dataSource.addDataSourceProperty("autoReconnect", (Object)true);
                dataSource.setMaxLifetime(1800000L);
                dataSource.setMaximumPoolSize(2000);
                dataSource.setMinimumIdle(10);
                dataSource.setPoolName("event-hikari");
                dataSourceMapContainer.put(dbKey, (DataSource)dataSource);
                logger.warn("V3-\u521b\u5efaDataSource:dbKey={},ds.hash={}", (Object)dbKey, (Object)dataSource.hashCode());
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return dataSource;
            }
            catch (Exception ex) {
                logger.error("\u521d\u59cb\u5316DruidDataSource({})\u6570\u636e\u6e90\u53d1\u751f\u5f02\u5e38:{}", (Object)url, (Object)ex);
                throw new BadEventException(ex);
            }
        }
    }
}

