/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.exceptions.AffectedEventException;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.RetryEventException;
import com.bcxin.event.core.exceptions.SkipRetryEventException;
import com.bcxin.event.core.utils.RetryUtil;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import com.bcxin.event.job.core.domain.impls.CacheProviderImpl;
import com.bcxin.tenant.data.etc.tasks.components.BinlogRawValue;
import com.bcxin.tenant.data.etc.tasks.components.CustomJdbcAcceptPreparedStatementParameter;
import com.bcxin.tenant.data.etc.tasks.components.CustomJdbcOutputFormatParameterWrapper;
import com.bcxin.tenant.data.etc.tasks.components.DataSourceUtil;
import com.bcxin.tenant.data.etc.tasks.components.KafkaOutputFormat;
import com.bcxin.tenant.data.etc.tasks.dtos.DtqRecordDto;
import java.io.IOException;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import scala.collection.mutable.StringBuilder;

public class CustomJdbcOutputFormat
extends JdbcOutputFormat
implements Serializable,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CustomJdbcOutputFormat.class);
    private final JdbcConnectionOptions jdbcConnectionOptions;
    private volatile DataSource dataSource;
    private final List<Object> batch;
    private final CustomJdbcAcceptPreparedStatementParameter acceptPreparedStatementParameter;
    private final String sql;
    private final JdbcExecutionOptions executionOptions;
    private transient ScheduledExecutorService scheduler;
    private final String bootstrapServer;
    private final RedisConfig redisConfig;
    private final Collection<String> batchOrConditionExpress;
    private transient ScheduledFuture<?> scheduledFuture;
    private transient KafkaOutputFormat kafkaOutputFormat;
    private final CustomJdbcOutputFormatParameterWrapper parameterWrapper;
    private transient CacheProvider cacheProvider;

    public CustomJdbcOutputFormat(Collection<String> batchOrConditionExpress, @Nonnull JdbcConnectionOptions jdbcConnectionOptions, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull JdbcOutputFormat.StatementExecutorFactory statementExecutorFactory, @Nonnull String sql, @Nonnull String bootstrapServer, RedisConfig redisConfig, CustomJdbcOutputFormatParameterWrapper parameterWrapper, CustomJdbcAcceptPreparedStatementParameter acceptPreparedStatementParameter, @Nonnull JdbcOutputFormat.RecordExtractor recordExtractor) {
        super((JdbcConnectionProvider)new SimpleJdbcConnectionProvider(jdbcConnectionOptions), executionOptions, statementExecutorFactory, recordExtractor);
        this.batchOrConditionExpress = batchOrConditionExpress;
        this.jdbcConnectionOptions = jdbcConnectionOptions;
        this.batch = new ArrayList<Object>();
        this.sql = sql;
        this.acceptPreparedStatementParameter = acceptPreparedStatementParameter;
        this.parameterWrapper = parameterWrapper;
        this.executionOptions = executionOptions;
        this.bootstrapServer = bootstrapServer;
        this.redisConfig = redisConfig;
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.dataSource = DataSourceUtil.getDataSource(this.jdbcConnectionOptions.getDriverName(), this.jdbcConnectionOptions.getDbURL(), (String)this.jdbcConnectionOptions.getUsername().get(), (String)this.jdbcConnectionOptions.getPassword().get());
        this.kafkaOutputFormat = new KafkaOutputFormat(this.bootstrapServer, KafkaConstants.getDtqTopic((String)"jdbc_consumer_error"), 100, 5000);
        this.kafkaOutputFormat.open(taskNumber, numTasks);
        if (this.executionOptions.getBatchIntervalMs() != 0L && this.executionOptions.getBatchSize() != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                Class<CustomJdbcOutputFormat> clazz = CustomJdbcOutputFormat.class;
                synchronized (CustomJdbcOutputFormat.class) {
                    try {
                        this.flush();
                    }
                    catch (Exception e) {
                        logger.error("scheduleWithFixedDelay.flush\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    }
                    return;
                }
            }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
        }
        this.cacheProvider = new CacheProviderImpl(this.redisConfig);
    }

    public synchronized void flush() throws IOException {
        super.flush();
    }

    public synchronized void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.cacheProvider != null) {
            this.cacheProvider.close();
        }
    }

    public Connection getConnection() {
        return null;
    }

    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToBatch(Object original, Object extracted) throws SQLException {
        List<Object> list = this.batch;
        synchronized (list) {
            this.batch.add(extracted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void attemptFlush() throws SQLException {
        if (!this.batch.isEmpty()) {
            String tranId;
            ArrayList<BinlogRawValue> matchRawValues;
            StopWatch stopWatch;
            StringBuilder cost;
            block24: {
                int expectedSize;
                cost = new StringBuilder();
                int actualSize = expectedSize = this.batch.size();
                cost.append(String.format("v3-\u5f53\u524dbatch\u7684\u6570\u636e\u91cf=%s;", expectedSize));
                stopWatch = new StopWatch();
                matchRawValues = new ArrayList<BinlogRawValue>();
                JsonProviderImpl jsonProvider = new JsonProviderImpl();
                String lasExpression = null;
                ArrayList<BinlogRawValue> notMatchRawValues = new ArrayList<BinlogRawValue>();
                List<Object> list = this.batch;
                synchronized (list) {
                    actualSize = this.batch.size();
                    for (Object r : this.batch) {
                        BinlogRawValue rawValue = (BinlogRawValue)r;
                        boolean isMatchExecuteExpress = rawValue.isMatchCondition((JsonProvider)jsonProvider, this.batchOrConditionExpress);
                        if (isMatchExecuteExpress) {
                            matchRawValues.add(rawValue);
                            continue;
                        }
                        lasExpression = rawValue.getConditionExecuteResult();
                        matchRawValues.add(rawValue);
                        notMatchRawValues.add(rawValue);
                    }
                    this.batch.clear();
                }
                tranId = UUID.randomUUID().toString();
                stopWatch.start();
                logger.error("{}-\u5f00\u59cbJDBC\u64cd\u4f5c[(matchRawValues.size={}, batchSize={}), ({}) actualSize={}, expectedSize={}], [nomatch={},ids=[{}]]", new Object[]{tranId, matchRawValues.size(), this.batch.size(), actualSize != expectedSize || this.batch.size() > 0 ? "\u9884\u8b66\u6570\u636e\u8282\u70b9" : "\u6b63\u5e38", actualSize, expectedSize, notMatchRawValues.stream().map(ii -> ii.getFullTable()).distinct().collect(Collectors.joining(",")), notMatchRawValues.stream().map(ii -> ii.getId()).distinct().collect(Collectors.joining(","))});
                if (!matchRawValues.isEmpty()) {
                    try {
                        RetryUtil.execute(() -> {
                            try (Connection connection = this.dataSource.getConnection();){
                                connection.setAutoCommit(false);
                                try {
                                    String trace = this.executeSql(tranId, connection, matchRawValues);
                                    cost.append(trace);
                                    connection.commit();
                                }
                                catch (BatchUpdateException ex) {
                                    connection.rollback();
                                    throw new BadEventException(String.format("\u6267\u884c\u811a\u672c\u53d1\u751f\u5f02\u5e38:%s", new Object[]{ex.getUpdateCounts()}), (Exception)ex);
                                }
                                catch (Exception ex) {
                                    connection.rollback();
                                    throw ex;
                                }
                            }
                            return true;
                        }, (int)5);
                    }
                    catch (AffectedEventException ex) {
                        RetryUtil.execute(() -> {
                            String retrySql = ex.getParseSql().replace("'[[@step1@]]'", "'[[@step2@]]'");
                            try (Connection connection = this.dataSource.getConnection();){
                                int affectedCount = 0;
                                connection.setAutoCommit(false);
                                try {
                                    try (PreparedStatement statement = connection.prepareStatement(retrySql);){
                                        affectedCount = statement.executeUpdate();
                                    }
                                    connection.commit();
                                }
                                catch (Exception ee) {
                                    try {
                                        connection.rollback();
                                        throw ee;
                                    }
                                    catch (Throwable throwable) {
                                        logger.error("{}-[{}]v2.\u91cd\u8bd5\u4e4b\u540e\u7684\u903b\u8f91:affectedCount={};dbTable={},ids={},sql={}", new Object[]{tranId, affectedCount > 0 ? "Success" : "dbCheck", affectedCount, ex.getDbTable(), ex.getIds(), retrySql});
                                        throw throwable;
                                    }
                                }
                                logger.error("{}-[{}]v2.\u91cd\u8bd5\u4e4b\u540e\u7684\u903b\u8f91:affectedCount={};dbTable={},ids={},sql={}", new Object[]{tranId, affectedCount > 0 ? "Success" : "dbCheck", affectedCount, ex.getDbTable(), ex.getIds(), retrySql});
                            }
                            return true;
                        }, (int)2);
                    }
                    break block24;
                }
                cost.append(String.format("\u603b\u5171\u6709%s/%s\u6761\u6570\u636e\u4e0d\u7b26\u5408condition\u6761\u4ef6[lasExpression=%s];", this.batch.size() - matchRawValues.size(), this.batch.size(), lasExpression));
            }
            try {
                stopWatch.stop();
                cost.append(String.format("\u603b\u5171\u8017\u65f6=%s ms", stopWatch.getTotalTimeMillis()));
            }
            finally {
                logger.info(cost.toString());
            }
            catch (Exception ex) {
                try {
                    logger.error("{}-v2.\u4e8b\u52a1\u6267\u884c\u53d1\u751f\u5f02\u5e38", (Object)tranId, (Object)ex);
                    try {
                        String businessIds = matchRawValues.stream().map(ii -> String.format("'%s'", ii.getId())).distinct().collect(Collectors.joining(","));
                        String dbTableName = matchRawValues.stream().map(ii -> String.format("%s#%s", ii.getFullTable(), ii.getPartition())).distinct().collect(Collectors.joining(","));
                        this.logError2Db(String.format("%s-\u4e8b\u52a1\u6267\u884c\u53d1\u751f\u5f02\u5e38(%s)", tranId, this.sql), matchRawValues.size(), ex, businessIds, dbTableName);
                    }
                    catch (Exception ee) {
                        logger.error("\u6267\u884clogError2Db\u53d1\u751f\u5f02\u5e38", (Throwable)ee);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        stopWatch.stop();
                        cost.append(String.format("\u603b\u5171\u8017\u65f6=%s ms", stopWatch.getTotalTimeMillis()));
                    }
                    finally {
                        logger.info(cost.toString());
                    }
                    throw throwable;
                }
                try {
                    stopWatch.stop();
                    cost.append(String.format("\u603b\u5171\u8017\u65f6=%s ms", stopWatch.getTotalTimeMillis()));
                }
                finally {
                    logger.info(cost.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeSql(String tranId, Connection connection, Collection<BinlogRawValue> valueWrappers) throws SQLException {
        StringBuilder sb;
        block22: {
            boolean isExecutable = false;
            StopWatch topWatch = new StopWatch();
            topWatch.start();
            sb = new StringBuilder();
            String affectedCountDesc = null;
            StringBuilder batchPlainSql = new StringBuilder();
            try (PreparedStatement statement = connection.prepareStatement(this.sql);){
                boolean isSuccess;
                block23: {
                    StopWatch topStopWatch = new StopWatch();
                    topStopWatch.start("\u51c6\u5907\u53c2\u6570\u4fe1\u606f");
                    sb.append(String.format("\u6267\u884c\u7684\u8868\u8fbe\u5f0f:%s;", CollectionUtils.isEmpty(this.batchOrConditionExpress) ? "NULL" : this.batchOrConditionExpress.stream().collect(Collectors.joining(";"))));
                    StringBuilder paramSb = new StringBuilder();
                    for (BinlogRawValue o : valueWrappers) {
                        try {
                            StopWatch stopWatch = new StopWatch();
                            stopWatch.start("\u622a\u53d6\u5bf9\u8c61\u7684\u503c\u4fe1\u606f");
                            this.acceptPreparedStatementParameter.accept(statement, o, this.cacheProvider, this.parameterWrapper);
                            stopWatch.stop();
                            batchPlainSql.append(String.format("%s;", this.extractPlainSql(statement)));
                            statement.addBatch();
                            isExecutable = true;
                            paramSb.append(String.format("%s,", o.getReadyPkId()));
                        }
                        catch (Exception ex) {
                            try {
                                String dbName = (String)o.getReadyParameter("source.db");
                                String tableName = (String)o.getReadyParameter("source.table");
                                String id = String.valueOf(o.getReadyPkId());
                                logger.error("\u8ddf\u8e2a\uff1a\u6570\u636eid={}\uff0c\u8868\u540d={},\u6dfb\u52a0\u5931\u8d25", (Object)id, (Object)tableName);
                                this.kafkaOutputFormat.writeRecord(DtqRecordDto.create(dbName, tableName, id, new String(o.getValue())));
                                sb.append(String.format("\u53ef\u5ffd\u7565: \u8df3\u8fc7\u5f02\u5e38\u5e76\u52a0\u5165\u6b7b\u4fe1\u961f\u5217: \u65e0\u6548\u7684jdbc\u53c2\u6570\u4fe1\u606f; \u5bfc\u81f4\u8be5\u6570\u636e\u65e0\u6cd5\u6b63\u5e38\u66f4\u65b0\u5230db:%s", ex.toString()));
                            }
                            catch (Exception ee) {
                                sb.append(String.format("\u6d88\u606f(%s)\u63a8\u9001\u5230\u6b7b\u4fe1\u961f\u5217\u53d1\u751f\u5931\u8d25:%s", new String(o.getValue()), ee.toString()));
                            }
                        }
                    }
                    topStopWatch.stop();
                    sb.append(String.format("\u53c2\u6570(%s)\u8017\u65f6:%s ms", paramSb, topStopWatch.getTotalTimeMillis()));
                    if (!isExecutable) break block22;
                    isSuccess = true;
                    try {
                        try {
                            StopWatch execStopWatch = new StopWatch();
                            execStopWatch.start("\u5f00\u59cb\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b");
                            long[] result = statement.executeLargeBatch();
                            isSuccess = true;
                            execStopWatch.stop();
                            sb.append(String.format("(\u6267\u884c\u5b8c\u6bd5[\u6570\u91cf=%s]:)", valueWrappers.size()));
                            sb.append(String.format("\u5b58\u50a8\u8fc7\u7a0b\u603b\u5171\u8017\u65f6=%s ms", execStopWatch.getTotalTimeMillis()));
                            if (result != null) {
                                String affectedCount = Arrays.stream(result).mapToObj(String::valueOf).collect(Collectors.joining(","));
                                sb.append(String.format("\u5176\u4e2d\u603b\u5171\u6709%s\u6761\u53d7\u5f71\u54cd;", affectedCount));
                                affectedCountDesc = String.format("affected=%s;", affectedCount);
                                boolean notAffected = Arrays.stream(result).allMatch(ii -> ii < 1L);
                                if (notAffected) {
                                    String processSql = batchPlainSql.toString();
                                    Boolean hasProcessed = false;
                                    throw new AffectedEventException(processSql, valueWrappers.stream().map(ii -> ii.getFullTable()).distinct().collect(Collectors.joining(",")), valueWrappers.stream().map(ii -> ii.getId()).collect(Collectors.joining(",")));
                                }
                                break block23;
                            }
                            affectedCountDesc = "affected=NULL;";
                            throw new BadEventException(String.format("\u4e0d\u7b26\u5408\u9884\u671f(%s)", affectedCountDesc));
                        }
                        catch (RetryEventException ex) {
                            isSuccess = false;
                            throw ex;
                        }
                        catch (AffectedEventException ex) {
                            isSuccess = false;
                            throw ex;
                        }
                        catch (Exception ex) {
                            isSuccess = false;
                            if (ExceptionUtils.getStackTrace((Throwable)ex).contains("Incorrect")) {
                                throw new SkipRetryEventException(String.format("%s-\u3010\u4e0d\u8fdb\u884c\u91cd\u8bd5-v2\u3011\u6267\u884c(%s)\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38(\u53c2\u6570\u5f02\u5e38)", tranId, this.sql), ex);
                            }
                            throw new BadEventException(String.format("%s-\u5f71\u54cd\u7ed3\u679c(%s); fullTable=%s;ids=%s;", tranId, affectedCountDesc, valueWrappers.stream().map(ii -> ii.getFullTable()).distinct().collect(Collectors.joining(",")), valueWrappers.stream().map(ii -> ii.getId()).collect(Collectors.joining(","))), ex);
                        }
                    }
                    catch (Throwable throwable) {
                        topWatch.stop();
                        if (isSuccess) {
                            logger.error("{}[{}\u79d2]-[{}] -{} - {} id=[{}]", new Object[]{isSuccess ? "Success" : "Failed", topWatch.getTotalTimeSeconds(), tranId, affectedCountDesc, valueWrappers.stream().map(ii -> ii.getFullTable()).distinct().collect(Collectors.joining(",")), valueWrappers.stream().map(ii -> ii.getId()).collect(Collectors.joining(","))});
                        }
                        throw throwable;
                    }
                }
                topWatch.stop();
                if (isSuccess) {
                    logger.error("{}[{}\u79d2]-[{}] -{} - {} id=[{}]", new Object[]{isSuccess ? "Success" : "Failed", topWatch.getTotalTimeSeconds(), tranId, affectedCountDesc, valueWrappers.stream().map(ii -> ii.getFullTable()).distinct().collect(Collectors.joining(",")), valueWrappers.stream().map(ii -> ii.getId()).collect(Collectors.joining(","))});
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void run() {
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        try {
            if (this.batch == null) {
                sb.append("\u6682\u65e0\u6570\u636e");
            } else {
                sb.append(String.format("\u6279\u91cf\u6570\u636e=%s", this.batch.stream().filter(ii -> ii != null).map(ii -> String.valueOf(ii)).collect(Collectors.joining(";"))));
            }
            this.flush();
            flag = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            logger.error("\u7cfb\u7edf\u51fa\u73b0\u975e\u9884\u671f\u7684\u884c\u4e3a\u5bfc\u81f4\u5f02\u5e38: \u53ef\u80fd\u4e22\u5931\u7684\u6570\u636e\u4e3a:{}, \u6570\u636e\u5927\u5c0f={}", (Object)flag, (Object)sb);
        }
    }

    private void logError2Db(String message, int count, Exception exception, String businessIds, String dbTables) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            try {
                connection.setTransactionIsolation(2);
                try (PreparedStatement statement = connection.prepareStatement("INSERT INTO `companyinfocollect`.`collect_log_errors`(`business_id`,`count_of_error`, `status`,`business_table_name`, `message`, `exception`, `created_time`) VALUES (?,?,0, ?, ?, ?, CURRENT_TIMESTAMP)");){
                    statement.setObject(1, businessIds);
                    statement.setObject(2, count);
                    statement.setObject(3, dbTables);
                    statement.setObject(4, message);
                    String error = String.format("%s-%s", exception.getMessage(), ExceptionUtils.getStackTrace((Throwable)exception));
                    statement.setObject(5, error);
                    statement.execute();
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
            }
        }
        catch (Exception ex) {
            logger.error("\u63d0\u4ea4\u5f02\u5e38\u65e5\u5fd7\u5230\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38:{}", (Object)message, (Object)ex);
        }
    }

    private String extractPlainSql(Statement statement) {
        String sqlKeyword;
        String processSql = statement.toString();
        if (processSql.contains(sqlKeyword = "com.mysql.cj.jdbc.ClientPreparedStatement:")) {
            int index = processSql.indexOf(sqlKeyword);
            processSql = processSql.substring(index + sqlKeyword.length()).trim();
        }
        return processSql;
    }

    private static /* synthetic */ String lambda$executeSql$11(BinlogRawValue ii) {
        return ii.getId();
    }

    private static /* synthetic */ String lambda$executeSql$10(BinlogRawValue ii) {
        return ii.getFullTable();
    }
}

