/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks.components;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.core.utils.DebeziumUtil;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.flink.streaming.cores.utils.DebeziumJsonNodeDtoUtils;
import com.bcxin.tenant.data.etc.tasks.components.builder.DataBuilderDecorator;
import com.googlecode.aviator.AviatorEvaluator;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BinlogRawValue
implements Serializable {
    public static final String FIELD_ID = "id";
    public static final String FIELD_FULL_TABLE = "fullTable";
    public static final String FIELD_LAST_SYNC_VERSION = "lastSyncVersion";
    public static final String FIELD_PARTITION = "partition";
    private static final Logger logger = LoggerFactory.getLogger(BinlogRawValue.class);
    private String fullTable;
    private String id;
    private Date lastSyncVersion;
    private byte[] value;
    private int partition;
    private Map<String, Object> _parameters;
    private transient String conditionExecuteResult;

    public static BinlogRawValue create(byte[] value, JsonProvider jsonProvider) {
        BinlogRawValue rawValue = new BinlogRawValue();
        rawValue.setValue(value);
        rawValue.setLastSyncVersion(new Date());
        JSONObject contentNode = (JSONObject)jsonProvider.toObject(JSONObject.class, new String(value));
        rawValue.setLastSyncVersion(DebeziumJsonNodeDtoUtils.getLastSyncTimeValue((JSONObject)contentNode));
        JSONObject dataNode = contentNode.getJSONObject("after");
        if (dataNode == null) {
            dataNode = contentNode.getJSONObject("before");
        }
        if (dataNode == null) {
            throw new BadEventException(String.format("\u65e0\u6548\u8282\u70b9\u6570\u636e:%s", new String(value)));
        }
        Optional<String> selectedIdOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase(FIELD_ID)).findFirst();
        if (!selectedIdOptional.isPresent()) {
            selectedIdOptional = dataNode.keySet().stream().filter(ix -> ix.replace("_", "").equalsIgnoreCase("pkid")).findFirst();
        }
        if (!selectedIdOptional.isPresent()) {
            throw new BadEventException("\u627e\u4e0d\u5230\u4e3b\u952e\u914d\u7f6e; \u8bf7\u4fee\u6539\u6e90\u7801\u540e\u91cd\u65b0\u90e8\u7f72");
        }
        rawValue.setId(String.valueOf(dataNode.get((Object)selectedIdOptional.get())));
        JSONObject sourceDataNode = contentNode.getJSONObject("source");
        String fullTable = String.format("%s.%s", sourceDataNode.get((Object)"db"), sourceDataNode.get((Object)"table")).toLowerCase();
        rawValue.setFullTable(fullTable);
        return rawValue;
    }

    public void assignPartition(int partition) {
        this.setPartition(partition);
    }

    public Map<String, Object> getParameters(JsonProvider jsonProvider, CacheProvider cacheProvider, DockMapDbExtractor dbExtractor, boolean hasDependencyTable) {
        if (this._parameters == null) {
            this._parameters = this.getOriginalParameters(jsonProvider);
        }
        if (hasDependencyTable) {
            String hasAddedParameter = "hasAddedParameter";
            if (this._parameters != null && !this._parameters.containsKey("hasAddedParameter")) {
                String tableName = (String)this.getOriginalParameters(jsonProvider).get("source.table");
                if (StringUtils.hasLength((String)tableName)) {
                    try {
                        Map<String, Object> pv = DataBuilderDecorator.getInstance().build(cacheProvider, this._parameters, tableName, dbExtractor);
                        if (pv != null) {
                            pv.put("Decorator.Wrapper", true);
                        }
                        return pv;
                    }
                    catch (NoFoundEventException ex) {
                        String id = "";
                        Optional<String> idOptional = this._parameters.keySet().stream().filter(ix -> ix.equalsIgnoreCase("pkId") || ix.equalsIgnoreCase("pk_id")).findFirst();
                        if (idOptional.isPresent()) {
                            id = String.valueOf(this._parameters.get(idOptional.get()));
                        } else {
                            idOptional = this._parameters.keySet().stream().filter(ix -> ix.equalsIgnoreCase(FIELD_ID)).findFirst();
                            if (idOptional.isPresent()) {
                                id = String.valueOf(this._parameters.get(idOptional.get()));
                            }
                        }
                        logger.error("\u65e0\u6548[table={}]\u7684(id={})\u5f02\u5e38\u6570\u636e({}):\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u503c(\u539f\u53c2\u6570={})", new Object[]{tableName, id, ExceptionUtils.getMessage((Throwable)ex), new String(this.getValue())});
                    }
                }
                this._parameters.put("hasAddedParameter", Instant.now());
            }
        }
        return this._parameters;
    }

    public Map<String, Object> getOriginalParameters(JsonProvider jsonProvider) {
        if (this._parameters == null) {
            String jsonValue = new String(this.getValue());
            JSONObject valueJsonObject = (JSONObject)jsonProvider.toObject(JSONObject.class, jsonValue);
            this._parameters = new HashMap<String, Object>();
            this._parameters.put(FIELD_ID, this.getId());
            this._parameters.put(FIELD_FULL_TABLE, this.getFullTable());
            this._parameters.put(FIELD_PARTITION, this.getPartition());
            this._parameters.put(FIELD_LAST_SYNC_VERSION, this.getLastSyncVersion());
            this._parameters = this.buildParameters(this._parameters, "before", valueJsonObject.getJSONObject("before"));
            this._parameters = this.buildParameters(this._parameters, "after", valueJsonObject.getJSONObject("after"));
            this._parameters = this.buildParameters(this._parameters, "source", valueJsonObject.getJSONObject("source"));
        }
        return this._parameters;
    }

    private Map<String, Object> buildParameters(Map<String, Object> map, String prefix, JSONObject node) {
        if (node == null) {
            return map;
        }
        Iterator iterator = node.keySet().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object nodeValue;
                String nodeKey = (String)iterator.next();
                String key = nodeKey.toLowerCase();
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
                    key = String.format("%s.%s", prefix, nodeKey);
                }
                if ((nodeValue = node.get((Object)nodeKey)) == null) {
                    map.put(key, null);
                    continue;
                }
                if (FlinkConstants.isDateTimeField((String)nodeKey) && (String.valueOf(nodeValue).contains("0000-00-00") || String.valueOf(nodeValue).contains("9999-"))) {
                    nodeValue = null;
                }
                if (nodeValue instanceof Number) {
                    try {
                        if (FlinkConstants.isDateTimeField((String)nodeKey)) {
                            Date date = new Date(BinlogRawValue.getTimeValue(nodeKey, nodeValue));
                            map.put(key, DateUtils.addHours((Date)date, (int)-8));
                            continue;
                        }
                        map.put(key, nodeValue);
                    }
                    catch (Exception ex) {
                        map.put(key, nodeValue);
                    }
                    continue;
                }
                map.put(key, nodeValue);
            }
        }
        return map;
    }

    private static long getTimeValue(String key, Object value) {
        try {
            String xValue = String.valueOf(value);
            if (xValue.length() < 8) {
                return DebeziumUtil.translate2ValueInMils((long)Long.parseLong(String.valueOf(value)));
            }
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception ex) {
            logger.error("key={};value={};\u8f6c\u6362\u51fa\u9519=%s;\u5c1d\u8bd5\u8f6c\u4e3aDouble", new Object[]{key, value, ex});
            return (long)Double.parseDouble(String.valueOf(value));
        }
    }

    public Object getReadyParameter(String name) {
        if (CollectionUtils.isEmpty(this._parameters)) {
            throw new BadEventException("\u65e0\u6548\u6570\u636e");
        }
        Optional<String> keyOptional = this._parameters.keySet().stream().filter(ix -> {
            String key = ix;
            String expected = name;
            return key.equalsIgnoreCase(expected) || key.equalsIgnoreCase(String.format("before.%s", expected)) || key.equalsIgnoreCase(String.format("after.%s", expected));
        }).findFirst();
        if (!keyOptional.isPresent()) {
            return null;
        }
        return this._parameters.get(keyOptional.get());
    }

    public Object getReadyPkId() {
        Object id = this.getReadyParameter("before.id");
        if (id == null) {
            id = this.getReadyParameter("after.id");
        }
        if (id == null) {
            id = this.getReadyParameter("before.pk_id");
        }
        if (id == null) {
            id = this.getReadyParameter("after.pk_id");
        }
        if (id == null) {
            id = this.getReadyParameter("before.pkId");
        }
        if (id == null) {
            id = this.getReadyParameter("after.pkId");
        }
        return id;
    }

    public Object getReadyTable() {
        Object table = this.getReadyParameter("source.table");
        return table;
    }

    protected Map<String, String> getExtendParameters() {
        return Collections.EMPTY_MAP;
    }

    public boolean isMatchCondition(JsonProvider jsonProvider, Collection<String> batchOrConditionExpress) {
        Map<String, Object> params = this.getOriginalParameters(jsonProvider);
        if (!CollectionUtils.isEmpty(batchOrConditionExpress)) {
            String conditionExpress = null;
            try {
                conditionExpress = batchOrConditionExpress.stream().filter(ii -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ii)).map(ii -> {
                    Collection variables = Arrays.stream(ii.split("}")).map(ix -> {
                        if (ix.startsWith("#{")) {
                            return ix;
                        }
                        if (ix.contains("#{")) {
                            return ix.substring(ix.indexOf("#"));
                        }
                        return null;
                    }).filter(ix -> ix != null).collect(Collectors.toList());
                    String express = ii;
                    for (String vKey : variables) {
                        Optional<String> keyOptional = params.keySet().stream().filter(ix -> ix.equalsIgnoreCase(vKey.substring(2))).findFirst();
                        if (keyOptional.isPresent()) {
                            Object kValue = params.get(keyOptional.get());
                            express = express.replace(String.format("%s}", vKey), kValue == null ? "\"\"" : String.format("\"%s\"", kValue));
                            continue;
                        }
                        express = express.replace(String.format("%s}", vKey), "\"\"");
                    }
                    return express;
                }).collect(Collectors.joining(" || "));
                Object result = AviatorEvaluator.execute((String)conditionExpress);
                boolean flag = result != null && !String.valueOf(result).equalsIgnoreCase("false");
                this.setConditionExecuteResult(String.format("\u539f\u6765\u8868\u8fbe\u5f0f=\u3010%s\u3011;\u89e3\u6790\u540e\u8868\u8fbe\u5f0f=\u3010%s\u3011; \u89e3\u6790\u540e\u503c=\u3010%s\u3011; \u8fd4\u56de\u7ed3\u679c=\u3010%s\u3011;", batchOrConditionExpress.stream().filter(ix -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ix)).collect(Collectors.joining(";")), conditionExpress, result, flag));
                return flag;
            }
            catch (Exception ex) {
                logger.error("\u6761\u4ef6\u5339\u914d\u6267\u884c\u53d1\u751f\u5f02\u5e38:{};conditionExpress={}; \u5f02\u5e38={}", new Object[]{batchOrConditionExpress.stream().collect(Collectors.joining(" ; ")), conditionExpress, ex});
            }
        }
        return true;
    }

    public String getFullTable() {
        return this.fullTable;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastSyncVersion() {
        return this.lastSyncVersion;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getPartition() {
        return this.partition;
    }

    public Map<String, Object> get_parameters() {
        return this._parameters;
    }

    public String getConditionExecuteResult() {
        return this.conditionExecuteResult;
    }

    public void setFullTable(String fullTable) {
        this.fullTable = fullTable;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastSyncVersion(Date lastSyncVersion) {
        this.lastSyncVersion = lastSyncVersion;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public void set_parameters(Map<String, Object> _parameters) {
        this._parameters = _parameters;
    }

    public void setConditionExecuteResult(String conditionExecuteResult) {
        this.conditionExecuteResult = conditionExecuteResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogRawValue)) {
            return false;
        }
        BinlogRawValue other = (BinlogRawValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartition() != other.getPartition()) {
            return false;
        }
        String this$fullTable = this.getFullTable();
        String other$fullTable = other.getFullTable();
        if (this$fullTable == null ? other$fullTable != null : !this$fullTable.equals(other$fullTable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$lastSyncVersion = this.getLastSyncVersion();
        Date other$lastSyncVersion = other.getLastSyncVersion();
        if (this$lastSyncVersion == null ? other$lastSyncVersion != null : !((Object)this$lastSyncVersion).equals(other$lastSyncVersion)) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        Map<String, Object> this$_parameters = this.get_parameters();
        Map<String, Object> other$_parameters = other.get_parameters();
        return !(this$_parameters == null ? other$_parameters != null : !((Object)this$_parameters).equals(other$_parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogRawValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartition();
        String $fullTable = this.getFullTable();
        result = result * 59 + ($fullTable == null ? 43 : $fullTable.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $lastSyncVersion = this.getLastSyncVersion();
        result = result * 59 + ($lastSyncVersion == null ? 43 : ((Object)$lastSyncVersion).hashCode());
        result = result * 59 + Arrays.hashCode(this.getValue());
        Map<String, Object> $_parameters = this.get_parameters();
        result = result * 59 + ($_parameters == null ? 43 : ((Object)$_parameters).hashCode());
        return result;
    }

    public String toString() {
        return "BinlogRawValue(fullTable=" + this.getFullTable() + ", id=" + this.getId() + ", lastSyncVersion=" + this.getLastSyncVersion() + ", value=" + Arrays.toString(this.getValue()) + ", partition=" + this.getPartition() + ", _parameters=" + this.get_parameters() + ", conditionExecuteResult=" + this.getConditionExecuteResult() + ")";
    }
}

