/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.tasks;

import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.flink.streaming.cores.SystemPropertyUtil;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import com.bcxin.flink.streaming.cores.properties.impls.DiskCheckpointConfigPropertyImpl;
import com.bcxin.tenant.data.etc.tasks.jobs.DataEtcJob;
import com.bcxin.tenant.data.etc.tasks.properties.DataEtcConfigProperty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataEtcApp {
    private static final Logger logger = LoggerFactory.getLogger(DataEtcApp.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new BadEventException("\u5fc5\u987b\u4f20\u9012\u73af\u5883\u4fe1\u606f\u548c\u8f68\u8ff9\u914d\u7f6e\u6587\u4ef6\u5305\u540d\u79f0(configs/\u73af\u5883/\u5e95\u4e0b\u7684\u6587\u4ef6\u540d)");
        }
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        String env = parameterTool.get("env");
        String configFile = parameterTool.get("configFile");
        boolean isDebug = false;
        CheckpointConfigProperty checkpointConfigProperty = DataEtcApp.getCheckpointConfigProperty(env, configFile, parameterTool, isDebug);
        Collection<DataEtcConfigProperty> configProperties = DataEtcApp.getDataExcConfigs(env, configFile);
        String invalidConfigTopics = configProperties.stream().flatMap(ix -> ix.getTopicSubscribers().stream()).filter(ix -> !StringUtils.hasLength((String)ix.getUid())).map(ix -> ix.getTopic()).collect(Collectors.joining(";"));
        if (StringUtils.hasLength((String)invalidConfigTopics)) {
            throw new BadEventException(String.format("uid\u4e0d\u80fd\u4e3a\u7a7a; \u65e0\u6548\u7684\u4e3b\u9898(topic=%s)\u914d\u7f6e", invalidConfigTopics));
        }
        if (StringUtils.hasLength((String)invalidConfigTopics)) {
            String invalidConfigTopicsSubscriberContents = configProperties.stream().flatMap(ix -> ix.getTopicSubscribers().stream()).flatMap(ix -> ix.getSubscriberContents().stream()).filter(ix -> !StringUtils.hasLength((String)ix.getUid())).map(ix -> ix.getTitle()).collect(Collectors.joining(";"));
            throw new BadEventException(String.format("uid\u4e0d\u80fd\u4e3a\u7a7a; \u65e0\u6548\u7684\u8ba2\u9605(title=%s)\u914d\u7f6e", invalidConfigTopicsSubscriberContents));
        }
        DataEtcJob job = new DataEtcJob(checkpointConfigProperty, configProperties, env, configFile, isDebug);
        job.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<DataEtcConfigProperty> getDataExcConfigs(String env, String configFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            JsonProviderImpl jsonProvider = new JsonProviderImpl();
            ClassLoader classLoader = DataEtcJob.class.getClassLoader();
            HashSet<DataEtcConfigProperty> configProperties = new HashSet<DataEtcConfigProperty>();
            sb.append(String.format("\u6b63\u5728\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:%s;", configFile));
            try (InputStream coreStream = classLoader.getResourceAsStream(String.format("configs/%s/%s.json", env, configFile));){
                if (coreStream == null) {
                    throw new BadEventException(String.format("v2.\u627e\u4e0d\u5230\u8be5\u73af\u5883\u914d\u7f6e:%s \u53ca\u5176\u6587\u4ef6:%s", env, configFile));
                }
                String content = IOUtils.toString((InputStream)coreStream, (Charset)Charsets.toCharset((String)"UTF-8"));
                DataEtcConfigProperty configProperty = (DataEtcConfigProperty)jsonProvider.toObject(DataEtcConfigProperty.class, content);
                configProperties.add(configProperty);
            }
            System.setProperty("ENV", env);
            System.setProperty("CONFIG_FILE", configFile);
            HashSet<DataEtcConfigProperty> hashSet = configProperties;
            return hashSet;
        }
        finally {
            logger.error("\u6b63\u5728\u542f\u52a8\u52a0\u8f7d\u914d\u7f6e\u4fe1\u606f:\u73af\u5883={};\u6d88\u606f={}", (Object)env, (Object)sb);
        }
    }

    private static CheckpointConfigProperty getCheckpointConfigProperty(String env, String businessSubPath, ParameterTool parameterTool, boolean isDebug) throws IOException {
        Properties properties = System.getProperties();
        ClassLoader classLoader = SystemPropertyUtil.class.getClassLoader();
        try (InputStream coreStream = classLoader.getResourceAsStream(String.format("configs/%s/flink-point.properties", env));){
            if (coreStream == null) {
                throw new BadEventException(String.format("\u627e\u4e0d\u5230\u8be5\u73af\u5883\u914d\u7f6e:%s", env));
            }
            properties.load(coreStream);
        }
        properties.put("PARAM_ENV", env);
        DiskCheckpointConfigPropertyImpl configProperty = DiskCheckpointConfigPropertyImpl.create((String)businessSubPath, (ParameterTool)parameterTool);
        return configProperty;
    }
}

