package com.bcxin.tenant.data.etc.tasks.properties;

import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@Data
public class DataEtcConfigProperty  implements Serializable {
    private String title;
    private Collection<JdbcConnectionConfigProperty> jdbcConnections;
    private Collection<KafkaConnectionConfigProperty> kafkaConnections;
    private Collection<TopicSubscriberConfigProperty> topicSubscribers;
    private Collection<RedisConnectionConfigProperty> redisConnections;
    private int batchSize;
    private int batchIntervalMs;
    private String groupId;
    private String regionPrefix;

    @Data
    public static class JdbcConnectionConfigProperty implements Serializable {
        private String name;
        private String url;
        private String userName;
        private String password;
        private String driverClassName;
    }

    @Data
    public static class KafkaConnectionConfigProperty implements Serializable {
        private String name;
        private String bootstrapServer;
    }

    @Data
    public static class RedisConnectionConfigProperty implements Serializable {
        private String name;
        private String host;
        private int port;
        private String password;
        private Integer db;
    }

    @Data
    public static class TopicSubscriberConfigProperty implements Serializable {
        private String uid;
        private String topic;
        private String refKafkaName;

        private Collection<JdbcSubscriberContentConfigProperty> subscriberContents;
    }

    @Data
    public static class JdbcSubscriberContentConfigProperty implements Serializable {
        private String uid;
        private String title;
        private String refJdbcName;
        private String content;
        private SubscriberType type;
        private String conditionExpress;

        private Collection<ConnectedRedisSubscriberStructureInfo> connectedRedisData;
    }

    public static enum SubscriberType {
        JDBC,
        HTTP,
        SyncSameJDBC,
        Redis
    }

    @Getter
    public static class TmpMergedKafkaConnectionTopicInfo implements Serializable {
        private final KafkaConnectionConfigProperty kafkaConnection;
        private final Collection<String> topics;

        public TmpMergedKafkaConnectionTopicInfo(KafkaConnectionConfigProperty kafkaConnection) {

            this.kafkaConnection = kafkaConnection;
            this.topics = new HashSet<>();
        }


        public void addTopic(String topic) {
            this.topics.add(topic);
        }

        public static TmpMergedKafkaConnectionTopicInfo create(KafkaConnectionConfigProperty kafkaConnection) {
            return new TmpMergedKafkaConnectionTopicInfo(kafkaConnection);
        }
    }

    @Data
    public static class ConnectedRedisSubscriberStructureInfo implements Serializable {
        private String keyPattern;
        private String aliasName;
    }
}