package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * 项目合同信息
 */
public class TenantContractDataBuilder extends BusinessDataBuilder {
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        data = super.build(cacheProvider, data, tableName, dbExtractor);
        String employeeId = (String) getKeyValue(data, "after.employee_id");
        if (StringUtils.hasLength(employeeId)) {
            Map<String, String> employeeMap = cacheProvider.getDocumentFromCache(DocumentType.Employee, employeeId, dbExtractor);

            String tenantUserId = null;
            if (employeeMap != null && employeeMap.size() > 1) {
                for (String hKey : employeeMap.keySet()) {
                    data.put(String.format("employee.%s", hKey), formatValue(hKey, employeeMap.get(hKey)));

                    if (hKey.equalsIgnoreCase("tenant_user_id")) {
                        tenantUserId = employeeMap.get(hKey);
                    }
                }
            }

            if (StringUtils.hasLength(tenantUserId)) {
                Map<String, String> userMap = cacheProvider.getDocumentFromCache(DocumentType.User, tenantUserId, dbExtractor);
                if (userMap != null && userMap.size() > 1) {
                    for (String hKey : userMap.keySet()) {
                        data.put(String.format("user.%s", hKey), formatValue(hKey, userMap.get(hKey)));
                    }
                }
            }
        }

        return data;
    }
}
