package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import java.util.Map;

/**
 * 平台数据; 比如: tenant_开头的非职员数据等
 */
public class PlatformDataBuilder extends DataBuilderAbstract{
    private static final Logger logger = LoggerFactory.getLogger(PlatformDataBuilder.class);
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data,
                                     String tableName, DockMapDbExtractor dbExtractor) {
        StringBuilder sb = new StringBuilder();
        if (tableName.equalsIgnoreCase("tenant_user_credential_details")) {
            Object objValue = null;
            try {
                objValue = getKeyValue(data, "after.tenant_user_id");
                String tenantUserId = null;
                try {
                    tenantUserId = (String) objValue;
                } catch (Exception ex) {
                }

                boolean isNotMatch = false;
                if (StringUtils.hasLength(tenantUserId)) {
                    String beforeCertificateType = (String) getKeyValue(data, "before.certificateType");
                    String afterCertificateType = (String) getKeyValue(data, "after.certificateType");
                    String certificateType = StringUtils.hasLength(afterCertificateType) ? afterCertificateType : beforeCertificateType;

                    if (certificateType.equalsIgnoreCase("1") || certificateType.equalsIgnoreCase("2")) {
                        isNotMatch = true;
                        cacheProvider.expireCache(DocumentType.User_Business_Credentials, tenantUserId);

                        String idNum = (String) getKeyValue(data, "after.idnum");
                        if (certificateType.equalsIgnoreCase("1") && StringUtils.hasLength(idNum)) {
                            cacheProvider.expireCache(DocumentType.ZsbhByIdCardNo, idNum);
                        }
                    }
                }

                if (!isNotMatch) {
                    logger.warn(String.format("TenantUserId(%s)信息非预期无效(id=%s)!", tenantUserId, getKeyValue(data, "after.id")));
                }
            } catch (Exception ex) {
                ex.printStackTrace();
                logger.error("数据系统异常:{},value={}, 异常={}", tableName, objValue, ExceptionUtils.getStackTrace(ex));
                throw ex;
            }
        } else if (tableName.equalsIgnoreCase("tenant_users")) {
            String tenantUserId = (String) getKeyValue(data, "after.id");
            Integer beforeCheckedStatus = (Integer) getKeyValue(data, "before.checked_status");
            Integer checkedStatus = (Integer) getKeyValue(data, "after.checked_status");
            if (checkedStatus != null && (beforeCheckedStatus == null || beforeCheckedStatus.intValue() != checkedStatus.intValue())) {
                data = this.bindUserBusinessData(tenantUserId, data, cacheProvider, dbExtractor);
            }
            sb.append(String.format("tenantUserId=%s", tenantUserId));
        } 
        
        return data;
    }
}
