package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.springframework.util.StringUtils;

import java.sql.Connection;
import java.util.Map;

/**
 * Employee的子类； 仅用于获取职员的信息
 */
public class AttendanceSitePersonDataBuilder extends EmployeeDataBuilder {
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName,
                                     DockMapDbExtractor dbExtractor) {
        data = super.build(cacheProvider, data, tableName, dbExtractor);

        return buildCertificateDetail(cacheProvider, data, tableName, dbExtractor);
    }

    private Map<String, Object> buildCertificateDetail(CacheProvider cacheProvider,
                                                       Map<String, Object> data, String tableName,
                                                       DockMapDbExtractor dbExtractor) {
        String documentNo = (String) getKeyValue(data, "after.ITEM_DOCUMENTID");
        if (StringUtils.hasLength(documentNo) && documentNo.length() > 10) {
            Map<String, String> zsbhByIdCardNoMap =
                    cacheProvider.getDocumentFromCache(DocumentType.ZsbhByIdCardNo,
                            documentNo, dbExtractor);
            if (zsbhByIdCardNoMap != null && zsbhByIdCardNoMap.size() > 1) {
                for (String hKey : zsbhByIdCardNoMap.keySet()) {
                    data.put(String.format("certificate.%s", hKey), formatValue(hKey, zsbhByIdCardNoMap.get(hKey)));
                }
            }
        }

        return data;
    }
}
