package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.springframework.util.StringUtils;

import java.sql.Connection;
import java.util.Map;

public class AttendanceSiteDataBuilder extends BusinessDataBuilder{
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data,
                                     String tableName, DockMapDbExtractor dbExtractor) {
        data = super.build(cacheProvider, data, tableName, dbExtractor);

        String employeeId = (String) getKeyValue(data, "after.ITEM_principal");

        if (!StringUtils.hasLength(employeeId)) {
            return data;
        }

        /**
         * 为了取职员的驻勤信息
         */
        Map<String, String> employeeMap = cacheProvider.getDocumentFromCache(DocumentType.Employee,
                employeeId, dbExtractor);
        if (employeeMap != null) {
            for (String hKey : employeeMap.keySet()) {
                data.put(String.format("employee.%s", hKey), formatValue(hKey, employeeMap.get(hKey)));
            }

            String userId = employeeMap.get("tenant_user_id");
            if (StringUtils.hasLength(userId)) {
                Map<String, String> userMap = cacheProvider.getDocumentFromCache(DocumentType.User, userId, dbExtractor);
                if (userMap != null) {
                    for (String hKey : userMap.keySet()) {
                        data.put(String.format("user.%s", hKey), formatValue(hKey, userMap.get(hKey)));
                    }
                }
            }
        }

        return data;
    }
}
