package com.bcxin.tenant.data.etc.tasks.components;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Data
public class TableMapSnapshot implements Serializable {
    private String tableName;
    private Collection<Column> columns;
    private String sqlMapping;
    private boolean autoMap;

    public void addColumn(String fieldName, Object defaultValue) {
        Collection<Column> tmpColumns = this.getColumns();
        if (tmpColumns == null) {
            tmpColumns = new ArrayList<>();
            this.setColumns(tmpColumns);
        }

        tmpColumns.add(Column.add(fieldName, defaultValue));
    }

    public void addColumnWithFixedValue(String fieldName, Object fixedValue) {
        Collection<Column> tmpColumns = this.getColumns();
        if (tmpColumns == null) {
            tmpColumns = new ArrayList<>();
            this.setColumns(tmpColumns);
        }

        Column column = Column.add(fieldName, fixedValue);
        column.setFixedValue(fixedValue);
        tmpColumns.add(column);
    }

    @Data
    public static class Column implements Serializable{
        private String fieldName;
        private Object defaultValue;
        private Object fixedValue;
        private boolean onlyForNew;

        public static Column add(String fieldName, Object defaultValue) {
            Column column = new Column();
            column.setFieldName(fieldName);
            column.setDefaultValue(defaultValue);

            return column;
        }
    }
}